/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.recipe.QuantumComputerRecipeData;
import gregtech.mixin.interfaces.accessors.EntityPlayerMPAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.TecTech;
import tectech.loader.ConfigHandler;
import tectech.thing.gui.TecTechUITextures;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEHatchRack
extends MTEHatch
implements IAddGregtechLogo,
IAddUIWidgets {
    private static Textures.BlockIcons.CustomIcon EM_R;
    private static Textures.BlockIcons.CustomIcon EM_R_ACTIVE;
    public int heat = 0;
    private float overClock = 1.0f;
    private float overVolt = 1.0f;
    private static final Map<String, RackComponent> componentBinds;
    private String clientLocale = "en_US";

    public MTEHatchRack(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.rack.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.rack.desc.1")}, new ITexture[0]);
    }

    public MTEHatchRack(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("eHeat", this.heat);
        aNBT.func_74776_a("eOverClock", this.overClock);
        aNBT.func_74776_a("eOverVolt", this.overVolt);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.heat = aNBT.func_74762_e("eHeat");
        this.overClock = aNBT.func_74760_g("eOverClock");
        this.overVolt = aNBT.func_74760_g("eOverVolt");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_R_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/EM_RACK_ACTIVE");
        EM_R = new Textures.BlockIcons.CustomIcon("iconsets/EM_RACK");
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(EM_R_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(EM_R)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchRack(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (aBaseMetaTileEntity.isActive() || this.heat > 2000) {
            return false;
        }
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (aBaseMetaTileEntity.isActive() || this.heat > 2000) {
            return false;
        }
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public int func_70302_i_() {
        return this.heat > 2000 || this.getBaseMetaTileEntity().isActive() ? 0 : this.mInventory.length;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer instanceof EntityPlayerMPAccessor) {
            this.clientLocale = ((EntityPlayerMPAccessor)aPlayer).gt5u$getTranslator();
        }
        this.openGui(aPlayer);
        return true;
    }

    private int getComputationPower(float overclock, float overvolt, boolean tickingComponents) {
        float computation = 0.0f;
        float heat = 0.0f;
        for (int i = 0; i < this.mInventory.length; ++i) {
            RackComponent comp;
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a != 1 || (comp = componentBinds.get(TTUtility.getUniqueIdentifier(this.mInventory[i]))) == null) continue;
            if (tickingComponents) {
                if ((float)this.heat > comp.maxHeat) {
                    this.mInventory[i] = null;
                    continue;
                }
                if (!comp.subZero && this.heat < 0) continue;
                heat += (1.0f + comp.coolConstant * (float)this.heat / 100000.0f) * (comp.heatConstant > 0.0f ? comp.heatConstant * overclock * overvolt * overvolt : -10.0f);
                if (!(overvolt > TecTech.RANDOM.nextFloat())) continue;
                computation += comp.computation * (1.0f + overclock * overclock) / (1.0f + (overclock - overvolt) * (overclock - overvolt));
                continue;
            }
            computation += comp.computation * (1.0f + overclock * overclock) / (1.0f + (overclock - overvolt) * (overclock - overvolt));
        }
        if (tickingComponents) {
            this.heat = (int)((double)this.heat + Math.ceil(heat));
        }
        return (int)Math.floor(computation);
    }

    public int tickComponents(float oc, float ov) {
        this.overClock = oc;
        this.overVolt = ov;
        return this.getComputationPower(this.overClock, this.overVolt, true);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 12L && this.heat > 0) {
            float heatC = 0.0f;
            for (int i = 0; i < this.mInventory.length; ++i) {
                RackComponent comp;
                if (this.mInventory[i] == null || this.mInventory[i].field_77994_a != 1 || (comp = componentBinds.get(TTUtility.getUniqueIdentifier(this.mInventory[i]))) == null) continue;
                if ((float)(this.heat - 20) > comp.maxHeat) {
                    this.mInventory[i] = null;
                    continue;
                }
                if (!(comp.heatConstant < 0.0f)) continue;
                heatC += comp.heatConstant * ((float)this.heat / 10000.0f);
            }
            this.heat = (int)((double)this.heat + Math.max((double)(-this.heat), Math.ceil(heatC)));
            this.heat -= Math.max(this.heat / 1000, 20);
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Base_computation", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.getComputationPower(this.overClock, this.overVolt, false), StatCollector.func_74837_a((String)"tt.keyphrase.Heat_Accumulated", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + this.heat + EnumChatFormatting.RESET};
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_TECTECH_LOGO).setSize(18, 18).setPos(151, 63));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_HEAT_SINK).setPos(46, 17).setSize(84, 60));
        Pos2d[] positions = new Pos2d[]{new Pos2d(68, 27), new Pos2d(90, 27), new Pos2d(68, 49), new Pos2d(90, 49)};
        for (int i = 0; i < positions.length; ++i) {
            builder.widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, i){

                public int func_75219_a() {
                    return 1;
                }

                public boolean isEnabled() {
                    return !MTEHatchRack.this.getBaseMetaTileEntity().isActive() && MTEHatchRack.this.heat <= 0;
                }
            }).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), TecTechUITextures.OVERLAY_SLOT_RACK}).setPos(positions[i]));
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BUTTON_STANDARD_LIGHT_16x16).setPos(152, 24).setSize(16, 16))).widget(new DrawableWidget().setDrawable(() -> this.getBaseMetaTileEntity().isActive() ? TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON : TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_DISABLED).setPos(152, 24).setSize(16, 16))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BUTTON_STANDARD_LIGHT_16x16).setPos(152, 41).setSize(16, 16))).widget(new DrawableWidget().setDrawable(() -> this.heat > 0 ? TecTechUITextures.OVERLAY_BUTTON_HEAT_ON : TecTechUITextures.OVERLAY_BUTTON_HEAT_OFF).setPos(152, 41).setSize(16, 16))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.heat, val -> {
                this.heat = val;
            }));
        }
    }

    public static void run() {
        new RackComponent(ItemList.Circuit_Crystalprocessor.get(1L, new Object[0]), 60.0f, 56.0f, -1.0f, 2000.0f, true);
        new RackComponent(ItemList.Circuit_Crystalcomputer.get(1L, new Object[0]), 80.0f, 54.0f, -1.0f, 2000.0f, true);
        new RackComponent(ItemList.Circuit_Ultimatecrystalcomputer.get(1L, new Object[0]), 100.0f, 52.0f, -1.0f, 2000.0f, true);
        new RackComponent(ItemList.Circuit_Crystalmainframe.get(1L, new Object[0]), 120.0f, 50.0f, -1.0f, 2000.0f, true);
        new RackComponent(ItemList.Circuit_Neuroprocessor.get(1L, new Object[0]), 160.0f, 46.0f, -1.0f, 4000.0f, true);
        new RackComponent(ItemList.Circuit_Wetwarecomputer.get(1L, new Object[0]), 180.0f, 44.0f, -1.0f, 4000.0f, true);
        new RackComponent(ItemList.Circuit_Wetwaresupercomputer.get(1L, new Object[0]), 200.0f, 42.0f, -1.0f, 4000.0f, true);
        new RackComponent(ItemList.Circuit_Wetwaremainframe.get(1L, new Object[0]), 220.0f, 40.0f, -1.0f, 4000.0f, true);
        new RackComponent(GTModHandler.getIC2Item("reactorVent", 1L), 0.0f, -1.0f, 40.0f, 2000.0f, false);
        new RackComponent(GTModHandler.getIC2Item("reactorVentCore", 1L), 0.0f, -1.0f, 80.0f, 4000.0f, false);
        new RackComponent(GTModHandler.getIC2Item("reactorVentGold", 1L), 0.0f, -1.0f, 120.0f, 6000.0f, false);
        new RackComponent(GTModHandler.getIC2Item("reactorVentDiamond", 1L), 0.0f, -1.0f, 160.0f, 8000.0f, false);
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            new RackComponent(ItemList.Circuit_Bioprocessor.get(1L, new Object[0]), 200.0f, 36.0f, -1.0f, 6000.0f, true);
            new RackComponent(ItemList.Circuit_Biowarecomputer.get(1L, new Object[0]), 220.0f, 34.0f, -1.0f, 6000.0f, true);
            new RackComponent(ItemList.Circuit_Biowaresupercomputer.get(1L, new Object[0]), 240.0f, 32.0f, -1.0f, 6000.0f, true);
            new RackComponent(ItemList.Circuit_Biomainframe.get(1L, new Object[0]), 260.0f, 30.0f, -1.0f, 6000.0f, true);
            new RackComponent(ItemList.Circuit_OpticalProcessor.get(1L, new Object[0]), 200.0f, 26.0f, -1.0f, 8000.0f, true);
            new RackComponent(ItemList.Circuit_OpticalAssembly.get(1L, new Object[0]), 220.0f, 24.0f, -1.0f, 8000.0f, true);
            new RackComponent(ItemList.Circuit_OpticalComputer.get(1L, new Object[0]), 240.0f, 22.0f, -1.0f, 8000.0f, true);
            new RackComponent(ItemList.Circuit_OpticalMainframe.get(1L, new Object[0]), 260.0f, 20.0f, -1.0f, 8000.0f, true);
            new RackComponent(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PikoCircuit", 1L), 260.0f, 12.0f, -1.0f, 9500.0f, true);
            new RackComponent(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.QuantumCircuit", 1L), 320.0f, 10.0f, -1.0f, 10000.0f, true);
        }
        if (Mods.OpenComputers.isModLoaded()) {
            new RackComponent(GTModHandler.getModItem(Mods.OpenComputers.ID, "item", 1L, 43), 80.0f, 46.0f, -1.0f, 2000.0f, true);
            new RackComponent(GTModHandler.getModItem(Mods.OpenComputers.ID, "item", 1L, 10), 100.0f, 44.0f, -1.0f, 2000.0f, true);
            new RackComponent(GTModHandler.getModItem(Mods.OpenComputers.ID, "item", 1L, 102), 120.0f, 42.0f, -1.0f, 2000.0f, true);
            new RackComponent(GTModHandler.getModItem(Mods.OpenComputers.ID, "item", 1L, 103), 240.0f, 40.0f, -1.0f, 2000.0f, true);
        }
        if (Mods.GraviSuite.isModLoaded()) {
            new RackComponent(GTModHandler.getModItem(Mods.GraviSuite.ID, "itemSimpleItem", 1L, 2), 0.0f, -1.0f, 200.0f, 10000.0f, false);
        }
    }

    static {
        componentBinds = new HashMap<String, RackComponent>();
    }

    public static class RackComponent
    implements Comparable<RackComponent> {
        private final String unlocalizedName;
        private final float heatConstant;
        private final float coolConstant;
        private final float computation;
        private final float maxHeat;
        private final boolean subZero;

        RackComponent(ItemStack is, float computation, float heatConstant, float coolConstant, float maxHeat, boolean subZero) {
            this(TTUtility.getUniqueIdentifier(is), computation, heatConstant, coolConstant, maxHeat, subZero);
            GTValues.RA.stdBuilder().itemInputs(is).metadata(GTRecipeConstants.QUANTUM_COMPUTER_DATA, new QuantumComputerRecipeData(heatConstant, coolConstant, computation, maxHeat, subZero)).duration(0).eut(0).fake().addTo(RecipeMaps.quantumComputerFakeRecipes);
        }

        RackComponent(String is, float computation, float heatConstant, float coolConstant, float maxHeat, boolean subZero) {
            this.unlocalizedName = is;
            this.computation = computation;
            this.heatConstant = heatConstant;
            this.coolConstant = coolConstant;
            this.maxHeat = maxHeat;
            this.subZero = subZero;
            componentBinds.put(this.unlocalizedName, this);
            if (ConfigHandler.debug.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Component registered: " + this.unlocalizedName));
            }
        }

        @Override
        public int compareTo(RackComponent o) {
            return this.unlocalizedName.compareTo(o.unlocalizedName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RackComponent) {
                return this.compareTo((RackComponent)obj) == 0;
            }
            return false;
        }
    }
}

