/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.hatch.MTEHatchOutputBeamline;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.tileentity.recipe.beamline.SourceChamberMetadata;
import gtnhlanth.util.DescTextLocalization;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTESourceChamber
extends MTEEnhancedMultiBlockBase<MTESourceChamber>
implements ISurvivalConstructable {
    private static final IStructureDefinition<MTESourceChamber> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("sc", (String[][])new String[][]{{"ccccc", "ckkkc", "ckikc", "ckkkc", "dd~dd"}, {"ckkkc", "keeek", "ke-ek", "keeek", "ccocc"}, {"ckkkc", "k---k", "k---k", "k---k", "ccccc"}, {"ckkkc", "k---k", "k---k", "k---k", "ccccc"}, {"ckkkc", "keeek", "ke-ek", "keeek", "ccccc"}, {"ccccc", "ckkkc", "ckbkc", "ckkkc", "ccccc"}}).addElement('c', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0)).addElement('k', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_GLASS, (int)0)).addElement('e', StructureUtility.ofBlock((Block)LanthItemList.ELECTRODE_CASING, (int)0)).addElement('b', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).hatchClass(MTEHatchOutputBeamline.class).casingIndex(1662).dot(4).adder(MTESourceChamber::addBeamLineOutputHatch).build()).addElement('i', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).atLeast(HatchElement.InputBus).casingIndex(1662).dot(1).build()).addElement('o', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).atLeast(HatchElement.OutputBus).casingIndex(1662).dot(2).build()).addElement('d', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).atLeast(HatchElement.Maintenance, HatchElement.Energy).casingIndex(1662).dot(3).buildAndChain(StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0))).build();
    private final ArrayList<MTEHatchOutputBeamline> mOutputBeamline = new ArrayList();
    private static final int CASING_INDEX = 1662;
    private float outputEnergy;
    private int outputRate;
    private int outputParticle;
    private float outputFocus;

    public MTESourceChamber(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public MTESourceChamber(String name) {
        super(name);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("sc", stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity te) {
        return new MTESourceChamber(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Particle Source").addInfo("Creates beams of Particles").addInfo(DescTextLocalization.BEAMLINE_SCANNER_INFO).addSeparator().addInfo("NEI shows the minimum " + EnumChatFormatting.AQUA + "EU/t requirement" + EnumChatFormatting.GRAY + ", Beam Focus, Beam Rate, and " + EnumChatFormatting.YELLOW + "Maximum Beam Energy").addInfo("All recipes last for one second").addInfo("This upper limit is approached asymptotically as operating power increases").addSeparator().addInfo("Each " + this.particleText("Particle Type") + " has a " + this.energyText("Maximum Particle Energy")).addInfo(this.particleLine("Alpha", "8000")).addInfo(this.particleLine("Proton", "15000")).addInfo(this.particleLine("Neutron", "15000")).addInfo(this.particleLine("Electron", "5000")).addSeparator().addInfo("Each " + this.sourceText("Source input") + " has an Associated " + this.ratioText("Energy Ratio")).addInfo(this.sourceLine("U-238 Dust", "999")).addInfo(this.sourceLine("Californium Dust", "999")).addInfo(this.sourceLine("Tungsten Rods", "0.1")).addInfo(this.sourceLine("Long LaB6 Rods", "0.3")).addSeparator().addInfo(EnumChatFormatting.WHITE + "Actual Beam Energy = min(" + this.energyText("Max Particle Energy") + ", " + EnumChatFormatting.GOLD + "aeV" + EnumChatFormatting.GRAY + ")").addInfo("Where " + EnumChatFormatting.GOLD + "aeV" + EnumChatFormatting.WHITE + " =  " + EnumChatFormatting.YELLOW + "Max Beam Energy" + EnumChatFormatting.WHITE + " * (1 - 1.001^(" + this.ratioText("Energy Ratio") + " * (" + EnumChatFormatting.AQUA + "EU/t required" + EnumChatFormatting.WHITE + " - " + EnumChatFormatting.RED + "EU/t provided" + EnumChatFormatting.WHITE + ")))").addInfo("In short, the " + this.particleText("particle beam's") + " energy is capped to the " + this.energyText("Max Particle Energy")).addInfo("Any one recipe can only provide up to its own " + EnumChatFormatting.YELLOW + "Maximum Beam Energy").beginStructureBlock(5, 5, 6, true).addController("Front bottom").addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_CASING.func_149732_F(), 56, false).addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_GLASS.func_149732_F(), 52, false).addCasingInfoExactly(LanthItemList.ELECTRODE_CASING.func_149732_F(), 16, false).addOtherStructurePart("Beamline Output Hatch", DescTextLocalization.addDotText(4)).addEnergyHatch(DescTextLocalization.addDotText(3)).addMaintenanceHatch(DescTextLocalization.addDotText(3)).addInputBus(DescTextLocalization.addDotText(1)).addOutputBus(DescTextLocalization.addDotText(2)).toolTipFinisher(new String[0]);
        return tt;
    }

    private boolean addBeamLineOutputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchOutputBeamline) {
            return this.mOutputBeamline.add((MTEHatchOutputBeamline)mte);
        }
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack[] tItems = this.getStoredInputs().toArray(new ItemStack[0]);
        long tVoltageMaxTier = this.getMaxInputVoltage();
        long tVoltageActual = GTValues.VP[(int)this.getInputVoltageTier()];
        GTRecipe tRecipe = LanthanidesRecipeMaps.sourceChamberRecipes.findRecipeQuery().caching(false).items(tItems).voltage(tVoltageActual).find();
        if (tRecipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        SourceChamberMetadata metadata = tRecipe.getMetadata(LanthanidesRecipeMaps.SOURCE_CHAMBER_METADATA);
        if (metadata == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (!tRecipe.isRecipeInputEqual(true, GTValues.emptyFluidStackArray, tItems)) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = tRecipe.mDuration;
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.mEUt = (int)(-tVoltageActual);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.outputParticle = metadata.particleID;
        float maxParticleEnergy = Particle.getParticleFromId(this.outputParticle).maxSourceEnergy();
        float maxMaterialEnergy = metadata.maxEnergy;
        this.outputEnergy = (float)Math.min((double)(-maxMaterialEnergy) * Math.pow(1.001, -metadata.energyRatio * (float)(tVoltageMaxTier - (long)tRecipe.mEUt)) + (double)maxMaterialEnergy, (double)maxParticleEnergy);
        if (this.outputEnergy <= 0.0f) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.scerror"));
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.outputFocus = metadata.focus;
        this.outputRate = metadata.rate;
        this.mOutputItems = tRecipe.mOutputs;
        this.updateSlots();
        this.outputPacketAfterRecipe();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("SourceChamber.hint", 7);
    }

    private void outputPacketAfterRecipe() {
        if (!this.mOutputBeamline.isEmpty()) {
            BeamLinePacket packet = new BeamLinePacket(new BeamInformation(this.outputEnergy, this.outputRate, this.outputParticle, this.outputFocus));
            for (MTEHatchOutputBeamline o : this.mOutputBeamline) {
                o.dataPacket = packet;
            }
        }
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        super.stopMachine(reason);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return LanthanidesRecipeMaps.sourceChamberRecipes;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : this.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.out_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(this.outputParticle).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + this.outputEnergy * 1000.0f + EnumChatFormatting.RESET + " eV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + this.outputFocus + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + this.outputRate};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("sc", stackSize, hintsOnly, 2, 4, 0);
    }

    @Override
    public IStructureDefinition<MTESourceChamber> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputBeamline.clear();
        return this.checkPiece("sc", 2, 4, 0) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputBusses.size() == 1 && this.mOutputBeamline.size() == 1 && this.mEnergyHatches.size() == 1;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][126], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][126], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][126]};
    }

    private String particleText(String text) {
        return String.format("%s%s%s", EnumChatFormatting.GOLD, text, EnumChatFormatting.GRAY);
    }

    private String energyText(String text) {
        return String.format("%s%s%s", EnumChatFormatting.GREEN, text, EnumChatFormatting.GRAY);
    }

    private String particleLine(String particle, String energy) {
        return String.format("%s : %s", this.particleText(particle), this.energyText(energy + "keV"));
    }

    private String sourceText(String text) {
        return String.format("%s%s%s", EnumChatFormatting.LIGHT_PURPLE, text, EnumChatFormatting.GRAY);
    }

    private String ratioText(String text) {
        return String.format("%s%s%s", EnumChatFormatting.BLUE, text, EnumChatFormatting.GRAY);
    }

    private String sourceLine(String source, String ratio) {
        return String.format("%s : %s", this.sourceText(source), this.ratioText(ratio));
    }
}

