/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.mui1.cover.CoverLegacyDataUIFactory;
import java.util.UUID;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.IFluidHandler;
import tectech.mechanics.enderStorage.EnderLinkTag;
import tectech.mechanics.enderStorage.EnderWorldSavedData;
import tectech.thing.cover.CoverEnderFluidLink;

public class EnderFluidLinkUIFactory
extends CoverLegacyDataUIFactory {
    private static final int START_X = 10;
    private static final int START_Y = 25;
    private static final int SPACE_X = 18;
    private static final int SPACE_Y = 18;
    private static final int PUBLIC_BUTTON_ID = 0;
    private static final int PRIVATE_BUTTON_ID = 1;
    private static final int IMPORT_BUTTON_ID = 2;
    private static final int EXPORT_BUTTON_ID = 3;

    public EnderFluidLinkUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        TextFieldWidget frequencyField = new TextFieldWidget();
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(frequencyField.setGetter(() -> {
            ICoverable te = this.getUIBuildContext().getTile();
            if (!frequencyField.isClient() && te instanceof IFluidHandler) {
                EnderLinkTag tag = EnderWorldSavedData.getEnderLinkTag((IFluidHandler)te);
                return tag == null ? "" : tag.getFrequency();
            }
            return "";
        }).setSetter(val -> {
            ICoverable patt2349$temp;
            if (!frequencyField.isClient() && (patt2349$temp = this.getUIBuildContext().getTile()) instanceof IFluidHandler) {
                IFluidHandler tank = (IFluidHandler)patt2349$temp;
                UUID uuid = null;
                CoverLegacyData cover = (CoverLegacyData)this.getCover();
                if (cover != null && CoverEnderFluidLink.testBit(cover.getVariable(), 2) && !(uuid = this.getUUID()).equals(CoverEnderFluidLink.getOwner(tank))) {
                    return;
                }
                EnderWorldSavedData.bindEnderLinkTag(tank, new EnderLinkTag((String)val, uuid));
            }
        }).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 25).setSize(82, 12))).widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<CoverLegacyData>(this::getCover, (id, coverData) -> !this.getClickable((int)id, coverData.getVariable()), (id, coverData) -> coverData.setVariable(this.getNewCoverVariable((int)id, coverData.getVariable())), this.getUIBuildContext()).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_WHITELIST).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.public")).setPos(10, 61)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_BLACKLIST).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.private")).setPos(28, 61)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_IMPORT).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.import.tooltip")).setPos(10, 79)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EXPORT).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.export.tooltip")).setPos(28, 79)))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.channel")).setPos(100, 29))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.set_perm")).setPos(46, 65))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.set_io")).setPos(46, 83));
    }

    private int getNewCoverVariable(int id, int coverVariable) {
        int n;
        switch (id) {
            case 0: 
            case 1: {
                n = CoverEnderFluidLink.toggleBit(coverVariable, 2);
                break;
            }
            case 2: 
            case 3: {
                n = CoverEnderFluidLink.toggleBit(coverVariable, 1);
                break;
            }
            default: {
                n = coverVariable;
            }
        }
        return n;
    }

    private boolean getClickable(int id, int coverVariable) {
        boolean bl;
        switch (id) {
            case 0: {
                bl = CoverEnderFluidLink.testBit(coverVariable, 2);
                break;
            }
            case 1: {
                if (!CoverEnderFluidLink.testBit(coverVariable, 2)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (!CoverEnderFluidLink.testBit(coverVariable, 1)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = CoverEnderFluidLink.testBit(coverVariable, 1);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private UUID getUUID() {
        return this.getUIBuildContext().getPlayer().func_110124_au();
    }
}

