/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class GTSoundLoop
extends MovingSound {
    private static final float VOLUME_RAMP = 0.0625f;
    private final boolean whileActive;
    private final boolean whileInactive;
    private final int worldID;
    private boolean fadeMe = false;
    private final int tileX;
    private final int tileY;
    private final int tileZ;

    public GTSoundLoop(ResourceLocation soundResource, IGregTechTileEntity tileEntity, boolean stopWhenActive, boolean stopWhenInactive, float soundX, float soundY, float soundZ) {
        super(soundResource);
        this.whileActive = stopWhenActive;
        this.whileInactive = stopWhenInactive;
        this.tileX = tileEntity.getXCoord();
        this.tileY = tileEntity.getYCoord();
        this.tileZ = tileEntity.getZCoord();
        this.field_147660_d = soundX;
        this.field_147661_e = soundY;
        this.field_147658_f = soundZ;
        this.worldID = tileEntity.getWorld().field_73011_w.field_76574_g;
        this.field_147659_g = true;
        this.field_147662_b = 0.0625f;
    }

    public GTSoundLoop(ResourceLocation soundResource, IGregTechTileEntity tileEntity, boolean stopWhenActive, boolean stopWhenInactive) {
        this(soundResource, tileEntity, stopWhenActive, stopWhenInactive, (float)tileEntity.getXCoord() + 0.5f, (float)tileEntity.getYCoord() + 0.5f, (float)tileEntity.getZCoord() + 0.5f);
    }

    public void func_73660_a() {
        if (this.field_147668_j) {
            return;
        }
        if (this.fadeMe) {
            this.field_147662_b -= 0.0625f;
            if (this.field_147662_b <= 0.0f) {
                this.field_147662_b = 0.0f;
                this.field_147668_j = true;
            }
        } else if (this.field_147662_b < 1.0f) {
            this.field_147662_b += 0.0625f;
        }
        World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
        boolean bl = this.field_147668_j = world.field_73011_w.field_76574_g != this.worldID || !world.func_72904_c(this.tileX, this.tileY, this.tileZ, this.tileX, this.tileY, this.tileZ);
        if (this.field_147668_j) {
            return;
        }
        TileEntity tile = world.func_147438_o(this.tileX, this.tileY, this.tileZ);
        if (tile instanceof IGregTechTileEntity) {
            IGregTechTileEntity iGregTechTileEntity = (IGregTechTileEntity)tile;
            this.fadeMe |= iGregTechTileEntity.isActive() ? this.whileActive : this.whileInactive;
            return;
        }
        this.field_147668_j = true;
    }

    public void setDonePlaying(boolean value) {
        this.field_147668_j = value;
    }

    public void setFadeMe(boolean value) {
        this.fadeMe = value;
    }
}

