/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.EmptyRecipeMetadataStorage;
import gregtech.api.recipe.metadata.IRecipeMetadataStorage;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.extensions.ArrayExt;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GTRecipe
implements Comparable<GTRecipe> {
    private static ItemStack dataStick;
    private static ItemStack dataOrb;
    private static ItemStack ic2FluidCell;
    public ItemStack[] mInputs;
    public ItemStack[] mOutputs;
    public FluidStack[] mFluidInputs;
    public FluidStack[] mFluidOutputs;
    @Nullable
    public int[] mChances;
    public Object mSpecialItems;
    public int mDuration;
    public int mEUt;
    public int mSpecialValue;
    public boolean mEnabled = true;
    public boolean mHidden = false;
    public boolean mFakeRecipe = false;
    public boolean mCanBeBuffered = true;
    public boolean mNeedsEmptyOutput = false;
    public boolean isNBTSensitive = false;
    private String[] neiDesc = null;
    @Nonnull
    private final IRecipeMetadataStorage metadataStorage;
    private RecipeCategory recipeCategory;
    @Nullable
    public List<ModContainer> owners;
    @Nullable
    public List<List<String>> stackTraces;
    private ItemStack[] inputsAtCacheTime;
    private RecipeItemInput[] mergedInputCache;
    private static final RecipeItemInput[] EMPTY_INPUT_CACHE;
    public static boolean GTppRecipeHelper;
    private static final List<String> excludedStacktraces;

    public static void setItemStacks() {
        ic2FluidCell = ItemList.Cell_Universal_Fluid.get(1L, new Object[0]);
        dataStick = ItemList.Tool_DataStick.get(1L, new Object[0]);
        dataOrb = ItemList.Tool_DataOrb.get(1L, new Object[0]);
    }

    private GTRecipe(GTRecipe aRecipe, boolean shallow) {
        this.owners = GTMod.proxy.mNEIRecipeOwner ? new ArrayList() : null;
        this.stackTraces = GTMod.proxy.mNEIRecipeOwnerStackTrace ? new ArrayList() : null;
        this.inputsAtCacheTime = null;
        this.mergedInputCache = null;
        this.mInputs = shallow ? aRecipe.mInputs : ArrayExt.copyItemsIfNonEmpty(aRecipe.mInputs);
        this.mOutputs = shallow ? aRecipe.mOutputs : ArrayExt.copyItemsIfNonEmpty(aRecipe.mOutputs);
        this.mSpecialItems = aRecipe.mSpecialItems;
        this.mChances = aRecipe.mChances;
        this.mFluidInputs = shallow ? aRecipe.mFluidInputs : ArrayExt.copyFluidsIfNonEmpty(aRecipe.mFluidInputs);
        this.mFluidOutputs = shallow ? aRecipe.mFluidOutputs : ArrayExt.copyFluidsIfNonEmpty(aRecipe.mFluidOutputs);
        this.mDuration = aRecipe.mDuration;
        this.mSpecialValue = aRecipe.mSpecialValue;
        this.mEUt = aRecipe.mEUt;
        this.mNeedsEmptyOutput = aRecipe.mNeedsEmptyOutput;
        this.isNBTSensitive = aRecipe.isNBTSensitive;
        this.mCanBeBuffered = aRecipe.mCanBeBuffered;
        this.mFakeRecipe = aRecipe.mFakeRecipe;
        this.mEnabled = aRecipe.mEnabled;
        this.mHidden = aRecipe.mHidden;
        this.metadataStorage = EmptyRecipeMetadataStorage.INSTANCE;
        this.owners = aRecipe.owners == null ? null : new ArrayList<ModContainer>(aRecipe.owners);
        this.reloadOwner();
    }

    GTRecipe(ItemStack[] mInputs, ItemStack[] mOutputs, FluidStack[] mFluidInputs, FluidStack[] mFluidOutputs, int[] mChances, Object mSpecialItems, int mDuration, int mEUt, int mSpecialValue, boolean mEnabled, boolean mHidden, boolean mFakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, boolean nbtSensitive, String[] neiDesc, @Nullable IRecipeMetadataStorage metadataStorage, RecipeCategory recipeCategory) {
        this.owners = GTMod.proxy.mNEIRecipeOwner ? new ArrayList() : null;
        this.stackTraces = GTMod.proxy.mNEIRecipeOwnerStackTrace ? new ArrayList() : null;
        this.inputsAtCacheTime = null;
        this.mergedInputCache = null;
        this.mInputs = mInputs;
        this.mOutputs = mOutputs;
        this.mFluidInputs = mFluidInputs;
        this.mFluidOutputs = mFluidOutputs;
        this.mChances = ArrayExt.fixChancesArray(mChances, -1);
        this.mSpecialItems = mSpecialItems;
        this.mDuration = mDuration;
        this.mEUt = mEUt;
        this.mSpecialValue = mSpecialValue;
        this.mEnabled = mEnabled;
        this.mHidden = mHidden;
        this.mFakeRecipe = mFakeRecipe;
        this.mCanBeBuffered = mCanBeBuffered;
        this.mNeedsEmptyOutput = mNeedsEmptyOutput;
        this.isNBTSensitive = nbtSensitive;
        this.neiDesc = neiDesc;
        this.metadataStorage = metadataStorage == null ? EmptyRecipeMetadataStorage.INSTANCE : metadataStorage.copy();
        this.recipeCategory = recipeCategory;
        this.reloadOwner();
    }

    public GTRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        int i;
        this.owners = GTMod.proxy.mNEIRecipeOwner ? new ArrayList() : null;
        this.stackTraces = GTMod.proxy.mNEIRecipeOwnerStackTrace ? new ArrayList() : null;
        this.inputsAtCacheTime = null;
        this.mergedInputCache = null;
        aInputs = aInputs == null ? GTValues.emptyItemStackArray : ArrayExt.removeTrailingNulls(aInputs);
        aOutputs = aOutputs == null ? GTValues.emptyItemStackArray : ArrayExt.removeTrailingNulls(aOutputs);
        aFluidInputs = aFluidInputs == null ? GTValues.emptyFluidStackArray : ArrayExt.removeNullFluids(aFluidInputs);
        aFluidOutputs = aFluidOutputs == null ? GTValues.emptyFluidStackArray : ArrayExt.removeNullFluids(aFluidOutputs);
        GTOreDictUnificator.setStackArray(true, true, aInputs);
        GTOreDictUnificator.setStackArray(true, true, aOutputs);
        for (ItemStack s : aOutputs) {
            GTUtility.updateItemStack(s);
        }
        for (i = 0; i < aFluidInputs.length; ++i) {
            aFluidInputs[i] = aFluidInputs[i].copy();
        }
        for (i = 0; i < aFluidOutputs.length; ++i) {
            aFluidOutputs[i] = aFluidOutputs[i].copy();
        }
        if (aOptimize && aDuration >= 32) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(aInputs.length + aOutputs.length);
            for (ItemStack s : aInputs) {
                if (s == null) continue;
                stacks.add(s);
            }
            for (ItemStack s : aOutputs) {
                if (s == null) continue;
                stacks.add(s);
            }
            for (byte i2 = (byte)Math.min(64, aDuration / 16); i2 > 1; i2 = (byte)(i2 - 1)) {
                if (aDuration / i2 < 16) continue;
                boolean temp = true;
                int size = stacks.size();
                for (int j = 0; j < size; ++j) {
                    if (((ItemStack)stacks.get((int)j)).field_77994_a % i2 == 0) continue;
                    temp = false;
                    break;
                }
                if (temp) {
                    for (FluidStack f : aFluidInputs) {
                        if (f.amount % i2 == 0) continue;
                        temp = false;
                        break;
                    }
                }
                if (temp) {
                    for (FluidStack f : aFluidOutputs) {
                        if (f.amount % i2 == 0) continue;
                        temp = false;
                        break;
                    }
                }
                if (!temp) continue;
                size = stacks.size();
                for (int j = 0; j < size; ++j) {
                    ((ItemStack)stacks.get((int)j)).field_77994_a /= i2;
                }
                for (FluidStack f : aFluidInputs) {
                    f.amount /= i2;
                }
                for (FluidStack f : aFluidOutputs) {
                    f.amount /= i2;
                }
                aDuration /= i2;
            }
        }
        this.mInputs = aInputs;
        this.mOutputs = aOutputs;
        this.mSpecialItems = aSpecialItems;
        this.mChances = ArrayExt.fixChancesArray(aChances, aOutputs.length);
        this.mFluidInputs = aFluidInputs;
        this.mFluidOutputs = aFluidOutputs;
        this.mDuration = aDuration;
        this.mSpecialValue = aSpecialValue;
        this.mEUt = aEUt;
        this.metadataStorage = EmptyRecipeMetadataStorage.INSTANCE;
        this.reloadOwner();
    }

    public GTRecipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    RecipeMaps.dieselFuels.addRecipe(this);
                    RecipeMaps.largeBoilerFakeFuels.getBackend().addDieselRecipe(this);
                    break;
                }
                case 1: {
                    RecipeMaps.gasTurbineFuels.addRecipe(this);
                    break;
                }
                case 2: {
                    RecipeMaps.hotFuels.addRecipe(this);
                    break;
                }
                case 4: {
                    RecipeMaps.plasmaFuels.addRecipe(this);
                    break;
                }
                case 5: {
                    RecipeMaps.magicFuels.addRecipe(this);
                    break;
                }
                default: {
                    RecipeMaps.denseLiquidFuels.addRecipe(this);
                    RecipeMaps.largeBoilerFakeFuels.getBackend().addDenseLiquidRecipe(this);
                }
            }
        }
    }

    public GTRecipe(ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        this(true, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
    }

    public static void reInit() {
        GTLog.out.println("GTMod: Re-Unificating Recipes.");
        for (RecipeMap<?> map : RecipeMap.ALL_RECIPE_MAPS.values()) {
            ((RecipeMapBackend)map.getBackend()).reInit();
        }
        RecipeAssemblyLine.reInit();
    }

    public ItemStack getRepresentativeInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mInputs.length) {
            return null;
        }
        return GTUtility.copyOrNull(this.mInputs[aIndex]);
    }

    public ItemStack getOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mOutputs.length) {
            return null;
        }
        return GTUtility.copyOrNull(this.mOutputs[aIndex]);
    }

    public int getOutputChance(int aIndex) {
        if (this.mChances == null) {
            return 10000;
        }
        if (aIndex < 0 || aIndex >= this.mChances.length) {
            return 10000;
        }
        return this.mChances[aIndex];
    }

    public FluidStack getRepresentativeFluidInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidInputs.length || this.mFluidInputs[aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[aIndex].copy();
    }

    public FluidStack getFluidOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidOutputs.length || this.mFluidOutputs[aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[aIndex].copy();
    }

    public void checkCellBalance() {
        int tOutputAmount;
        if (!GTValues.D2 || this.mInputs.length < 1) {
            return;
        }
        int tInputAmount = GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mInputs);
        if (tInputAmount < (tOutputAmount = GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mOutputs))) {
            if (!Materials.Tin.contains(this.mInputs)) {
                GTLog.err.println("You get more Cells, than you put in? There must be something wrong.");
                new Exception().printStackTrace(GTLog.err);
            }
        } else if (tInputAmount > tOutputAmount && !Materials.Tin.contains(this.mOutputs)) {
            GTLog.err.println("You get less Cells, than you put in? GT Machines usually don't destroy Cells.");
            new Exception().printStackTrace(GTLog.err);
        }
    }

    public GTRecipe copy() {
        return new GTRecipe(this, false);
    }

    public GTRecipe copyShallow() {
        return new GTRecipe(this, true);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, 1, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, aDontCheckStackSizes, 1, aFluidInputs, aInputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull RecipeItemInput @NotNull [] getCachedCombinedItemInputs() {
        if (this.mergedInputCache != null) {
            if (this.mInputs != this.inputsAtCacheTime) {
                throw new IllegalStateException("Inputs to this recipe have been modified since first recipe match: " + this);
            }
            return this.mergedInputCache;
        }
        GTRecipe gTRecipe = this;
        synchronized (gTRecipe) {
            if (this.mergedInputCache != null) {
                if (this.mInputs != this.inputsAtCacheTime) {
                    throw new IllegalStateException("Inputs to this recipe have been modified since first recipe match: " + this);
                }
                return this.mergedInputCache;
            }
            ItemStack[] inputs = this.mInputs;
            this.inputsAtCacheTime = inputs;
            if (inputs == null || inputs.length == 0) {
                this.mergedInputCache = EMPTY_INPUT_CACHE;
                return this.mergedInputCache;
            }
            @NotNull ObjectArrayList newCache = ObjectArrayList.wrap((Object[])new RecipeItemInput[inputs.length], (int)0);
            for (ItemStack itemStack : inputs) {
                if (itemStack == null) continue;
                RecipeItemInput existingInput = newCache.stream().filter(existing -> existing.matchesType(itemStack)).findAny().orElse(null);
                if (existingInput == null) {
                    newCache.add((Object)new RecipeItemInput(itemStack, this.isNBTSensitive));
                    continue;
                }
                existingInput.inputAmount = Math.addExact(existingInput.inputAmount, (long)itemStack.field_77994_a);
            }
            RecipeItemInput[] frozenCache = (RecipeItemInput[])newCache.toArray((Object[])new RecipeItemInput[0]);
            if (GregTechAPI.sFullLoadFinished) {
                this.mergedInputCache = frozenCache;
            }
            return frozenCache;
        }
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, int amountMultiplier, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        double maxParallel = this.maxParallelCalculatedByInputs(amountMultiplier, aFluidInputs, aInputs);
        if (aDontCheckStackSizes) {
            return maxParallel > 0.0;
        }
        if (maxParallel >= (double)amountMultiplier) {
            if (aDecreaseStacksizeBySuccess) {
                this.consumeInput(amountMultiplier, aFluidInputs, aInputs);
            }
            return true;
        }
        return false;
    }

    public void consumeInput(int amountMultiplier, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        RecipeItemInput[] combinedInputs;
        if (amountMultiplier <= 0) {
            return;
        }
        if (aFluidInputs != null) {
            block0: for (FluidStack recipeFluidCost : this.mFluidInputs) {
                if (recipeFluidCost == null) continue;
                long remainingCost = (long)recipeFluidCost.amount * (long)amountMultiplier;
                for (FluidStack providedFluid : aFluidInputs) {
                    if (providedFluid == null || !providedFluid.isFluidEqual(recipeFluidCost)) continue;
                    if ((long)providedFluid.amount >= remainingCost) {
                        providedFluid.amount = (int)((long)providedFluid.amount - remainingCost);
                        continue block0;
                    }
                    remainingCost -= (long)providedFluid.amount;
                    providedFluid.amount = 0;
                }
            }
        }
        if (aInputs == null || aInputs.length == 0) {
            return;
        }
        ItemData[] unifiedProvidedInputs = new ItemData[aInputs.length];
        for (int i = 0; i < aInputs.length; ++i) {
            unifiedProvidedInputs[i] = GTOreDictUnificator.getAssociation(aInputs[i]);
        }
        block3: for (RecipeItemInput recipeItemCost : combinedInputs = this.getCachedCombinedItemInputs()) {
            long remainingCost = recipeItemCost.inputAmount * (long)amountMultiplier;
            for (int iProvided = 0; iProvided < aInputs.length && remainingCost > 0L; ++iProvided) {
                ItemData providedUnifiedItem;
                ItemStack providedItem = aInputs[iProvided];
                if (providedItem == null || providedItem.field_77994_a == 0 || !recipeItemCost.matchesRecipe(providedUnifiedItem = unifiedProvidedInputs[iProvided], providedItem)) continue;
                if ((long)providedItem.field_77994_a >= remainingCost) {
                    providedItem.field_77994_a -= (int)remainingCost;
                    continue block3;
                }
                remainingCost -= (long)providedItem.field_77994_a;
                providedItem.field_77994_a = 0;
            }
        }
    }

    public double maxParallelCalculatedByInputs(int maxParallel, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        if (this.mInputs.length > 0 && aInputs == null) {
            return 0.0;
        }
        if (this.mFluidInputs.length > 0 && aFluidInputs == null) {
            return 0.0;
        }
        double currentParallel = maxParallel;
        if (this.mFluidInputs.length > 0) {
            Reference2LongArrayMap fluidMap = new Reference2LongArrayMap(2);
            Reference2LongArrayMap fluidCost = new Reference2LongArrayMap(2);
            for (FluidStack fluidStack : aFluidInputs) {
                if (fluidStack == null) continue;
                fluidMap.mergeLong((Object)fluidStack.getFluid(), (long)fluidStack.amount, Long::sum);
            }
            for (FluidStack fluidStack : this.mFluidInputs) {
                if (fluidStack == null) continue;
                fluidCost.mergeLong((Object)fluidStack.getFluid(), (long)fluidStack.amount, Long::sum);
            }
            for (Reference2LongMap.Entry costEntry : fluidCost.reference2LongEntrySet()) {
                if (costEntry.getLongValue() > 0L) {
                    currentParallel = Math.min(currentParallel, (double)fluidMap.getOrDefault(costEntry.getKey(), 0L) / (double)costEntry.getLongValue());
                }
                if (!(currentParallel <= 0.0)) continue;
                return 0.0;
            }
        }
        if (this.mInputs.length > 0) {
            @NotNull RecipeItemInput @NotNull [] combinedInputs = this.getCachedCombinedItemInputs();
            if (aInputs.length < combinedInputs.length) {
                return 0.0;
            }
            ItemData[] unifiedProvidedInputs = new ItemData[aInputs.length];
            for (int i = 0; i < aInputs.length; ++i) {
                unifiedProvidedInputs[i] = GTOreDictUnificator.getAssociation(aInputs[i]);
            }
            block4: for (RecipeItemInput combinedInput : combinedInputs) {
                double remainingCost = (double)combinedInput.inputAmount * currentParallel;
                long providedAmount = 0L;
                for (int i = 0; i < unifiedProvidedInputs.length; ++i) {
                    ItemData providedUnifiedItem = unifiedProvidedInputs[i];
                    ItemStack providedItem = aInputs[i];
                    if (combinedInput.matchesRecipe(providedUnifiedItem, providedItem) && (double)(providedAmount += (long)providedItem.field_77994_a) >= remainingCost) continue block4;
                }
                if (providedAmount == 0L) {
                    return 0.0;
                }
                currentParallel = Math.min(currentParallel, (double)providedAmount / (double)combinedInput.inputAmount);
            }
        }
        return currentParallel;
    }

    private static boolean shouldCheckNBT(ItemStack item) {
        if (GTppRecipeHelper) {
            return GTUtility.areStacksEqual(item, ic2FluidCell, true) || GTUtility.areStacksEqual(item, dataStick, true) || GTUtility.areStacksEqual(item, dataOrb, true);
        }
        return false;
    }

    @Override
    public int compareTo(GTRecipe recipe) {
        if (this.mEUt != recipe.mEUt) {
            return Integer.compare(this.mEUt, recipe.mEUt);
        }
        if (this.mDuration != recipe.mDuration) {
            return Integer.compare(this.mDuration, recipe.mDuration);
        }
        if (this.mSpecialValue != recipe.mSpecialValue) {
            return Integer.compare(this.mSpecialValue, recipe.mSpecialValue);
        }
        if (this.mFluidInputs.length != recipe.mFluidInputs.length) {
            return Integer.compare(this.mFluidInputs.length, recipe.mFluidInputs.length);
        }
        if (this.mInputs.length != recipe.mInputs.length) {
            return Integer.compare(this.mInputs.length, recipe.mInputs.length);
        }
        return 0;
    }

    public String[] getNeiDesc() {
        return this.neiDesc;
    }

    public void setNeiDesc(String ... neiDesc) {
        this.neiDesc = neiDesc;
    }

    @Nullable
    public <T> T getMetadata(RecipeMetadataKey<T> key) {
        return key.cast(this.metadataStorage.getMetadata(key));
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public <T> T getMetadataOrDefault(RecipeMetadataKey<T> key, @Nullable T defaultValue) {
        return key.cast(this.metadataStorage.getMetadataOrDefault(key, defaultValue));
    }

    @Nonnull
    public IRecipeMetadataStorage getMetadataStorage() {
        return this.metadataStorage;
    }

    public RecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public void setRecipeCategory(RecipeCategory recipeCategory) {
        this.recipeCategory = recipeCategory;
    }

    public void reloadOwner() {
        if (this.owners != null) {
            this.setOwner(Loader.instance().activeModContainer());
        }
        if (this.stackTraces != null) {
            ArrayList<String> toAdd = new ArrayList<String>();
            for (StackTraceElement stackTrace : Thread.currentThread().getStackTrace()) {
                if (!excludedStacktraces.stream().noneMatch(c -> stackTrace.getClassName().equals(c))) continue;
                toAdd.add(GTRecipe.formatStackTrace(stackTrace));
            }
            this.stackTraces.add(toAdd);
        }
    }

    private static String formatStackTrace(StackTraceElement stackTraceElement) {
        String raw = stackTraceElement.toString();
        int startParen = raw.lastIndexOf(40);
        int colon = raw.lastIndexOf(58);
        if (colon == -1) {
            return raw;
        }
        return raw.substring(0, startParen + 1) + raw.substring(colon);
    }

    public void setOwner(ModContainer newOwner) {
        ModContainer oldOwner;
        if (this.owners == null) {
            return;
        }
        ModContainer modContainer = oldOwner = !this.owners.isEmpty() ? this.owners.get(this.owners.size() - 1) : null;
        if (newOwner != null && newOwner != oldOwner) {
            this.owners.add(newOwner);
        }
    }

    public void setOwner(String modId) {
        if (this.owners == null) {
            return;
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals(modId)) continue;
            this.setOwner(mod);
            return;
        }
    }

    public GTRecipe setInputs(ItemStack ... aInputs) {
        this.mInputs = ArrayExt.removeTrailingNulls(aInputs);
        return this;
    }

    public GTRecipe setOutputs(ItemStack ... aOutputs) {
        this.mOutputs = ArrayExt.removeTrailingNulls(aOutputs);
        return this;
    }

    public GTRecipe setFluidInputs(FluidStack ... aInputs) {
        this.mFluidInputs = ArrayExt.removeTrailingNulls(aInputs);
        return this;
    }

    public GTRecipe setFluidOutputs(FluidStack ... aOutputs) {
        this.mFluidOutputs = ArrayExt.removeTrailingNulls(aOutputs);
        return this;
    }

    public GTRecipe setChances(int ... aChances) {
        this.mChances = ArrayExt.fixChancesArray(aChances, -1);
        return this;
    }

    public GTRecipe setDuration(int aDuration) {
        this.mDuration = aDuration;
        return this;
    }

    public GTRecipe setEUt(int aEUt) {
        this.mEUt = aEUt;
        return this;
    }

    static {
        EMPTY_INPUT_CACHE = new RecipeItemInput[0];
        excludedStacktraces = Arrays.asList("java.lang.Thread", "gregtech.api.interfaces.IRecipeMap", "gregtech.api.interfaces.IRecipeMap$1", "gregtech.api.recipe.RecipeMap", "gregtech.api.recipe.RecipeMapBackend", "gregtech.api.recipe.RecipeMapBackendPropertiesBuilder", "gregtech.api.util.GTRecipe", "gregtech.api.util.GTRecipeBuilder", "gregtech.api.util.GTRecipeConstants", "gregtech.api.util.GTRecipeMapUtil", "gregtech.common.GTRecipeAdder");
    }

    public static final class RecipeItemInput {
        public final ItemStack unifiedStack;
        public long inputAmount;
        public final boolean usesNbtMatching;

        public RecipeItemInput(ItemStack stack, boolean recipeIsNBTSensitive) {
            Objects.requireNonNull(stack);
            this.inputAmount = stack.field_77994_a;
            boolean stackNeedsNBT = GTRecipe.shouldCheckNBT(stack);
            this.usesNbtMatching = recipeIsNBTSensitive | stackNeedsNBT;
            if (stackNeedsNBT) {
                this.unifiedStack = stack;
            } else {
                this.unifiedStack = GTOreDictUnificator.get_nocopy(true, stack);
                if (!this.usesNbtMatching) {
                    this.unifiedStack.func_77982_d(null);
                }
            }
        }

        public boolean matchesType(ItemStack other) {
            return GTUtility.areStacksEqual(this.unifiedStack, other, !this.usesNbtMatching);
        }

        public boolean matchesRecipe(ItemData oredictOther, ItemStack other) {
            if (this.usesNbtMatching) {
                return GTUtility.areStacksEqual(this.unifiedStack, other, false);
            }
            return GTOreDictUnificator.isInputStackEqual(other, oredictOther, this.unifiedStack);
        }
    }

    public static class RecipeAssemblyLine {
        public static final ArrayList<RecipeAssemblyLine> sAssemblylineRecipes = new ArrayList();
        public ItemStack mResearchItem;
        public int mResearchTime;
        public int mResearchVoltage;
        public ItemStack[] mInputs;
        public FluidStack[] mFluidInputs;
        public ItemStack mOutput;
        public int mDuration;
        public int mEUt;
        public ItemStack[][] mOreDictAlt;
        private int mPersistentHash;
        private final List<ItemStack> dataSticksForNEI = new ArrayList<ItemStack>();

        private static void checkInvalidRecipes() {
            int invalidCount = 0;
            GTLog.out.println("Started assline validation");
            for (RecipeAssemblyLine recipe : sAssemblylineRecipes) {
                if (recipe.getPersistentHash() != 0) continue;
                ++invalidCount;
                GTLog.err.printf("Invalid recipe: %s%n", recipe);
            }
            if (invalidCount > 0) {
                throw new RuntimeException("There are " + invalidCount + " invalid assembly line recipe(s)! Check GregTech.log for details!");
            }
        }

        public RecipeAssemblyLine(ItemStack aResearchItem, int aResearchTime, int aResearchVoltage, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
            this(aResearchItem, aResearchTime, aResearchVoltage, aInputs, aFluidInputs, aOutput, aDuration, aEUt, new ItemStack[aInputs.length][]);
            int tPersistentHash = 1;
            for (ItemStack itemStack : aInputs) {
                tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(itemStack, true, false);
            }
            tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(aResearchItem, true, false);
            tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash(aOutput, true, false);
            for (ItemStack itemStack : aFluidInputs) {
                tPersistentHash = tPersistentHash * 31 + GTUtility.persistentHash((FluidStack)itemStack, true, false);
            }
            tPersistentHash = tPersistentHash * 31 + aResearchTime;
            tPersistentHash = tPersistentHash * 31 + aResearchVoltage;
            tPersistentHash = tPersistentHash * 31 + aDuration;
            tPersistentHash = tPersistentHash * 31 + aEUt;
            this.setPersistentHash(tPersistentHash);
        }

        public RecipeAssemblyLine(ItemStack aResearchItem, int aResearchTime, int aResearchVoltage, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt, ItemStack[][] aAlt) {
            this.mResearchItem = aResearchItem;
            this.mResearchTime = aResearchTime;
            this.mResearchVoltage = aResearchVoltage;
            this.mInputs = aInputs;
            this.mFluidInputs = aFluidInputs;
            this.mOutput = aOutput;
            this.mDuration = aDuration;
            this.mEUt = aEUt;
            this.mOreDictAlt = aAlt;
        }

        public int getPersistentHash() {
            if (this.mPersistentHash == 0) {
                GTLog.err.println("Assline recipe persistent hash has not been set! Recipe: " + this.mOutput);
            }
            return this.mPersistentHash;
        }

        public String toString() {
            return "GTRecipe_AssemblyLine{mResearchItem=" + this.mResearchItem + ", mResearchTime=" + this.mResearchTime + ", mInputs=" + Arrays.toString(this.mInputs) + ", mFluidInputs=" + Arrays.toString(this.mFluidInputs) + ", mOutput=" + this.mOutput + ", mDuration=" + this.mDuration + ", mEUt=" + this.mEUt + ", mOreDictAlt=" + Arrays.toString((Object[])this.mOreDictAlt) + '}';
        }

        public void setPersistentHash(int aPersistentHash) {
            if (this.mPersistentHash != 0) {
                throw new IllegalStateException("Cannot set persistent hash twice!");
            }
            this.mPersistentHash = aPersistentHash == 0 ? 1 : aPersistentHash;
        }

        public ItemStack newDataStickForNEI(String aDisplayName) {
            ItemStack dataStick = ItemList.Tool_DataStick.getWithName(1L, aDisplayName, new Object[0]);
            this.dataSticksForNEI.add(dataStick);
            return dataStick;
        }

        public static void reInit() {
            for (RecipeAssemblyLine recipe : sAssemblylineRecipes) {
                for (ItemStack stack : recipe.dataSticksForNEI) {
                    AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(stack, recipe, false);
                }
            }
        }

        public static int[] getItemConsumptionAmountArray(ArrayList<MTEHatchInputBus> inputBusses, RecipeAssemblyLine recipe) {
            int itemCount = recipe.mInputs.length;
            if (itemCount == 0) {
                return null;
            }
            int[] tStacks = new int[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                ItemStack slotStack;
                MTEHatchInputBus inputBus = inputBusses.get(i);
                if (!inputBus.isValid()) {
                    return null;
                }
                if (inputBus instanceof MTEHatchInputBusME) {
                    MTEHatchInputBusME meBus = (MTEHatchInputBusME)inputBus;
                    slotStack = meBus.getFirstShadowItemStack(true);
                } else {
                    slotStack = inputBus.getFirstStack();
                }
                if (slotStack == null) {
                    return null;
                }
                int amount = RecipeAssemblyLine.getMatchedIngredientAmount(slotStack, recipe.mInputs[i], recipe.mOreDictAlt[i]);
                if (amount < 0) {
                    return null;
                }
                tStacks[i] = amount;
            }
            return tStacks;
        }

        public static int getMatchedIngredientAmount(ItemStack aSlotStack, ItemStack aIngredient, ItemStack[] alts) {
            if (alts == null || alts.length == 0) {
                if (GTUtility.areStacksEqual(aSlotStack, aIngredient, true)) {
                    return aIngredient.field_77994_a;
                }
                return -1;
            }
            for (ItemStack tAltStack : alts) {
                if (!GTUtility.areStacksEqual(aSlotStack, tAltStack, true)) continue;
                return tAltStack.field_77994_a;
            }
            return -1;
        }

        public static double maxParallelCalculatedByInputItems(ArrayList<MTEHatchInputBus> inputBusses, int maxParallel, int[] itemConsumptions, Map<GTUtility.ItemId, ItemStack> inputsFromME) {
            MTEHatchInputBus inputBus;
            Object2LongOpenHashMap itemConsumptionsFromME = new Object2LongOpenHashMap();
            double currentParallel = maxParallel;
            for (int i = 0; i < itemConsumptions.length; ++i) {
                inputBus = inputBusses.get(i);
                if (!inputBus.isValid()) {
                    return 0.0;
                }
                if (!(inputBus instanceof MTEHatchInputBusME)) continue;
                MTEHatchInputBusME meBus = (MTEHatchInputBusME)inputBus;
                ItemStack item = meBus.getFirstShadowItemStack(true);
                if (item == null) {
                    return 0.0;
                }
                GTUtility.ItemId id = GTUtility.ItemId.createNoCopy(item);
                itemConsumptionsFromME.merge(id, Long.valueOf(itemConsumptions[i]), Long::sum);
            }
            for (Map.Entry entry : itemConsumptionsFromME.entrySet()) {
                if (!inputsFromME.containsKey(entry.getKey())) {
                    return 0.0;
                }
                long consume = (Long)entry.getValue();
                if (consume == 0L || !((currentParallel = Math.min(currentParallel, (double)inputsFromME.get(entry.getKey()).field_77994_a / (double)consume)) <= 0.0)) continue;
                return 0.0;
            }
            for (int i = 0; i < itemConsumptions.length; ++i) {
                inputBus = inputBusses.get(i);
                if (!inputBus.isValid()) {
                    return 0.0;
                }
                if (inputBus instanceof MTEHatchInputBusME) continue;
                ItemStack item = inputBus.getFirstStack();
                if (item == null) {
                    return 0.0;
                }
                if (itemConsumptions[i] == 0 || !((currentParallel = Math.min(currentParallel, (double)item.field_77994_a / (double)itemConsumptions[i])) <= 0.0)) continue;
                return 0.0;
            }
            return currentParallel;
        }

        public static double maxParallelCalculatedByInputFluids(ArrayList<MTEHatchInput> inputHatches, int maxParallel, FluidStack[] fluidConsumptions, Map<Fluid, FluidStack> fluidsFromME) {
            Fluid fluid;
            MTEHatchInput inputHatch;
            Reference2LongOpenHashMap fluidConsumptionsFromME = new Reference2LongOpenHashMap();
            double currentParallel = maxParallel;
            for (int i = 0; i < fluidConsumptions.length; ++i) {
                inputHatch = inputHatches.get(i);
                if (!inputHatch.isValid()) {
                    return 0.0;
                }
                if (!(inputHatch instanceof MTEHatchInputME)) continue;
                MTEHatchInputME meHatch = (MTEHatchInputME)inputHatch;
                FluidStack fluid2 = meHatch.getFirstShadowFluidStack(true);
                if (fluid2 == null) {
                    return 0.0;
                }
                if (!GTUtility.areFluidsEqual(fluid2, fluidConsumptions[i])) {
                    return 0.0;
                }
                fluidConsumptionsFromME.merge(fluid2.getFluid(), Long.valueOf(fluidConsumptions[i].amount), Long::sum);
            }
            for (Map.Entry entry : fluidConsumptionsFromME.entrySet()) {
                fluid = (Fluid)entry.getKey();
                if (!fluidsFromME.containsKey(fluid)) {
                    return 0.0;
                }
                long consume = (Long)entry.getValue();
                if (!((currentParallel = Math.min(currentParallel, (double)fluidsFromME.get((Object)fluid).amount / (double)consume)) <= 0.0)) continue;
                return 0.0;
            }
            for (int i = 0; i < fluidConsumptions.length; ++i) {
                inputHatch = inputHatches.get(i);
                if (!inputHatch.isValid()) {
                    return 0.0;
                }
                if (inputHatch instanceof MTEHatchInputME) continue;
                if (inputHatch instanceof MTEHatchMultiInput) {
                    MTEHatchMultiInput multiInput = (MTEHatchMultiInput)inputHatch;
                    fluid = multiInput.getFluid();
                } else {
                    fluid = inputHatch.getFillableStack();
                }
                if (fluid == null) {
                    return 0.0;
                }
                if (!GTUtility.areFluidsEqual((FluidStack)fluid, fluidConsumptions[i])) {
                    return 0.0;
                }
                if (!((currentParallel = Math.min(currentParallel, (double)fluid.amount / (double)fluidConsumptions[i].amount)) <= 0.0)) continue;
                return 0.0;
            }
            return currentParallel;
        }

        public static void consumeInputItems(ArrayList<MTEHatchInputBus> inputBusses, int amountMultiplier, int[] itemConsumptions, Map<GTUtility.ItemId, ItemStack> inputsFromME) {
            for (int i = 0; i < itemConsumptions.length; ++i) {
                ItemStack item;
                MTEHatchInputBus inputBus = inputBusses.get(i);
                if (!inputBus.isValid()) continue;
                if (inputBus instanceof MTEHatchInputBusME) {
                    MTEHatchInputBusME meBus = (MTEHatchInputBusME)inputBus;
                    ItemStack itemStack = meBus.getFirstShadowItemStack(true);
                    item = inputsFromME.get(GTUtility.ItemId.createNoCopy(itemStack));
                } else {
                    item = inputBus.getFirstStack();
                }
                item.field_77994_a -= itemConsumptions[i] * amountMultiplier;
            }
        }

        public static void consumeInputFluids(ArrayList<MTEHatchInput> inputHatches, int amountMultiplier, FluidStack[] fluidConsumptions, Map<Fluid, FluidStack> fluidsFromME) {
            for (int i = 0; i < fluidConsumptions.length; ++i) {
                FluidStack fluid;
                MTEHatchInput inputHatch = inputHatches.get(i);
                if (!inputHatch.isValid()) continue;
                if (inputHatch instanceof MTEHatchInputME) {
                    MTEHatchInputME meHatch = (MTEHatchInputME)inputHatch;
                    FluidStack fluidStack = meHatch.getFirstShadowFluidStack(true);
                    fluid = fluidsFromME.get(fluidStack.getFluid());
                } else if (inputHatch instanceof MTEHatchMultiInput) {
                    MTEHatchMultiInput multiInput = (MTEHatchMultiInput)inputHatch;
                    fluid = multiInput.getFluid();
                } else {
                    fluid = inputHatch.getFillableStack();
                }
                fluid.amount -= fluidConsumptions[i].amount * amountMultiplier;
            }
        }

        static {
            if (!Boolean.getBoolean("com.gtnh.gt5u.ignore-invalid-assline-recipe")) {
                GregTechAPI.sFirstWorldTick.add(RecipeAssemblyLine::checkInvalidRecipes);
            } else {
                GTLog.out.println("NOT CHECKING INVALID ASSLINE RECIPE.");
            }
        }
    }

    public static class GTRecipe_WithAlt
    extends GTRecipe {
        public ItemStack[][] mOreDictAlt;

        GTRecipe_WithAlt(ItemStack[] mInputs, ItemStack[] mOutputs, FluidStack[] mFluidInputs, FluidStack[] mFluidOutputs, int[] mChances, Object mSpecialItems, int mDuration, int mEUt, int mSpecialValue, boolean mEnabled, boolean mHidden, boolean mFakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, boolean nbtSensitive, String[] neiDesc, @Nullable IRecipeMetadataStorage metadataStorage, RecipeCategory recipeCategory, ItemStack[][] mOreDictAlt) {
            super(mInputs, mOutputs, mFluidInputs, mFluidOutputs, mChances, mSpecialItems, mDuration, mEUt, mSpecialValue, mEnabled, mHidden, mFakeRecipe, mCanBeBuffered, mNeedsEmptyOutput, nbtSensitive, neiDesc, metadataStorage, recipeCategory);
            this.mOreDictAlt = mOreDictAlt;
        }

        public GTRecipe_WithAlt(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, ItemStack[][] aAlt) {
            super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
            this.mOreDictAlt = aAlt;
        }

        public Object getAltRepresentativeInput(int aIndex) {
            if (aIndex < 0) {
                return null;
            }
            if (aIndex < this.mOreDictAlt.length && this.mOreDictAlt[aIndex] != null && this.mOreDictAlt[aIndex].length > 0) {
                ItemStack[] rStacks = new ItemStack[this.mOreDictAlt[aIndex].length];
                for (int i = 0; i < this.mOreDictAlt[aIndex].length; ++i) {
                    rStacks[i] = GTUtility.copyOrNull(this.mOreDictAlt[aIndex][i]);
                }
                return rStacks;
            }
            if (aIndex >= this.mInputs.length) {
                return null;
            }
            return GTUtility.copyOrNull(this.mInputs[aIndex]);
        }
    }
}

