/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import gregtech.api.recipe.check.CheckRecipeResult;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class SimpleCheckRecipeResult
implements CheckRecipeResult {
    private boolean success;
    private String key;
    private boolean persistsOnShutdown;

    SimpleCheckRecipeResult(boolean success, String key, boolean persistsOnShutdown) {
        this.success = success;
        this.key = key;
        this.persistsOnShutdown = persistsOnShutdown;
    }

    @Override
    @NotNull
    public String getID() {
        return "simple_result";
    }

    @Override
    public boolean wasSuccessful() {
        return this.success;
    }

    @Override
    @Nonnull
    @NotNull
    public String getDisplayString() {
        return Objects.requireNonNull(StatCollector.func_74838_a((String)("GT5U.gui.text." + this.key)));
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        tag.func_74757_a("success", this.success);
        tag.func_74778_a("key", this.key);
        tag.func_74757_a("persistsOnShutdown", this.persistsOnShutdown);
        return tag;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.success = tag.func_74767_n("success");
        this.key = tag.func_74779_i("key");
        this.persistsOnShutdown = tag.func_74767_n("persistsOnShutdown");
    }

    @Override
    @Nonnull
    @NotNull
    public CheckRecipeResult newInstance() {
        return new SimpleCheckRecipeResult(false, "", false);
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.writeBoolean(this.success);
        NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)this.key);
        buffer.writeBoolean(this.persistsOnShutdown);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buffer) {
        this.success = buffer.readBoolean();
        this.key = NetworkUtils.readStringSafe((PacketBuffer)buffer);
        this.persistsOnShutdown = buffer.readBoolean();
    }

    @Override
    public boolean persistsOnShutdown() {
        return this.persistsOnShutdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCheckRecipeResult that = (SimpleCheckRecipeResult)o;
        return this.success == that.success && Objects.equals(this.key, that.key) && this.persistsOnShutdown == that.persistsOnShutdown;
    }

    @Nonnull
    public static CheckRecipeResult ofSuccess(String key) {
        return new SimpleCheckRecipeResult(true, key, false);
    }

    @Nonnull
    public static CheckRecipeResult ofFailure(String key) {
        return new SimpleCheckRecipeResult(false, key, false);
    }

    public static CheckRecipeResult ofFailurePersistOnShutdown(String key) {
        return new SimpleCheckRecipeResult(false, key, true);
    }
}

