/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.aura.AuraEffects;
import makeo.gadomancy.common.blocks.tiles.TileAIShutdown;
import makeo.gadomancy.common.blocks.tiles.TileBlockProtector;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.entities.EntityPermNoClipItem;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.Vector3;
import makeo.gadomancy.common.utils.world.TCMazeHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import thaumcraft.common.items.armor.Hover;

public class EventHandlerEntity {
    public static List<ChunkCoordinates> registeredLuxPylons = new ArrayList<ChunkCoordinates>();

    @SubscribeEvent
    public void on(LivingSpawnEvent.CheckSpawn event) {
        if (event.entityLiving.isCreatureType(EnumCreatureType.monster, false)) {
            double rangeSq = AuraEffects.LUX.getRange() * AuraEffects.LUX.getRange();
            Vector3 entityPos = MiscUtils.getPositionVector(event.entity);
            for (ChunkCoordinates luxPylons : registeredLuxPylons) {
                Vector3 pylon = Vector3.fromCC(luxPylons);
                if (!(entityPos.distanceSquared(pylon) <= rangeSq)) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent
    public void on(EnderTeleportEvent e) {
        if (!(e.entityLiving instanceof EntityPlayer) && !(e.entityLiving instanceof IBossDisplayData) && TileBlockProtector.isSpotProtected(e.entityLiving.field_70170_p, (Entity)e.entityLiving)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void on(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            if (event.entityLiving instanceof EntityPlayer) {
                TCMazeHandler.closeSession((EntityPlayer)event.entityLiving, false);
            }
            if (event.entityLiving instanceof EntityLiving) {
                TileAIShutdown.removeTrackedEntity((EntityLiving)event.entityLiving);
            }
        }
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.item instanceof EntityPermNoClipItem) {
            EntityPermNoClipItem item = (EntityPermNoClipItem)event.item;
            ChunkCoordinates master = (ChunkCoordinates)item.func_70096_w().func_75691_i(ModConfig.entityNoClipItemDatawatcherMasterId).func_75669_b();
            TileEntity te = event.entityPlayer.field_70170_p.func_147438_o(master.field_71574_a, master.field_71572_b, master.field_71573_c);
            if (!(te instanceof EntityPermNoClipItem.IItemMasterTile)) {
                return;
            }
            ((EntityPermNoClipItem.IItemMasterTile)te).informItemRemoval();
        }
    }

    @SubscribeEvent
    public void on(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        if (event.entity.field_70170_p.field_73011_w.field_76574_g == ModConfig.dimOuterId && (player.field_70173_aa & 7) == 0 && (player.field_71075_bZ.field_75100_b || Hover.getHover((int)player.func_145782_y()))) {
            if (player.field_71075_bZ.field_75098_d && MiscUtils.isANotApprovedOrMisunderstoodPersonFromMoreDoor(player)) {
                return;
            }
            player.field_71075_bZ.field_75100_b = false;
            Hover.setHover((int)player.func_145782_y(), (boolean)false);
            if (!((EntityPlayer)event.entityLiving).field_70170_p.field_72995_K) {
                String msg = StatCollector.func_74838_a((String)"tc.break.fly");
                if (player.field_71075_bZ.field_75098_d) {
                    msg = msg + " " + StatCollector.func_74838_a((String)"gadomancy.eldritch.noflyCreative");
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + msg));
            }
        }
    }
}

