/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.effect.fx;

import java.awt.Color;
import java.util.Random;
import makeo.gadomancy.client.effect.fx.FXFlow;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public abstract class EntityFXFlowPolicy {
    public abstract void doSubParticles(FXFlow var1, int var2, double var3, double var5, double var7, double var9, double var11, double var13);

    static class CircularMixPolicy
    extends CircularPolicy {
        CircularMixPolicy() {
        }

        @Override
        public void doSubParticles(FXFlow fxFlow, int policyCounter, double posX, double posY, double posZ, double lastPosX, double lastPosY, double lastPosZ) {
            super.doSubParticles(fxFlow, policyCounter, posX, posY, posZ, lastPosX, lastPosY, lastPosZ);
            ((DefaultPolicy)Policies.DEFAULT.getPolicy()).doParticles(fxFlow, policyCounter, posX, posY, posZ, fxFlow.getRand().nextInt(2));
        }
    }

    static class CircularPolicy
    extends EntityFXFlowPolicy {
        public static final int TICKS_PER_FULL_TURN = 40;

        CircularPolicy() {
        }

        @Override
        public void doSubParticles(FXFlow fxFlow, int policyCounter, double posX, double posY, double posZ, double lastPosX, double lastPosY, double lastPosZ) {
            Vector3 rotationAxis = fxFlow.getMovementVector();
            Vector3 perpendicular = rotationAxis.clone().perpendicular().normalize().multiply(fxFlow.getSurroundingDistance());
            Vector3 counterSide = perpendicular.clone().rotate(Math.toRadians(180.0), rotationAxis);
            int currentDividedPolicyTick = policyCounter % 40;
            float currentDegree = 360.0f * ((float)currentDividedPolicyTick / 40.0f);
            double currentRad = Math.toRadians(currentDegree);
            perpendicular = perpendicular.rotate(currentRad, rotationAxis);
            counterSide = counterSide.rotate(currentRad, rotationAxis);
            World w = fxFlow.getOriginWorld();
            Color c = fxFlow.getFadingColor() != null ? fxFlow.getFadingColor() : fxFlow.getColor();
            FXFlow.FXFlowBase flow = new FXFlow.FXFlowBase(w, posX + perpendicular.getX(), posY + perpendicular.getY(), posZ + perpendicular.getZ(), c, fxFlow.getSurroundingParticleSize(), 6, 240);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flow);
            FXFlow.FXFlowBase flow2 = new FXFlow.FXFlowBase(w, posX + counterSide.getX(), posY + counterSide.getY(), posZ + counterSide.getZ(), c, fxFlow.getSurroundingParticleSize(), 6, 240);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flow2);
        }
    }

    static class DefaultPolicy
    extends EntityFXFlowPolicy {
        DefaultPolicy() {
        }

        @Override
        public void doSubParticles(FXFlow fxFlow, int policyCounter, double posX, double posY, double posZ, double lastPosX, double lastPosY, double lastPosZ) {
            this.doParticles(fxFlow, policyCounter, posX, posY, posZ, fxFlow.getRand().nextInt(3) + 1);
        }

        public void doParticles(FXFlow fxFlow, int policyCounter, double posX, double posY, double posZ, int count) {
            Random rand = fxFlow.getOriginWorld().field_73012_v;
            for (int i = 0; i < count; ++i) {
                Vector3 subOffset = this.genSubOffset(rand, fxFlow.getSurroundingDistance());
                Color c = fxFlow.getFadingColor() != null && rand.nextBoolean() ? fxFlow.getFadingColor() : fxFlow.getColor();
                FXFlow.FXFlowBase flow = new FXFlow.FXFlowBase(fxFlow.getOriginWorld(), posX + subOffset.getX(), posY + subOffset.getY(), posZ + subOffset.getZ(), c, (float)rand.nextInt(1) + fxFlow.getSurroundingParticleSize(), 6, 240);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flow);
            }
        }

        private Vector3 genSubOffset(Random rand, float surroundingDistance) {
            float x = rand.nextFloat() / 4.0f * surroundingDistance * (float)(rand.nextBoolean() ? 1 : -1);
            float y = rand.nextFloat() / 4.0f * surroundingDistance * (float)(rand.nextBoolean() ? 1 : -1);
            float z = rand.nextFloat() / 4.0f * surroundingDistance * (float)(rand.nextBoolean() ? 1 : -1);
            return new Vector3(x, y, z);
        }
    }

    public static enum Policies {
        NO_OP(null),
        CIRCLE_MIX(new CircularMixPolicy()),
        CIRCLE(new CircularPolicy()),
        DEFAULT(new DefaultPolicy());

        private EntityFXFlowPolicy policy;

        private Policies(EntityFXFlowPolicy policy) {
            this.policy = policy;
        }

        public EntityFXFlowPolicy getPolicy() {
            return this.policy;
        }
    }
}

