/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockBubbleColumn;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EtFuturumWorldListener
implements IWorldAccess {
    private final World world;
    private static final Map<Block, Block> replacements = Maps.newHashMap();
    public static final Map<Block, Block> bubbleColumnMap = Maps.newHashMap();

    public EtFuturumWorldListener(World theWorld) {
        this.world = theWorld;
        if (ModBlocks.BREWING_STAND.isEnabled()) {
            if (ConfigWorld.tileReplacementMode == 0) {
                replacements.put(Blocks.field_150382_bo, ModBlocks.BREWING_STAND.get());
            } else if (ConfigWorld.tileReplacementMode == 1) {
                replacements.put(ModBlocks.BREWING_STAND.get(), Blocks.field_150382_bo);
            }
        }
        if (ModBlocks.BEACON.isEnabled()) {
            if (ConfigWorld.tileReplacementMode == 0) {
                replacements.put((Block)Blocks.field_150461_bJ, ModBlocks.BEACON.get());
            } else if (ConfigWorld.tileReplacementMode == 1) {
                replacements.put(ModBlocks.BEACON.get(), (Block)Blocks.field_150461_bJ);
            }
        }
        if (ModBlocks.ENCHANTMENT_TABLE.isEnabled()) {
            if (ConfigWorld.tileReplacementMode == 0) {
                replacements.put(Blocks.field_150381_bn, ModBlocks.ENCHANTMENT_TABLE.get());
            } else if (ConfigWorld.tileReplacementMode == 1) {
                replacements.put(ModBlocks.ENCHANTMENT_TABLE.get(), Blocks.field_150381_bn);
            }
        }
        if (ModBlocks.ANVIL.isEnabled()) {
            if (ConfigWorld.tileReplacementMode == 0) {
                replacements.put(Blocks.field_150467_bQ, ModBlocks.ANVIL.get());
            } else if (ConfigWorld.tileReplacementMode == 1) {
                replacements.put(ModBlocks.ANVIL.get(), Blocks.field_150467_bQ);
            }
        }
        if (ModBlocks.SPONGE.isEnabled()) {
            if (ConfigWorld.tileReplacementMode == 0) {
                replacements.put(Blocks.field_150360_v, ModBlocks.SPONGE.get());
            } else if (ConfigWorld.tileReplacementMode == 1) {
                replacements.put(ModBlocks.SPONGE.get(), Blocks.field_150360_v);
            }
        }
        if (ModBlocks.DAYLIGHT_DETECTOR.isEnabled() && ConfigWorld.tileReplacementMode != -1) {
            replacements.put(ModBlocks.DAYLIGHT_DETECTOR.get(), (Block)Blocks.field_150453_bW);
        }
        if (ModsList.BACK_IN_SLIME.isLoaded() && ConfigMixins.betterPistons) {
            replacements.put(GameRegistry.findBlock((String)"bis", (String)"SlimePistonBase"), (Block)Blocks.field_150331_J);
            replacements.put(GameRegistry.findBlock((String)"bis", (String)"StickySlimePistonBase"), (Block)Blocks.field_150320_F);
            replacements.put(GameRegistry.findBlock((String)"bis", (String)"SlimePistonHead"), (Block)Blocks.field_150332_K);
            if (ModBlocks.SLIME.isEnabled()) {
                replacements.put(GameRegistry.findBlock((String)"bis", (String)"SlimeBlock"), ModBlocks.SLIME.get());
            }
        }
    }

    public void func_147586_a(int x, int y, int z) {
        if (replacements.isEmpty() || !this.world.func_72899_e(x, y, z)) {
            return;
        }
        this.handleBasaltFromLava(x, y, z);
        for (ForgeDirection dir : Utils.FORGE_DIRECTIONS) {
            this.handleBubbleColumnCreation(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        }
        Block replacement = replacements.get(this.world.func_147439_a(x, y, z));
        if (replacement == null) {
            return;
        }
        TileEntity tile = this.world.func_147438_o(x, y, z);
        NBTTagCompound nbt = new NBTTagCompound();
        if (tile != null) {
            tile.func_145841_b(nbt);
            if (tile instanceof IInventory) {
                IInventory invt = (IInventory)tile;
                for (int j = 0; j < invt.func_70302_i_(); ++j) {
                    invt.func_70299_a(j, null);
                }
            }
        }
        int replacementMeta = this.world.func_72805_g(x, y, z);
        this.world.func_147465_d(x, y, z, replacement, replacementMeta, 2);
        TileEntity newTile = this.world.func_147438_o(x, y, z);
        if (newTile != null) {
            newTile.func_145839_a(nbt);
        }
    }

    private void handleBasaltFromLava(int x, int y, int z) {
        if (ModBlocks.BASALT.isEnabled() && this.world.func_147439_a(x, y, z).func_149688_o() == Material.field_151587_i) {
            Block soulsand;
            Block block = soulsand = ModBlocks.SOUL_SOIL.isEnabled() ? ModBlocks.SOUL_SOIL.get() : Blocks.field_150425_aM;
            if (this.world.func_147439_a(x, y - 1, z) == soulsand) {
                Block ice = ModBlocks.BLUE_ICE.isEnabled() ? ModBlocks.BLUE_ICE.get() : Blocks.field_150403_cj;
                for (EnumFacing facing : Utils.ENUM_FACING_VALUES) {
                    if (facing == EnumFacing.DOWN || this.world.func_147439_a(x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e()) != ice) continue;
                    this.world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.8f);
                    for (int l = 0; l < 8; ++l) {
                        this.world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0);
                    }
                    this.world.func_147449_b(x, y, z, ModBlocks.BASALT.get());
                    return;
                }
            }
        }
    }

    private void handleBubbleColumnCreation(int x, int y, int z) {
        Block block;
        if (!bubbleColumnMap.isEmpty() && this.world.func_72899_e(x, y, z) && BlockBubbleColumn.isFullVanillaWater(this.world.func_147439_a(x, y + 1, z), this.world.func_72805_g(x, y + 1, z)) && (block = bubbleColumnMap.get(this.world.func_147439_a(x, y, z))) != null) {
            this.world.func_147465_d(x, y + 1, z, block, 0, 3);
        }
    }

    public void func_147588_b(int p_147588_1_, int p_147588_2_, int p_147588_3_) {
    }

    public void func_147585_a(int p_147585_1_, int p_147585_2_, int p_147585_3_, int p_147585_4_, int p_147585_5_, int p_147585_6_) {
    }

    public void func_72704_a(String soundName, double x, double y, double z, float volume, float pitch) {
    }

    public void func_85102_a(EntityPlayer p_85102_1_, String p_85102_2_, double p_85102_3_, double p_85102_5_, double p_85102_7_, float p_85102_9_, float p_85102_10_) {
    }

    public void func_72708_a(String p_72708_1_, double p_72708_2_, double p_72708_4_, double p_72708_6_, double p_72708_8_, double p_72708_10_, double p_72708_12_) {
    }

    public void func_72703_a(Entity p_72703_1_) {
    }

    public void func_72709_b(Entity p_72709_1_) {
    }

    public void func_72702_a(String p_72702_1_, int p_72702_2_, int p_72702_3_, int p_72702_4_) {
    }

    public void func_82746_a(int p_82746_1_, int p_82746_2_, int p_82746_3_, int p_82746_4_, int p_82746_5_) {
    }

    public void func_72706_a(EntityPlayer p_72706_1_, int p_72706_2_, int p_72706_3_, int p_72706_4_, int p_72706_5_, int p_72706_6_) {
    }

    public void func_147587_b(int p_147587_1_, int p_147587_2_, int p_147587_3_, int p_147587_4_, int p_147587_5_) {
    }

    public void func_147584_b() {
    }
}

