/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;

public class LetsEncryptHelper {
    private LetsEncryptHelper() {
    }

    public static void replaceSSLContext() {
        if (!ArchaicConfig.enableLetsEncryptRoot) {
            return;
        }
        try (InputStream x1 = LetsEncryptHelper.class.getResourceAsStream("/letsencrypt/isrgrootx1.pem");
             InputStream x2 = LetsEncryptHelper.class.getResourceAsStream("/letsencrypt/isrg-root-x2.pem");){
            KeyStore merged = KeyStore.getInstance(KeyStore.getDefaultType());
            Path cacerts = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            merged.load(Files.newInputStream(cacerts, new OpenOption[0]), "changeit".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cx1 = cf.generateCertificate(x1);
            merged.setCertificateEntry("archaicfix-isrgx1", cx1);
            Certificate cx2 = cf.generateCertificate(x2);
            merged.setCertificateEntry("archaicfix-isrgx2", cx2);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(merged);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
            ArchaicLogger.LOGGER.info("[LetsEncryptHelper] Added certificates to trust store.");
        }
        catch (IOException e) {
            ArchaicLogger.LOGGER.error("[LetsEncryptHelper] Failed to load certificates from classpath.", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            ArchaicLogger.LOGGER.error("[LetsEncryptHelper] Failed to load default keystore.", (Throwable)e);
        }
    }
}

