/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.ISimplifiedBundle;
import appeng.block.AEBaseBlock;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.BusRenderer;
import appeng.client.render.RenderBlocksWorkaround;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.MissingIcon;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.tile.AEBaseTile;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public final class BusRenderHelper
implements IPartRenderHelper {
    public static final ThreadLocal<BusRenderHelper> instances = ThreadLocal.withInitial(BusRenderHelper::new);
    private static final int HEX_WHITE = 0xFFFFFF;
    private final BoundBoxCalculator bbc = new BoundBoxCalculator(this);
    private final boolean noAlphaPass = !AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass);
    private final BaseBlockRender<AEBaseBlock, AEBaseTile> bbr = new BaseBlockRender();
    private final Optional<Block> maybeBlock;
    private final Optional<AEBaseBlock> maybeBaseBlock;
    private int renderingForPass = 0;
    private int currentPass = 0;
    private int itemsRendered = 0;
    private double minX = 0.0;
    private double minY = 0.0;
    private double minZ = 0.0;
    private double maxX = 16.0;
    private double maxY = 16.0;
    private double maxZ = 16.0;
    private ForgeDirection ax = ForgeDirection.EAST;
    private ForgeDirection ay;
    private ForgeDirection az = ForgeDirection.SOUTH;
    private int color = 0xFFFFFF;

    public BusRenderHelper() {
        this.ay = ForgeDirection.UP;
        this.maybeBlock = AEApi.instance().definitions().blocks().multiPart().maybeBlock();
        this.maybeBaseBlock = this.maybeBlock.transform((Function)new BaseBlockTransformFunction());
    }

    public int getItemsRendered() {
        return this.itemsRendered;
    }

    public void setPass(int pass) {
        this.renderingForPass = 0;
        this.currentPass = pass;
        this.itemsRendered = 0;
    }

    public double getBound(ForgeDirection side) {
        double d;
        switch (side) {
            default: {
                d = 0.5;
                break;
            }
            case DOWN: {
                d = this.minY;
                break;
            }
            case EAST: {
                d = this.maxX;
                break;
            }
            case NORTH: {
                d = this.minZ;
                break;
            }
            case SOUTH: {
                d = this.maxZ;
                break;
            }
            case UP: {
                d = this.maxY;
                break;
            }
            case WEST: {
                d = this.minX;
            }
        }
        return d;
    }

    public void setRenderColor(int color) {
        for (Block block : AEApi.instance().definitions().blocks().multiPart().maybeBlock().asSet()) {
            BlockCableBus cableBus = (BlockCableBus)block;
            cableBus.setRenderColor(color);
        }
    }

    public void setOrientation(ForgeDirection dx, ForgeDirection dy, ForgeDirection dz) {
        this.ax = dx == null ? ForgeDirection.EAST : dx;
        this.ay = dy == null ? ForgeDirection.UP : dy;
        this.az = dz == null ? ForgeDirection.SOUTH : dz;
    }

    public double[] getBounds() {
        return new double[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public void setBounds(double[] bounds) {
        if (bounds == null || bounds.length != 6) {
            return;
        }
        this.minX = bounds[0];
        this.minY = bounds[1];
        this.minZ = bounds[2];
        this.maxX = bounds[3];
        this.maxY = bounds[4];
        this.maxZ = bounds[5];
    }

    @Override
    public void renderForPass(int pass) {
        this.renderingForPass = pass;
    }

    private boolean renderThis() {
        if (this.renderingForPass == this.currentPass || this.noAlphaPass) {
            ++this.itemsRendered;
            return true;
        }
        return false;
    }

    @Override
    public void normalRendering() {
        RenderBlocksWorkaround rbw = BusRenderer.INSTANCE.getRenderer();
        rbw.setCalculations(true);
        rbw.setUseTextures(true);
        rbw.field_147863_w = false;
    }

    @Override
    public ISimplifiedBundle useSimplifiedRendering(int x, int y, int z, IBoxProvider p, ISimplifiedBundle sim) {
        RenderBlocksWorkaround rbw = BusRenderer.INSTANCE.getRenderer();
        if (sim != null && this.maybeBlock.isPresent() && rbw.similarLighting((Block)this.maybeBlock.get(), rbw.field_147845_a, x, y, z, sim)) {
            rbw.populate(sim);
            rbw.setFaces(EnumSet.allOf(ForgeDirection.class));
            rbw.setCalculations(false);
            rbw.setUseTextures(false);
            return sim;
        }
        boolean allFaces = rbw.field_147837_f;
        rbw.field_147837_f = true;
        rbw.setCalculations(true);
        rbw.getFaces().clear();
        this.bbc.started = false;
        if (p == null) {
            this.bbc.minX = (this.bbc.minY = (this.bbc.minZ = 0.0f));
            this.bbc.maxX = (this.bbc.maxY = (this.bbc.maxZ = 16.0f));
        } else {
            p.getBoxes(this.bbc);
            if (this.bbc.minX < 1.0f) {
                this.bbc.minX = 1.0f;
            }
            if (this.bbc.minY < 1.0f) {
                this.bbc.minY = 1.0f;
            }
            if (this.bbc.minZ < 1.0f) {
                this.bbc.minZ = 1.0f;
            }
            if (this.bbc.maxX > 15.0f) {
                this.bbc.maxX = 15.0f;
            }
            if (this.bbc.maxY > 15.0f) {
                this.bbc.maxY = 15.0f;
            }
            if (this.bbc.maxZ > 15.0f) {
                this.bbc.maxZ = 15.0f;
            }
        }
        this.setBounds(this.bbc.minX, this.bbc.minY, this.bbc.minZ, this.bbc.maxX, this.bbc.maxY, this.bbc.maxZ);
        this.bbr.renderBlockBounds(rbw, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.ax, this.ay, this.az);
        for (Block block : this.maybeBlock.asSet()) {
            rbw.func_147784_q(block, x, y, z);
        }
        rbw.setFaces(EnumSet.allOf(ForgeDirection.class));
        rbw.field_147837_f = allFaces;
        rbw.setCalculations(false);
        rbw.setUseTextures(false);
        return rbw.getLightingCache();
    }

    @Override
    public void setBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    @Override
    public void setInvColor(int newColor) {
        this.color = newColor;
    }

    @Override
    public void setTexture(IIcon ico) {
        for (AEBaseBlock baseBlock : this.maybeBaseBlock.asSet()) {
            baseBlock.getRendererInstance().setTemporaryRenderIcon(ico);
        }
    }

    @Override
    public void setTexture(IIcon down, IIcon up, IIcon north, IIcon south, IIcon west, IIcon east) {
        IIcon[] list = new IIcon[]{down, up, north, south, west, east};
        for (AEBaseBlock baseBlock : this.maybeBaseBlock.asSet()) {
            baseBlock.getRendererInstance().setTemporaryRenderIcons(list[this.mapRotation(ForgeDirection.UP).ordinal()], list[this.mapRotation(ForgeDirection.DOWN).ordinal()], list[this.mapRotation(ForgeDirection.SOUTH).ordinal()], list[this.mapRotation(ForgeDirection.NORTH).ordinal()], list[this.mapRotation(ForgeDirection.EAST).ordinal()], list[this.mapRotation(ForgeDirection.WEST).ordinal()]);
        }
    }

    private ForgeDirection mapRotation(ForgeDirection dir) {
        ForgeDirection forward = this.az;
        ForgeDirection up = this.ay;
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        ForgeDirection west = ForgeDirection.UNKNOWN;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir == forward) {
            return ForgeDirection.SOUTH;
        }
        if (dir == forward.getOpposite()) {
            return ForgeDirection.NORTH;
        }
        if (dir == up) {
            return ForgeDirection.UP;
        }
        if (dir == up.getOpposite()) {
            return ForgeDirection.DOWN;
        }
        if (dir == west) {
            return ForgeDirection.WEST;
        }
        if (dir == west.getOpposite()) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void renderInventoryBox(RenderBlocks renderer) {
        renderer.func_147782_a(this.minX / 16.0, this.minY / 16.0, this.minZ / 16.0, this.maxX / 16.0, this.maxY / 16.0, this.maxZ / 16.0);
        for (AEBaseBlock baseBlock : this.maybeBaseBlock.asSet()) {
            this.bbr.renderInvBlock(EnumSet.allOf(ForgeDirection.class), baseBlock, null, Tessellator.field_78398_a, this.color, renderer);
        }
    }

    @Override
    public void renderInventoryFace(IIcon icon, ForgeDirection face, RenderBlocks renderer) {
        renderer.func_147782_a(this.minX / 16.0, this.minY / 16.0, this.minZ / 16.0, this.maxX / 16.0, this.maxY / 16.0, this.maxZ / 16.0);
        this.setTexture(icon);
        for (AEBaseBlock baseBlock : this.maybeBaseBlock.asSet()) {
            this.bbr.renderInvBlock(EnumSet.of(face), baseBlock, null, Tessellator.field_78398_a, this.color, renderer);
        }
    }

    @Override
    public void renderBlock(int x, int y, int z, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        for (Block multiPart : AEApi.instance().definitions().blocks().multiPart().maybeBlock().asSet()) {
            AEBaseBlock block = (AEBaseBlock)multiPart;
            BlockRenderInfo info = block.getRendererInstance();
            ForgeDirection forward = BusRenderHelper.instances.get().az;
            ForgeDirection up = BusRenderHelper.instances.get().ay;
            boolean isTemp = false;
            if (!info.isValid() && !info.hasTemporaryRenderIcons()) {
                FlippableIcon i = new FlippableIcon(new MissingIcon(this));
                info.setTemporaryRenderIcon(i);
                isTemp = true;
            }
            renderer.field_147865_v = info.getTexture(ForgeDirection.DOWN).setFlip(BaseBlockRender.getOrientation(ForgeDirection.DOWN, forward, up));
            renderer.field_147867_u = info.getTexture(ForgeDirection.UP).setFlip(BaseBlockRender.getOrientation(ForgeDirection.UP, forward, up));
            renderer.field_147875_q = info.getTexture(ForgeDirection.EAST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.EAST, forward, up));
            renderer.field_147873_r = info.getTexture(ForgeDirection.WEST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.WEST, forward, up));
            renderer.field_147869_t = info.getTexture(ForgeDirection.NORTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.NORTH, forward, up));
            renderer.field_147871_s = info.getTexture(ForgeDirection.SOUTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.SOUTH, forward, up));
            this.bbr.renderBlockBounds(renderer, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.ax, this.ay, this.az);
            renderer.func_147784_q((Block)block, x, y, z);
            if (!isTemp) continue;
            info.setTemporaryRenderIcon(null);
        }
    }

    @Override
    public Block getBlock() {
        Iterator iterator = AEApi.instance().definitions().blocks().multiPart().maybeBlock().asSet().iterator();
        if (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            return block;
        }
        throw new MissingDefinition("Tried to access the multi part block without it being defined.");
    }

    public void prepareBounds(RenderBlocks renderer) {
        this.bbr.renderBlockBounds(renderer, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.ax, this.ay, this.az);
    }

    @Override
    public void setFacesToRender(EnumSet<ForgeDirection> faces) {
        BusRenderer.INSTANCE.getRenderer().setRenderFaces(faces);
    }

    @Override
    public void renderBlockCurrentBounds(int x, int y, int z, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        for (Block block : this.maybeBlock.asSet()) {
            renderer.func_147784_q(block, x, y, z);
        }
    }

    @Override
    public void renderFaceCutout(int x, int y, int z, IIcon ico, ForgeDirection face, float edgeThickness, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        switch (face) {
            case DOWN: {
                face = this.ay.getOpposite();
                break;
            }
            case EAST: {
                face = this.ax;
                break;
            }
            case NORTH: {
                face = this.az.getOpposite();
                break;
            }
            case SOUTH: {
                face = this.az;
                break;
            }
            case UP: {
                face = this.ay;
                break;
            }
            case WEST: {
                face = this.ax.getOpposite();
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        for (AEBaseBlock block : this.maybeBaseBlock.asSet()) {
            this.bbr.renderCutoutFace(block, ico, x, y, z, renderer, face, edgeThickness);
        }
    }

    @Override
    public void renderFace(int x, int y, int z, IIcon ico, ForgeDirection face, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        this.prepareBounds(renderer);
        switch (face) {
            case DOWN: {
                face = this.ay.getOpposite();
                break;
            }
            case EAST: {
                face = this.ax;
                break;
            }
            case NORTH: {
                face = this.az.getOpposite();
                break;
            }
            case SOUTH: {
                face = this.az;
                break;
            }
            case UP: {
                face = this.ay;
                break;
            }
            case WEST: {
                face = this.ax.getOpposite();
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        for (AEBaseBlock block : this.maybeBaseBlock.asSet()) {
            this.bbr.renderFace(x, y, z, block, ico, renderer, face);
        }
    }

    @Override
    public ForgeDirection getWorldX() {
        return this.ax;
    }

    @Override
    public ForgeDirection getWorldY() {
        return this.ay;
    }

    @Override
    public ForgeDirection getWorldZ() {
        return this.az;
    }

    private static class BoundBoxCalculator
    implements IPartCollisionHelper {
        private final BusRenderHelper helper;
        private boolean started = false;
        private float minX;
        private float minY;
        private float minZ;
        private float maxX;
        private float maxY;
        private float maxZ;

        public BoundBoxCalculator(BusRenderHelper helper) {
            this.helper = helper;
        }

        @Override
        public void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            if (this.started) {
                this.minX = Math.min(this.minX, (float)minX);
                this.minY = Math.min(this.minY, (float)minY);
                this.minZ = Math.min(this.minZ, (float)minZ);
                this.maxX = Math.max(this.maxX, (float)maxX);
                this.maxY = Math.max(this.maxY, (float)maxY);
                this.maxZ = Math.max(this.maxZ, (float)maxZ);
            } else {
                this.started = true;
                this.minX = (float)minX;
                this.minY = (float)minY;
                this.minZ = (float)minZ;
                this.maxX = (float)maxX;
                this.maxY = (float)maxY;
                this.maxZ = (float)maxZ;
            }
        }

        @Override
        public ForgeDirection getWorldX() {
            return this.helper.ax;
        }

        @Override
        public ForgeDirection getWorldY() {
            return this.helper.ay;
        }

        @Override
        public ForgeDirection getWorldZ() {
            return this.helper.az;
        }

        @Override
        public boolean isBBCollision() {
            return false;
        }
    }

    private static final class BaseBlockTransformFunction
    implements Function<Block, AEBaseBlock> {
        private BaseBlockTransformFunction() {
        }

        @Nullable
        public AEBaseBlock apply(Block input) {
            if (input instanceof AEBaseBlock) {
                return (AEBaseBlock)input;
            }
            return null;
        }
    }
}

