/*
 * Decompiled with CFR 0.152.
 */
package org.taumc.celeritas.api.options;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class OptionIdentifier<T> {
    private final String modId;
    private final String path;
    private final Class<T> clz;
    private static final ObjectOpenHashSet<OptionIdentifier<?>> IDENTIFIERS = new ObjectOpenHashSet();
    public static final OptionIdentifier<Void> EMPTY = OptionIdentifier.create("", "", Void.class);

    private OptionIdentifier(String modId, String path, Class<T> clz) {
        this.modId = modId;
        this.path = path;
        this.clz = clz;
    }

    public String getModId() {
        return this.modId;
    }

    public String getPath() {
        return this.path;
    }

    public Class<T> getType() {
        return this.clz;
    }

    public static OptionIdentifier<Void> create(String modId, String path) {
        return OptionIdentifier.create(modId, path, Void.TYPE);
    }

    public static synchronized <T> OptionIdentifier<T> create(String modId, String path, Class<T> clz) {
        OptionIdentifier<T> ourIdentifier;
        OptionIdentifier oldIdentifier;
        if (modId.equals("embeddium")) {
            modId = "celeritas";
        }
        if ((oldIdentifier = (OptionIdentifier)IDENTIFIERS.addOrGet(ourIdentifier = new OptionIdentifier<T>(modId, path, clz))) != null && oldIdentifier.clz != ourIdentifier.clz) {
            throw new IllegalArgumentException(String.format("OptionIdentifier '%s' created with differing class type %s from existing instance %s", ourIdentifier, ourIdentifier.clz, oldIdentifier.clz));
        }
        return oldIdentifier;
    }

    public static boolean isPresent(@Nullable OptionIdentifier<?> id) {
        return id != null && id != EMPTY;
    }

    public boolean matches(OptionIdentifier<?> other) {
        return this == other;
    }

    public <U> OptionIdentifier<U> cast() {
        return this;
    }

    public String toString() {
        return OptionIdentifier.jvmdowngrader$concat$toString$1(this.modId, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionIdentifier that = (OptionIdentifier)o;
        return Objects.equals(this.modId, that.modId) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.modId, this.path);
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
        return string + ":" + string2;
    }
}

