/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.rand;

import java.util.Random;
import org.embeddedt.embeddium.impl.util.rand.SplitMixRandom;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class XoRoShiRoRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private SplitMixRandom mixer;
    private long seed = Long.MIN_VALUE;
    private long p0;
    private long p1;
    private long s0;
    private long s1;
    private boolean hasSavedState;
    private static final SplitMixRandom seedUniquifier = new SplitMixRandom(System.nanoTime());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long randomSeed() {
        long x;
        SplitMixRandom splitMixRandom = seedUniquifier;
        synchronized (splitMixRandom) {
            x = seedUniquifier.nextLong();
        }
        return x ^ System.nanoTime();
    }

    public XoRoShiRoRandom() {
        this(XoRoShiRoRandom.randomSeed());
    }

    public XoRoShiRoRandom(long seed) {
        this.setSeed(seed);
    }

    @Override
    public long nextLong() {
        long s0 = this.s0;
        long s1 = this.s1;
        long result = s0 + s1;
        this.s0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.s1 = Long.rotateLeft(s1, 37);
        return result;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException(XoRoShiRoRandom.jvmdowngrader$concat$nextLong$1(n));
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t >>> Long.numberOfLeadingZeros(nMinus1) & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    @Override
    public double nextDouble() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        while (i != 0) {
            int n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
        if (this.hasSavedState && this.seed == seed) {
            this.s0 = this.p0;
            this.s1 = this.p1;
        } else {
            SplitMixRandom mixer = this.mixer;
            if (mixer == null) {
                mixer = this.mixer = new SplitMixRandom(seed);
            } else {
                mixer.setSeed(seed);
            }
            this.s0 = mixer.nextLong();
            this.s1 = mixer.nextLong();
            this.p0 = this.s0;
            this.p1 = this.s1;
            this.seed = seed;
            this.hasSavedState = true;
        }
    }

    public XoRoShiRoRandom setSeedAndReturn(long seed) {
        this.setSeed(seed);
        return this;
    }

    private static /* synthetic */ String jvmdowngrader$concat$nextLong$1(long l) {
        return "illegal bound " + l + " (must be positive)";
    }
}

