/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.collections;

import java.util.Arrays;
import org.embeddedt.embeddium.impl.util.collections.ReadQueue;
import org.embeddedt.embeddium.impl.util.collections.WriteQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={QueueImpl.class})
public final class DoubleBufferedQueue<E> {
    private QueueImpl<E> read = new QueueImpl();
    private QueueImpl<E> write = new QueueImpl();

    public boolean flip() {
        if (this.write.size() == 0) {
            return false;
        }
        QueueImpl<E> tmp = this.read;
        this.read = this.write;
        this.write = tmp;
        this.write.clear();
        return true;
    }

    public void reset() {
        this.read.clear();
        this.write.clear();
    }

    public ReadQueue<E> read() {
        return this.read;
    }

    public WriteQueue<E> write() {
        return this.write;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=DoubleBufferedQueue.class)
    private static final class QueueImpl<E>
    implements ReadQueue<E>,
    WriteQueue<E> {
        private E[] elements;
        private int readIndex;
        private int writeIndex;

        QueueImpl() {
            this(256);
        }

        QueueImpl(int capacity) {
            this.elements = new Object[capacity];
        }

        @Override
        public void ensureCapacity(int numElements) {
            int len = this.writeIndex + numElements;
            if (len > this.elements.length) {
                this.grow(len);
            }
        }

        @Override
        @Nullable
        public E dequeue() {
            if (this.readIndex == this.writeIndex) {
                return null;
            }
            return this.elements[this.readIndex++];
        }

        @Override
        public void enqueue(@NotNull E e) {
            if (this.writeIndex >= this.elements.length) {
                this.resize(this.writeIndex + 1);
            }
            this.elements[this.writeIndex++] = e;
        }

        public void clear() {
            if (this.writeIndex != 0) {
                Arrays.fill(this.elements, 0, this.writeIndex, null);
            }
            this.readIndex = 0;
            this.writeIndex = 0;
        }

        public int size() {
            return this.writeIndex - this.readIndex;
        }

        private void grow(int minimumSize) {
            this.resize(QueueImpl.getNextSize(minimumSize, this.elements.length));
        }

        private void resize(int length) {
            Object[] elements = new Object[length];
            System.arraycopy(this.elements, 0, elements, 0, this.writeIndex);
            this.elements = elements;
        }

        private static int getNextSize(int minimumSize, int currentSize) {
            return Math.max(minimumSize, currentSize << 1);
        }
    }
}

