/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.sorting;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={SortState.class, Level.class})
public class TranslucentQuadAnalyzer {
    private static final int EXPECTED_QUADS = 1000;
    private final FloatArrayList quadCenters = new FloatArrayList(3000);
    private final Vector3f[] vertexPositions = new Vector3f[4];
    private final Vector3f currentNormal = new Vector3f();
    private final Vector3f globalNormal = new Vector3f();
    private final BitSet normalSigns = new BitSet(1000);
    private static final BitSet EMPTY = new BitSet();
    private int currentVertex;
    private boolean hasDistinctNormals;

    public TranslucentQuadAnalyzer() {
        for (int i = 0; i < 4; ++i) {
            this.vertexPositions[i] = new Vector3f();
        }
    }

    private static BitSet cloneBits(BitSet bits) {
        if (bits.isEmpty()) {
            return EMPTY;
        }
        return (BitSet)bits.clone();
    }

    private boolean areAllQuadsOnSamePlane() {
        float[] centerArray = this.quadCenters.elements();
        float a = this.globalNormal.x;
        float b = this.globalNormal.y;
        float c = this.globalNormal.z;
        float d = a * centerArray[0] + b * centerArray[1] + c * centerArray[2];
        int nQuads = this.quadCenters.size() / 3;
        for (int quadIdx = 1; quadIdx < nQuads; ++quadIdx) {
            int centerOff = quadIdx * 3;
            float candidateD = a * centerArray[centerOff + 0] + b * centerArray[centerOff + 1] + c * centerArray[centerOff + 2];
            if (!(Math.abs(candidateD - d) >= 1.0E-5f)) continue;
            return false;
        }
        return true;
    }

    public SortState getSortState() {
        Level sortLevel;
        if (this.quadCenters.isEmpty()) {
            return SortState.NONE;
        }
        if (this.hasDistinctNormals) {
            sortLevel = Level.DYNAMIC;
        } else {
            Level level = sortLevel = this.areAllQuadsOnSamePlane() ? Level.NONE : Level.STATIC;
        }
        SortState finalState = sortLevel == Level.NONE ? SortState.NONE : (sortLevel.requiresDynamicSorting() ? new SortState(sortLevel, this.quadCenters.toArray(new float[0]), this.quadCenters.size(), TranslucentQuadAnalyzer.cloneBits(this.normalSigns), new Vector3f((Vector3fc)this.globalNormal)) : new SortState(sortLevel, this.quadCenters.elements(), this.quadCenters.size(), this.normalSigns, this.globalNormal));
        return finalState;
    }

    public void clear() {
        this.quadCenters.clear();
        this.currentVertex = 0;
        this.globalNormal.zero();
        this.normalSigns.clear();
        this.hasDistinctNormals = false;
    }

    private void calculateNormal() {
        Vector3f v0 = this.vertexPositions[0];
        float x0 = v0.x;
        float y0 = v0.y;
        float z0 = v0.z;
        Vector3f v1 = this.vertexPositions[1];
        float x1 = v1.x;
        float y1 = v1.y;
        float z1 = v1.z;
        Vector3f v2 = this.vertexPositions[2];
        float x2 = v2.x;
        float y2 = v2.y;
        float z2 = v2.z;
        Vector3f v3 = this.vertexPositions[3];
        float dy0 = y2 - y0;
        float z3 = v3.z;
        float dz1 = z3 - z1;
        float dz0 = z2 - z0;
        float y3 = v3.y;
        float dy1 = y3 - y1;
        float normX = dy0 * dz1 - dz0 * dy1;
        float x3 = v3.x;
        float dx1 = x3 - x1;
        float dx0 = x2 - x0;
        float normY = dz0 * dx1 - dx0 * dz1;
        float normZ = dx0 * dy1 - dy0 * dx1;
        float l = (float)Math.sqrt(normX * normX + normY * normY + normZ * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        this.currentNormal.set(normX, normY, normZ);
    }

    private void captureQuad() {
        float totalX = 0.0f;
        float totalY = 0.0f;
        float totalZ = 0.0f;
        for (Vector3f vertex : this.vertexPositions) {
            totalX += vertex.x;
            totalY += vertex.y;
            totalZ += vertex.z;
        }
        FloatArrayList centers = this.quadCenters;
        int currentQuadIndex = centers.size() / 3;
        centers.ensureCapacity(centers.size() + 3);
        centers.add(totalX / 4.0f);
        centers.add(totalY / 4.0f);
        centers.add(totalZ / 4.0f);
        if (!this.hasDistinctNormals) {
            this.calculateNormal();
            if (this.globalNormal.x == 0.0f && this.globalNormal.y == 0.0f && this.globalNormal.z == 0.0f) {
                this.globalNormal.set((Vector3fc)this.currentNormal);
            } else {
                float dotProduct = this.globalNormal.dot((Vector3fc)this.currentNormal);
                if ((double)Math.abs(dotProduct) >= 0.98) {
                    if (dotProduct < 0.0f) {
                        this.normalSigns.set(currentQuadIndex);
                    }
                } else {
                    this.hasDistinctNormals = true;
                }
            }
        }
    }

    public void capture(ChunkVertexEncoder.Vertex vertex) {
        int i = this.currentVertex;
        this.vertexPositions[i].set(vertex.x, vertex.y, vertex.z);
        if (++i == 4) {
            this.captureQuad();
            i = 0;
        }
        this.currentVertex = i;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="level", type=Level.class), @RecordComponents.Value(name="centers", type=float[].class), @RecordComponents.Value(name="centersLength", type=int.class), @RecordComponents.Value(name="normalSigns", type=BitSet.class), @RecordComponents.Value(name="sharedNormal", type=Vector3f.class)})
    @NestHost(value=TranslucentQuadAnalyzer.class)
    public static final class SortState
    extends J_L_Record {
        private final Level level;
        private final float[] centers;
        private final int centersLength;
        private final BitSet normalSigns;
        private final Vector3f sharedNormal;
        public static final SortState NONE = new SortState(Level.NONE, null, 0, null, null);

        public SortState(Level level, float[] centers, int centersLength, BitSet normalSigns, Vector3f sharedNormal) {
            this.level = level;
            this.centers = centers;
            this.centersLength = centersLength;
            this.normalSigns = normalSigns;
            this.sharedNormal = sharedNormal;
        }

        public boolean requiresDynamicSorting() {
            return this.level.requiresDynamicSorting();
        }

        public SortState compactForStorage() {
            if (this == NONE || this.requiresDynamicSorting()) {
                return this;
            }
            return new SortState(this.level, null, 0, null, null);
        }

        public static SortState compacted(SortState state) {
            return state != null ? state.compactForStorage() : null;
        }

        public final String toString() {
            return SortState.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return SortState.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return SortState.jvmdowngrader$equals$equals(this, o);
        }

        public Level level() {
            return this.level;
        }

        public float[] centers() {
            return this.centers;
        }

        public int centersLength() {
            return this.centersLength;
        }

        public BitSet normalSigns() {
            return this.normalSigns;
        }

        public Vector3f sharedNormal() {
            return this.sharedNormal;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(SortState sortState) {
            SortState sortState2 = sortState;
            return "TranslucentQuadAnalyzer$SortState[" + "level=" + (Object)((Object)sortState.level) + ", " + "centers=" + sortState.centers + ", " + "centersLength=" + sortState.centersLength + ", " + "normalSigns=" + sortState.normalSigns + ", " + "sharedNormal=" + sortState.sharedNormal + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(SortState sortState) {
            Object[] objectArray = new Object[]{sortState.level, sortState.centers, sortState.centersLength, sortState.normalSigns, sortState.sharedNormal};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(SortState sortState, Object object) {
            if (sortState == object) {
                return true;
            }
            if (object != null && object instanceof SortState) {
                SortState sortState2 = (SortState)((Object)object);
                if (Objects.equals((Object)sortState.level, (Object)sortState2.level) && Objects.equals(sortState.centers, sortState2.centers) && sortState.centersLength == sortState2.centersLength && Objects.equals(sortState.normalSigns, sortState2.normalSigns) && Objects.equals(sortState.sharedNormal, sortState2.sharedNormal)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=TranslucentQuadAnalyzer.class)
    public static enum Level {
        NONE,
        STATIC,
        DYNAMIC;

        public static final Level[] VALUES;

        public boolean requiresDynamicSorting() {
            return this.ordinal() >= DYNAMIC.ordinal();
        }

        static {
            VALUES = Level.values();
        }
    }
}

