/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferArena;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferSegment;
import org.embeddedt.embeddium.impl.gl.arena.PendingUpload;
import org.embeddedt.embeddium.impl.gl.arena.staging.FallbackStagingBuffer;
import org.embeddedt.embeddium.impl.gl.arena.staging.MappedStagingBuffer;
import org.embeddedt.embeddium.impl.gl.arena.staging.StagingBuffer;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkSortOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkTaskOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataStorage;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={PendingMeshSortUpload.class, PendingMeshRebuildUpload.class, PendingSectionUpload.class, MeshUploader.class})
public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final BitSet regionIds = new BitSet();
    private int nextFreeId = 0;
    private final StagingBuffer stagingBuffer;
    private final RenderPassConfiguration<?> renderPassConfiguration;

    public RenderRegionManager(CommandList commandList, RenderPassConfiguration<?> renderPassConfiguration) {
        this.stagingBuffer = RenderRegionManager.createStagingBuffer(commandList);
        this.renderPassConfiguration = renderPassConfiguration;
    }

    public void update() {
        this.stagingBuffer.flip();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            ObjectIterator it = this.regions.values().iterator();
            while (it.hasNext()) {
                RenderRegion region = (RenderRegion)it.next();
                region.update(commandList);
                if (!region.isEmpty()) continue;
                region.delete(commandList);
                it.remove();
                this.regionIds.clear(region.getId());
                this.nextFreeId = Math.min(this.nextFreeId, region.getId());
            }
        }
    }

    public void uploadMeshes(CommandList commandList, Collection<ChunkJobResult.Success<? extends ChunkTaskOutput>> results, Runnable graphUpdateTrigger) {
        for (Reference2ReferenceMap.Entry entry : this.createMeshUploadQueues(results)) {
            new MeshUploader(commandList, (RenderRegion)entry.getKey(), graphUpdateTrigger).processResults((Collection)entry.getValue());
        }
    }

    private static <K, V> ObjectIterable<Reference2ReferenceMap.Entry<K, V>> fastIterable(Reference2ReferenceMap<K, V> map) {
        ObjectSet entries = map.reference2ReferenceEntrySet();
        return entries instanceof Reference2ReferenceMap.FastEntrySet ? () -> ((Reference2ReferenceMap.FastEntrySet)entries).fastIterator() : entries;
    }

    private Reference2ReferenceMap.FastEntrySet<RenderRegion, List<ChunkTaskOutput>> createMeshUploadQueues(Collection<ChunkJobResult.Success<? extends ChunkTaskOutput>> results) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        for (ChunkJobResult.Success<? extends ChunkTaskOutput> holder : results) {
            ChunkTaskOutput result = holder.output();
            List queue = (List)map.computeIfAbsent((Object)result.render.getRegion(), k -> new ArrayList());
            queue.add(result);
        }
        return map.reference2ReferenceEntrySet();
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.delete(commandList);
        }
        this.regions.clear();
        this.stagingBuffer.delete(commandList);
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    public StagingBuffer getStagingBuffer() {
        return this.stagingBuffer;
    }

    public RenderRegion createForChunk(int chunkX, int chunkY, int chunkZ) {
        return this.create(chunkX >> RenderRegion.REGION_WIDTH_SH, chunkY >> RenderRegion.REGION_HEIGHT_SH, chunkZ >> RenderRegion.REGION_LENGTH_SH);
    }

    private int getNextId() {
        int id = this.nextFreeId;
        this.nextFreeId = this.regionIds.nextClearBit(id + 1);
        this.regionIds.set(id);
        return id;
    }

    @NotNull
    private RenderRegion create(int x, int y, int z) {
        long key = RenderRegion.key(x, y, z);
        RenderRegion instance = (RenderRegion)this.regions.get(key);
        if (instance == null) {
            instance = new RenderRegion(x, y, z, this.getNextId(), this.stagingBuffer);
            this.regions.put(key, (Object)instance);
        }
        return instance;
    }

    public int getRegionIdsLength() {
        return this.regionIds.length();
    }

    private static StagingBuffer createStagingBuffer(CommandList commandList) {
        if (MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)) {
            return new MappedStagingBuffer(commandList);
        }
        return new FallbackStagingBuffer(commandList);
    }

    public /* synthetic */ RenderPassConfiguration jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_region_RenderRegionManager$get$renderPassConfiguration() {
        return this.renderPassConfiguration;
    }

    public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_region_RenderRegionManager$set$renderPassConfiguration(RenderPassConfiguration renderPassConfiguration) {
        this.renderPassConfiguration = renderPassConfiguration;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderRegionManager.class)
    private class MeshUploader {
        private final Map<GlVertexFormat, ArrayList<PendingSectionUpload>> uploadsByFormat = new Object2ObjectOpenHashMap(2);
        private final CommandList commandList;
        private final RenderRegion region;
        private final Runnable graphUpdateTrigger;
        private boolean needIndexBuffer;

        MeshUploader(CommandList commandList, RenderRegion region, Runnable graphUpdateTrigger) {
            this.commandList = commandList;
            this.region = region;
            this.graphUpdateTrigger = graphUpdateTrigger;
        }

        private ArrayList<PendingSectionUpload> getUploadQueue(TerrainRenderPass pass) {
            return this.uploadsByFormat.computeIfAbsent(pass.vertexType().getVertexFormat(), $ -> new ArrayList());
        }

        private void processBuildResult(ChunkBuildOutput result) {
            this.region.removeMeshes(result.render.getSectionIndex());
            for (Reference2ReferenceMap.Entry entry : RenderRegionManager.fastIterable(result.meshes)) {
                BuiltSectionMeshParts mesh = Objects.requireNonNull((BuiltSectionMeshParts)((Object)entry.getValue()));
                this.needIndexBuffer |= mesh.indexBuffer() != null;
                this.getUploadQueue((TerrainRenderPass)entry.getKey()).add(new PendingMeshRebuildUpload(result.render, mesh, (TerrainRenderPass)entry.getKey(), PendingUpload.of(mesh.vertexBuffer()), PendingUpload.of(mesh.indexBuffer())));
            }
        }

        private void processSortResult(ChunkSortOutput result) {
            this.needIndexBuffer = true;
            for (Reference2ReferenceMap.Entry entry : RenderRegionManager.fastIterable(result.meshes)) {
                TerrainRenderPass pass = (TerrainRenderPass)entry.getKey();
                ChunkSortOutput.SortedMesh mesh = (ChunkSortOutput.SortedMesh)((Object)entry.getValue());
                SectionRenderDataStorage storage = this.region.getStorage(pass);
                if (storage != null) {
                    storage.removeIndexBuffer(result.render.getSectionIndex());
                }
                this.getUploadQueue((TerrainRenderPass)entry.getKey()).add(new PendingMeshSortUpload(result.render, pass, PendingUpload.of(mesh.indexData())));
            }
        }

        public void processResults(Collection<? extends ChunkTaskOutput> results) {
            for (ChunkTaskOutput chunkTaskOutput : results) {
                if (chunkTaskOutput instanceof ChunkBuildOutput) {
                    ChunkBuildOutput result = (ChunkBuildOutput)chunkTaskOutput;
                    this.processBuildResult(result);
                    continue;
                }
                if (chunkTaskOutput instanceof ChunkSortOutput) {
                    ChunkSortOutput chunkSortOutput = (ChunkSortOutput)chunkTaskOutput;
                    this.processSortResult(chunkSortOutput);
                    continue;
                }
                throw new IllegalStateException(MeshUploader.jvmdowngrader$concat$processResults$1(chunkTaskOutput.getClass().getName()));
            }
            if (this.uploadsByFormat.isEmpty()) {
                return;
            }
            boolean bufferChanged = false;
            for (Map.Entry<GlVertexFormat, ArrayList<PendingSectionUpload>> entry : this.uploadsByFormat.entrySet()) {
                RenderRegion.DeviceResources resources = this.region.createResources(entry.getKey(), this.commandList);
                ArrayList<PendingSectionUpload> uploads = entry.getValue();
                GlBufferArena geometryArena = resources.getGeometryArena();
                bufferChanged |= geometryArena.upload(this.commandList, uploads.stream().map(PendingSectionUpload::vertexUpload).filter(Objects::nonNull));
                if (!this.needIndexBuffer) continue;
                bufferChanged |= resources.getOrCreateIndexArena(this.commandList).upload(this.commandList, uploads.stream().map(PendingSectionUpload::indexUpload).filter(Objects::nonNull));
            }
            if (bufferChanged) {
                this.region.refresh(this.commandList);
            }
            int n = this.region.getPassSetUpdateCount();
            for (ArrayList<PendingSectionUpload> uploads : this.uploadsByFormat.values()) {
                for (PendingSectionUpload upload : uploads) {
                    SectionRenderDataStorage storage = this.region.createStorage(upload.pass(), RenderRegionManager.this.jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_region_RenderRegionManager$get$renderPassConfiguration());
                    if (upload instanceof PendingMeshRebuildUpload) {
                        PendingMeshRebuildUpload meshUpload = (PendingMeshRebuildUpload)upload;
                        GlBufferSegment indexResult = upload.indexUpload() != null ? upload.indexUpload().getResult() : null;
                        storage.setMeshes(upload.section().getSectionIndex(), upload.vertexUpload().getResult(), indexResult, meshUpload.meshData().ranges());
                        continue;
                    }
                    if (upload instanceof PendingMeshSortUpload) {
                        storage.replaceIndexBuffer(upload.section().getSectionIndex(), upload.indexUpload().getResult());
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
            this.region.removeEmptyStorages();
            if (this.region.getPassSetUpdateCount() != n) {
                this.graphUpdateTrigger.run();
            }
        }

        private static /* synthetic */ String jvmdowngrader$concat$processResults$1(String string) {
            return "Unexpected result type: " + string;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="section", type=RenderSection.class), @RecordComponents.Value(name="pass", type=TerrainRenderPass.class), @RecordComponents.Value(name="indexUpload", type=PendingUpload.class)})
    @NestHost(value=RenderRegionManager.class)
    private static final class PendingMeshSortUpload
    extends J_L_Record
    implements PendingSectionUpload {
        private final RenderSection section;
        private final TerrainRenderPass pass;
        private final PendingUpload indexUpload;

        PendingMeshSortUpload(RenderSection section, TerrainRenderPass pass, PendingUpload indexUpload) {
            this.section = section;
            this.pass = pass;
            this.indexUpload = indexUpload;
        }

        @Override
        public PendingUpload vertexUpload() {
            return null;
        }

        public final String toString() {
            return PendingMeshSortUpload.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return PendingMeshSortUpload.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return PendingMeshSortUpload.jvmdowngrader$equals$equals(this, o);
        }

        @Override
        public RenderSection section() {
            return this.section;
        }

        @Override
        public TerrainRenderPass pass() {
            return this.pass;
        }

        @Override
        public PendingUpload indexUpload() {
            return this.indexUpload;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(PendingMeshSortUpload pendingMeshSortUpload) {
            PendingMeshSortUpload pendingMeshSortUpload2 = pendingMeshSortUpload;
            return "RenderRegionManager$PendingMeshSortUpload[" + "section=" + pendingMeshSortUpload.section + ", " + "pass=" + pendingMeshSortUpload.pass + ", " + "indexUpload=" + pendingMeshSortUpload.indexUpload + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(PendingMeshSortUpload pendingMeshSortUpload) {
            Object[] objectArray = new Object[]{pendingMeshSortUpload.section, pendingMeshSortUpload.pass, pendingMeshSortUpload.indexUpload};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(PendingMeshSortUpload pendingMeshSortUpload, Object object) {
            if (pendingMeshSortUpload == object) {
                return true;
            }
            if (object != null && object instanceof PendingMeshSortUpload) {
                PendingMeshSortUpload pendingMeshSortUpload2 = (PendingMeshSortUpload)object;
                if (Objects.equals(pendingMeshSortUpload.section, pendingMeshSortUpload2.section) && Objects.equals(pendingMeshSortUpload.pass, pendingMeshSortUpload2.pass) && Objects.equals(pendingMeshSortUpload.indexUpload, pendingMeshSortUpload2.indexUpload)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="section", type=RenderSection.class), @RecordComponents.Value(name="meshData", type=BuiltSectionMeshParts.class), @RecordComponents.Value(name="pass", type=TerrainRenderPass.class), @RecordComponents.Value(name="vertexUpload", type=PendingUpload.class), @RecordComponents.Value(name="indexUpload", type=PendingUpload.class)})
    @NestHost(value=RenderRegionManager.class)
    private static final class PendingMeshRebuildUpload
    extends J_L_Record
    implements PendingSectionUpload {
        private final RenderSection section;
        private final BuiltSectionMeshParts meshData;
        private final TerrainRenderPass pass;
        private final PendingUpload vertexUpload;
        private final PendingUpload indexUpload;

        PendingMeshRebuildUpload(RenderSection section, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload vertexUpload, PendingUpload indexUpload) {
            this.section = section;
            this.meshData = meshData;
            this.pass = pass;
            this.vertexUpload = vertexUpload;
            this.indexUpload = indexUpload;
        }

        public final String toString() {
            return PendingMeshRebuildUpload.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return PendingMeshRebuildUpload.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return PendingMeshRebuildUpload.jvmdowngrader$equals$equals(this, o);
        }

        @Override
        public RenderSection section() {
            return this.section;
        }

        public BuiltSectionMeshParts meshData() {
            return this.meshData;
        }

        @Override
        public TerrainRenderPass pass() {
            return this.pass;
        }

        @Override
        public PendingUpload vertexUpload() {
            return this.vertexUpload;
        }

        @Override
        public PendingUpload indexUpload() {
            return this.indexUpload;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(PendingMeshRebuildUpload pendingMeshRebuildUpload) {
            PendingMeshRebuildUpload pendingMeshRebuildUpload2 = pendingMeshRebuildUpload;
            return "RenderRegionManager$PendingMeshRebuildUpload[" + "section=" + pendingMeshRebuildUpload.section + ", " + "meshData=" + (Object)((Object)pendingMeshRebuildUpload.meshData) + ", " + "pass=" + pendingMeshRebuildUpload.pass + ", " + "vertexUpload=" + pendingMeshRebuildUpload.vertexUpload + ", " + "indexUpload=" + pendingMeshRebuildUpload.indexUpload + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(PendingMeshRebuildUpload pendingMeshRebuildUpload) {
            Object[] objectArray = new Object[]{pendingMeshRebuildUpload.section, pendingMeshRebuildUpload.meshData, pendingMeshRebuildUpload.pass, pendingMeshRebuildUpload.vertexUpload, pendingMeshRebuildUpload.indexUpload};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(PendingMeshRebuildUpload pendingMeshRebuildUpload, Object object) {
            if (pendingMeshRebuildUpload == object) {
                return true;
            }
            if (object != null && object instanceof PendingMeshRebuildUpload) {
                PendingMeshRebuildUpload pendingMeshRebuildUpload2 = (PendingMeshRebuildUpload)object;
                if (Objects.equals(pendingMeshRebuildUpload.section, pendingMeshRebuildUpload2.section) && Objects.equals((Object)pendingMeshRebuildUpload.meshData, (Object)pendingMeshRebuildUpload2.meshData) && Objects.equals(pendingMeshRebuildUpload.pass, pendingMeshRebuildUpload2.pass) && Objects.equals(pendingMeshRebuildUpload.vertexUpload, pendingMeshRebuildUpload2.vertexUpload) && Objects.equals(pendingMeshRebuildUpload.indexUpload, pendingMeshRebuildUpload2.indexUpload)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RenderRegionManager.class)
    private static interface PendingSectionUpload {
        public RenderSection section();

        public TerrainRenderPass pass();

        public PendingUpload vertexUpload();

        public PendingUpload indexUpload();
    }
}

