/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.occlusion;

import org.embeddedt.embeddium.impl.render.chunk.AbstractSection;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.GraphDirectionSet;

public class OcclusionNode
extends AbstractSection {
    private int incomingDirections;
    private int lastVisibleFrame = -1;
    private int adjacentMask;
    public OcclusionNode adjacentDown;
    public OcclusionNode adjacentUp;
    public OcclusionNode adjacentNorth;
    public OcclusionNode adjacentSouth;
    public OcclusionNode adjacentWest;
    public OcclusionNode adjacentEast;
    private long visibilityData = 0L;
    private final RenderSection section;
    private final int renderRegionId;

    public OcclusionNode(RenderSection section) {
        super(section.getChunkX(), section.getChunkY(), section.getChunkZ());
        this.section = section;
        this.renderRegionId = section.getRegion().getId();
    }

    public OcclusionNode getAdjacent(int direction) {
        OcclusionNode occlusionNode;
        switch (direction) {
            case 0: {
                occlusionNode = this.adjacentDown;
                break;
            }
            case 1: {
                occlusionNode = this.adjacentUp;
                break;
            }
            case 2: {
                occlusionNode = this.adjacentNorth;
                break;
            }
            case 3: {
                occlusionNode = this.adjacentSouth;
                break;
            }
            case 4: {
                occlusionNode = this.adjacentWest;
                break;
            }
            case 5: {
                occlusionNode = this.adjacentEast;
                break;
            }
            default: {
                occlusionNode = null;
            }
        }
        return occlusionNode;
    }

    public void setAdjacentNode(int direction, OcclusionNode node) {
        this.adjacentMask = node == null ? (this.adjacentMask &= ~GraphDirectionSet.of(direction)) : (this.adjacentMask |= GraphDirectionSet.of(direction));
        switch (direction) {
            case 0: {
                this.adjacentDown = node;
                break;
            }
            case 1: {
                this.adjacentUp = node;
                break;
            }
            case 2: {
                this.adjacentNorth = node;
                break;
            }
            case 3: {
                this.adjacentSouth = node;
                break;
            }
            case 4: {
                this.adjacentWest = node;
                break;
            }
            case 5: {
                this.adjacentEast = node;
                break;
            }
        }
    }

    public int getAdjacentMask() {
        return this.adjacentMask;
    }

    public void setLastVisibleFrame(int frame) {
        this.lastVisibleFrame = frame;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public int getIncomingDirections() {
        return this.incomingDirections;
    }

    public void addIncomingDirections(int directions) {
        this.incomingDirections |= directions;
    }

    public void setIncomingDirections(int directions) {
        this.incomingDirections = directions;
    }

    public RenderSection getRenderSection() {
        return this.section;
    }

    public long getVisibilityData() {
        return this.visibilityData;
    }

    public void setVisibilityData(long visibilityData) {
        this.visibilityData = visibilityData;
    }

    public int getRenderRegionId() {
        return this.renderRegionId;
    }
}

