/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.occlusion;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.Objects;
import org.embeddedt.embeddium.impl.common.util.MathUtil;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.GraphDirectionSet;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.OcclusionNode;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.VisibilityEncoding;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.embeddedt.embeddium.impl.util.collections.DoubleBufferedQueue;
import org.embeddedt.embeddium.impl.util.collections.ReadQueue;
import org.embeddedt.embeddium.impl.util.collections.WriteQueue;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3ic;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Visitor.class})
public class OcclusionCuller {
    private final Long2ReferenceMap<OcclusionNode> sections;
    private final int minSectionY;
    private final int maxSectionY;
    private final DoubleBufferedQueue<OcclusionNode> queue = new DoubleBufferedQueue();
    private boolean isCameraInUnloadedSection;
    private static final float CHUNK_SECTION_SIZE = 9.125f;

    public OcclusionCuller(Long2ReferenceMap<OcclusionNode> sections, int minSectionY, int maxSectionY) {
        this.sections = sections;
        this.minSectionY = minSectionY;
        this.maxSectionY = maxSectionY;
    }

    public void findVisible(Visitor visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame) {
        DoubleBufferedQueue<OcclusionNode> queues = this.queue;
        queues.reset();
        this.isCameraInUnloadedSection = false;
        this.init(visitor, queues.write(), viewport, searchDistance, useOcclusionCulling, frame);
        if (this.isCameraInUnloadedSection) {
            useOcclusionCulling = false;
        }
        while (queues.flip()) {
            OcclusionCuller.processQueue(visitor, viewport, searchDistance, useOcclusionCulling, frame, queues.read(), queues.write());
        }
    }

    private static void processQueue(Visitor visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame, ReadQueue<OcclusionNode> readQueue, WriteQueue<OcclusionNode> writeQueue) {
        OcclusionNode section;
        while ((section = readQueue.dequeue()) != null) {
            boolean visible = OcclusionCuller.isSectionVisible(section, viewport, searchDistance);
            visitor.visit(section, visible);
            if (!visible) continue;
            int connections = useOcclusionCulling ? VisibilityEncoding.getConnections(section.getVisibilityData(), section.getIncomingDirections()) : 63;
            OcclusionCuller.visitNeighbors(writeQueue, section, connections &= OcclusionCuller.getOutwardDirections(viewport.getChunkCoord(), section), frame);
        }
    }

    private static boolean isSectionVisible(OcclusionNode section, Viewport viewport, float maxDistance) {
        return OcclusionCuller.isWithinRenderDistance(viewport.getTransform(), section, maxDistance) && OcclusionCuller.isWithinFrustum(viewport, section);
    }

    private static void visitNeighbors(WriteQueue<OcclusionNode> queue, OcclusionNode section, int outgoing, int frame) {
        if ((outgoing &= section.getAdjacentMask()) == 0) {
            return;
        }
        queue.ensureCapacity(6);
        if (GraphDirectionSet.contains(outgoing, 0)) {
            OcclusionCuller.visitNode(queue, section.adjacentDown, GraphDirectionSet.of(1), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 1)) {
            OcclusionCuller.visitNode(queue, section.adjacentUp, GraphDirectionSet.of(0), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 2)) {
            OcclusionCuller.visitNode(queue, section.adjacentNorth, GraphDirectionSet.of(3), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 3)) {
            OcclusionCuller.visitNode(queue, section.adjacentSouth, GraphDirectionSet.of(2), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 4)) {
            OcclusionCuller.visitNode(queue, section.adjacentWest, GraphDirectionSet.of(5), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 5)) {
            OcclusionCuller.visitNode(queue, section.adjacentEast, GraphDirectionSet.of(4), frame);
        }
    }

    private static void visitNode(WriteQueue<OcclusionNode> queue, @NotNull OcclusionNode render, int incoming, int frame) {
        if (render.getLastVisibleFrame() != frame) {
            render.setLastVisibleFrame(frame);
            render.setIncomingDirections(0);
            queue.enqueue(render);
        }
        render.addIncomingDirections(incoming);
    }

    private static int getOutwardDirections(Vector3ic origin, OcclusionNode section) {
        int planes = 0;
        planes |= section.getChunkX() <= origin.x() ? 16 : 0;
        planes |= section.getChunkX() >= origin.x() ? 32 : 0;
        planes |= section.getChunkY() <= origin.y() ? 1 : 0;
        planes |= section.getChunkY() >= origin.y() ? 2 : 0;
        planes |= section.getChunkZ() <= origin.z() ? 4 : 0;
        return planes |= section.getChunkZ() >= origin.z() ? 8 : 0;
    }

    private static boolean isWithinRenderDistance(CameraTransform camera, OcclusionNode section, float maxDistance) {
        int ox = section.getOriginX() - camera.intX;
        int oy = section.getOriginY() - camera.intY;
        int oz = section.getOriginZ() - camera.intZ;
        float dx = (float)OcclusionCuller.nearestToZero(ox, ox + 16) - camera.fracX;
        float dy = (float)OcclusionCuller.nearestToZero(oy, oy + 16) - camera.fracY;
        float dz = (float)OcclusionCuller.nearestToZero(oz, oz + 16) - camera.fracZ;
        return dx * dx + dz * dz < maxDistance * maxDistance && Math.abs(dy) < maxDistance;
    }

    private static int nearestToZero(int min, int max) {
        int clamped = 0;
        if (min > 0) {
            clamped = min;
        }
        if (max < 0) {
            clamped = max;
        }
        return clamped;
    }

    public static boolean isWithinFrustum(Viewport viewport, OcclusionNode section) {
        return viewport.isBoxVisible(section.getCenterX(), section.getCenterY(), section.getCenterZ(), 9.125f);
    }

    private void init(Visitor visitor, WriteQueue<OcclusionNode> queue, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame) {
        Vector3ic origin = viewport.getChunkCoord();
        if (origin.y() < this.minSectionY) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, this.minSectionY, GraphDirectionSet.of(0));
        } else if (origin.y() >= this.maxSectionY) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, this.maxSectionY - 1, GraphDirectionSet.of(1));
        } else if (this.getRenderSection(origin.x(), origin.y(), origin.z()) == null) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, origin.y(), GraphDirectionSet.of(1) | GraphDirectionSet.of(0));
            this.isCameraInUnloadedSection = true;
        } else {
            this.initWithinWorld(visitor, queue, viewport, useOcclusionCulling, frame);
        }
    }

    private void initWithinWorld(Visitor visitor, WriteQueue<OcclusionNode> queue, Viewport viewport, boolean useOcclusionCulling, int frame) {
        Vector3ic origin = viewport.getChunkCoord();
        OcclusionNode section = this.getRenderSection(origin.x(), origin.y(), origin.z());
        Objects.requireNonNull(section);
        section.setLastVisibleFrame(frame);
        section.setIncomingDirections(0);
        visitor.visit(section, true);
        int outgoing = useOcclusionCulling ? VisibilityEncoding.getConnections(section.getVisibilityData()) : 63;
        OcclusionCuller.visitNeighbors(queue, section, outgoing, frame);
    }

    private void initOutsideWorldHeight(WriteQueue<OcclusionNode> queue, Viewport viewport, float searchDistance, int frame, int height, int direction) {
        int layer;
        Vector3ic origin = viewport.getChunkCoord();
        int radius = MathUtil.mojfloor(searchDistance / 16.0f);
        this.tryVisitNode(queue, origin.x(), height, origin.z(), direction, frame, viewport);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                this.tryVisitNode(queue, origin.x() + x, height, origin.z() + z, direction, frame, viewport);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                this.tryVisitNode(queue, origin.x() + x, height, origin.z() + z, direction, frame, viewport);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                this.tryVisitNode(queue, origin.x() + x, height, origin.z() + z, direction, frame, viewport);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                this.tryVisitNode(queue, origin.x() + x, height, origin.z() + z, direction, frame, viewport);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                this.tryVisitNode(queue, origin.x() + x, height, origin.z() + z, direction, frame, viewport);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                this.tryVisitNode(queue, origin.x() + x, height, origin.z() + z, direction, frame, viewport);
            }
        }
    }

    private void tryVisitNode(WriteQueue<OcclusionNode> queue, int x, int y, int z, int direction, int frame, Viewport viewport) {
        OcclusionNode section = this.getRenderSection(x, y, z);
        if (section == null || !OcclusionCuller.isWithinFrustum(viewport, section)) {
            return;
        }
        OcclusionCuller.visitNode(queue, section, direction, frame);
    }

    private OcclusionNode getRenderSection(int x, int y, int z) {
        return (OcclusionNode)this.sections.get(PositionUtil.packSection(x, y, z));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=OcclusionCuller.class)
    public static interface Visitor {
        public void visit(OcclusionNode var1, boolean var2);
    }
}

