/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.multidraw;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.util.Arrays;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.DrawCommandList;
import org.embeddedt.embeddium.impl.gl.device.MultiDrawBatch;
import org.embeddedt.embeddium.impl.gl.tessellation.GlIndexType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataUnsafe;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.MultiDrawEmitter;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RecordComponents(value={@RecordComponents.Value(name="batch", type=MultiDrawBatch.class)})
public final class DirectMultiDrawEmitter
extends J_L_Record
implements MultiDrawEmitter {
    private final MultiDrawBatch batch;

    public DirectMultiDrawEmitter() {
        this(new MultiDrawBatch(MAX_COMMAND_COUNT));
    }

    public DirectMultiDrawEmitter(MultiDrawBatch batch) {
        this.batch = batch;
    }

    @Override
    public void addDrawCommands(long pMeshData, int mask, int indexPointerMask) {
        MultiDrawBatch batch = this.batch;
        long pBaseVertex = batch.pBaseVertex;
        long pElementCount = batch.pElementCount;
        long pElementPointer = batch.pElementPointer;
        int size = batch.size;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            LWJGLServiceProvider.LWJGL.memPutInt(pBaseVertex + (long)(size << 2), SectionRenderDataUnsafe.getVertexOffset(pMeshData, facing));
            LWJGLServiceProvider.LWJGL.memPutInt(pElementCount + (long)(size << 2), SectionRenderDataUnsafe.getElementCount(pMeshData, facing));
            LWJGLServiceProvider.LWJGL.memPutAddress(pElementPointer + (long)(size << 3), SectionRenderDataUnsafe.getIndexOffset(pMeshData, facing) & indexPointerMask);
            size += mask >> facing & 1;
        }
        batch.size = size;
    }

    @Override
    public void executeBatch(CommandList commandList, GlTessellation tessellation, GlPrimitiveType primitiveType) {
        try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
            drawCommandList.multiDrawElementsBaseVertex(this.batch, primitiveType, GlIndexType.UNSIGNED_INT);
        }
    }

    @Override
    public int getIndexBufferSize() {
        return this.batch.getIndexBufferSize();
    }

    @Override
    public boolean isEmpty() {
        return this.batch.isEmpty();
    }

    @Override
    public void clear() {
        this.batch.clear();
    }

    @Override
    public void delete() {
        this.batch.delete();
    }

    public final String toString() {
        return DirectMultiDrawEmitter.jvmdowngrader$toString$toString(this);
    }

    public final int hashCode() {
        return DirectMultiDrawEmitter.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return DirectMultiDrawEmitter.jvmdowngrader$equals$equals(this, o);
    }

    public MultiDrawBatch batch() {
        return this.batch;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(DirectMultiDrawEmitter directMultiDrawEmitter) {
        DirectMultiDrawEmitter directMultiDrawEmitter2 = directMultiDrawEmitter;
        return "DirectMultiDrawEmitter[" + "batch=" + directMultiDrawEmitter.batch + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(DirectMultiDrawEmitter directMultiDrawEmitter) {
        Object[] objectArray = new Object[]{directMultiDrawEmitter.batch};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(DirectMultiDrawEmitter directMultiDrawEmitter, Object object) {
        if (directMultiDrawEmitter == object) {
            return true;
        }
        if (object != null && object instanceof DirectMultiDrawEmitter) {
            DirectMultiDrawEmitter directMultiDrawEmitter2 = (DirectMultiDrawEmitter)object;
            if (Objects.equals(directMultiDrawEmitter.batch, directMultiDrawEmitter2.batch)) {
                return true;
            }
        }
        return false;
    }
}

