/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.lists;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataStorage;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataUnsafe;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRebuildLists;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SectionTicker;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.lists.VisibleChunkCollector;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.GraphDirection;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.OcclusionCuller;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.OcclusionNode;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={RenderListDebugStatistics.class})
public class RenderListManager {
    @NotNull
    private SortedRenderLists renderLists;
    @NotNull
    private ChunkRebuildLists rebuildLists;
    private final OcclusionCuller occlusionCuller;
    private final Long2ReferenceMap<OcclusionNode> occlusionNodes = new Long2ReferenceOpenHashMap();
    private CompletableFuture<VisibleChunkCollector> currentOcclusionFuture;
    private boolean needsUpdate = true;
    private int lastUpdatedFrame;
    private int pendingLastUpdatedFrame;
    private final ArrayDeque<Runnable> updateTasks = new ArrayDeque();
    private final ExecutorService asyncGraphExecutor;
    @Nullable
    private final SectionTicker sectionTicker;
    private RenderListDebugStatistics debugStatistics;

    public RenderListManager(int minSectionY, int maxSectionY, boolean useAsyncGraphSearch, @Nullable SectionTicker sectionTicker) {
        this.sectionTicker = sectionTicker;
        this.asyncGraphExecutor = useAsyncGraphSearch ? Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("Celeritas chunk graph search thread");
            thread.setDaemon(true);
            return thread;
        }) : null;
        this.occlusionCuller = new OcclusionCuller(this.occlusionNodes, minSectionY, maxSectionY);
        this.renderLists = SortedRenderLists.empty();
        this.rebuildLists = ChunkRebuildLists.EMPTY;
    }

    public void startGraphUpdate(Viewport viewport, int frame, int regionIdsLength, float searchDistance, boolean useOcclusionCulling, boolean allowInfiniteUpdateTasks) {
        if (this.currentOcclusionFuture != null) {
            throw new IllegalStateException("Occlusion work in progress while trying to submit next task");
        }
        VisibleChunkCollector visitor = new VisibleChunkCollector(frame, regionIdsLength, allowInfiniteUpdateTasks);
        Supplier<VisibleChunkCollector> occlusionTask = () -> {
            this.occlusionCuller.findVisible(visitor, viewport, searchDistance, useOcclusionCulling, frame);
            if (this.sectionTicker != null) {
                this.sectionTicker.onRenderListUpdated((List<ChunkRenderList>)visitor.getSortedRenderLists());
            }
            return visitor;
        };
        this.pendingLastUpdatedFrame = frame;
        if (this.asyncGraphExecutor != null) {
            this.currentOcclusionFuture = CompletableFuture.supplyAsync(occlusionTask, this.asyncGraphExecutor);
        } else {
            this.currentOcclusionFuture = CompletableFuture.completedFuture(occlusionTask.get());
            this.finishPreviousGraphUpdate();
        }
        this.needsUpdate = false;
    }

    public void finishPreviousGraphUpdate() {
        Runnable task;
        if (this.currentOcclusionFuture != null) {
            VisibleChunkCollector visitor = this.currentOcclusionFuture.join();
            this.renderLists = visitor.createRenderLists();
            this.rebuildLists = visitor.getRebuildLists();
            this.currentOcclusionFuture = null;
            this.lastUpdatedFrame = this.pendingLastUpdatedFrame;
            this.debugStatistics = null;
        }
        while ((task = this.updateTasks.poll()) != null) {
            task.run();
        }
    }

    public void destroy() {
        if (this.currentOcclusionFuture != null) {
            this.currentOcclusionFuture.join();
            this.currentOcclusionFuture = null;
        }
        if (this.asyncGraphExecutor != null) {
            this.asyncGraphExecutor.shutdown();
            try {
                if (!this.asyncGraphExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Async graph executor has somehow not shut down");
            }
        }
    }

    private OcclusionNode getOcclusionNode(int x, int y, int z) {
        return (OcclusionNode)this.occlusionNodes.get(PositionUtil.packSection(x, y, z));
    }

    private void connectNeighborNodes(OcclusionNode render) {
        for (int direction = 0; direction < 6; ++direction) {
            OcclusionNode adj = this.getOcclusionNode(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(OcclusionNode render) {
        for (int direction = 0; direction < 6; ++direction) {
            OcclusionNode adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private void assertOcclusionNotRunning() {
        if (this.currentOcclusionFuture != null) {
            throw new IllegalStateException("Attempted to update occlusion graph during occlusion!");
        }
    }

    public void attachRenderSection(RenderSection section) {
        this.assertOcclusionNotRunning();
        long key = section.positionAsLong();
        OcclusionNode occlusionNode = (OcclusionNode)this.occlusionNodes.get(key);
        if (occlusionNode != null) {
            throw new IllegalStateException(RenderListManager.jvmdowngrader$concat$attachRenderSection$1(String.valueOf(section)));
        }
        OcclusionNode node = new OcclusionNode(section);
        this.occlusionNodes.put(key, (Object)node);
        this.connectNeighborNodes(node);
        this.needsUpdate = true;
    }

    public void detachRenderSection(RenderSection section) {
        this.assertOcclusionNotRunning();
        long key = section.positionAsLong();
        OcclusionNode occlusionNode = (OcclusionNode)this.occlusionNodes.remove(key);
        if (occlusionNode == null) {
            throw new IllegalStateException(RenderListManager.jvmdowngrader$concat$detachRenderSection$1(String.valueOf(section)));
        }
        this.disconnectNeighborNodes(occlusionNode);
        this.needsUpdate = true;
    }

    private void submitUpdateTask(Runnable runnable) {
        if (this.currentOcclusionFuture == null) {
            runnable.run();
        } else {
            this.updateTasks.add(runnable);
        }
    }

    public void updateVisibilityData(int x, int y, int z, long visibilityData) {
        this.submitUpdateTask(() -> {
            OcclusionNode node = this.getOcclusionNode(x, y, z);
            if (node != null) {
                node.setVisibilityData(visibilityData);
                this.needsUpdate = true;
            }
        });
    }

    public boolean isSectionVisible(int x, int y, int z) {
        OcclusionNode render = this.getOcclusionNode(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() >= this.lastUpdatedFrame;
    }

    public void tickVisibleRenders() {
        if (this.sectionTicker != null) {
            this.sectionTicker.tickVisibleRenders();
        }
    }

    public RenderListDebugStatistics getDebugStatistics() {
        if (this.debugStatistics == null) {
            this.debugStatistics = this.computeDebugStatistics();
        }
        return this.debugStatistics;
    }

    public String getTickerDebugString() {
        if (this.sectionTicker == null) {
            return "";
        }
        return this.sectionTicker.getDebugString();
    }

    private RenderListDebugStatistics computeDebugStatistics() {
        Object2IntOpenHashMap renderPassCounts = new Object2IntOpenHashMap();
        Iterator<ChunkRenderList> iterator = this.renderLists.iterator();
        int[] sectionCounts = new int[TranslucentQuadAnalyzer.Level.VALUES.length];
        boolean isSorting = this.renderLists.getPasses().stream().anyMatch(TerrainRenderPass::isSorted);
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            if (renderList.getSectionsWithGeometryCount() == 0) continue;
            RenderRegion region = renderList.getRegion();
            for (TerrainRenderPass pass : region.getPasses()) {
                int numToAdd = 0;
                SectionRenderDataStorage storage = region.getStorage(pass);
                ByteIterator iter = Objects.requireNonNull(renderList.sectionsWithGeometryIterator(false));
                while (iter.hasNext()) {
                    int sectionIndex = iter.nextByteAsInt();
                    long pMeshData = storage.getDataPointer(sectionIndex);
                    if (SectionRenderDataUnsafe.getSliceMask(pMeshData) == 0) continue;
                    ++numToAdd;
                }
                if (numToAdd <= 0) continue;
                renderPassCounts.addTo((Object)pass, numToAdd);
            }
            if (!isSorting) continue;
            ByteIterator iter = Objects.requireNonNull(renderList.sectionsWithGeometryIterator(false));
            while (iter.hasNext()) {
                int sectionIndex = iter.nextByteAsInt();
                RenderSection section = region.getSection(sectionIndex);
                if (section == null || section.getTranslucencySortStates().isEmpty()) continue;
                int n = section.getHighestSortingLevel().ordinal();
                sectionCounts[n] = sectionCounts[n] + 1;
            }
        }
        return new RenderListDebugStatistics((Object2IntOpenHashMap<TerrainRenderPass>)renderPassCounts, sectionCounts);
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    @NotNull
    public ChunkRebuildLists getRebuildLists() {
        return this.rebuildLists;
    }

    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    public int getLastUpdatedFrame() {
        return this.lastUpdatedFrame;
    }

    private static /* synthetic */ String jvmdowngrader$concat$attachRenderSection$1(String string) {
        return "Occlusion node already exists for section " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$detachRenderSection$1(String string) {
        return "Occlusion node does not exist for section " + string;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="renderPassCounts", type=Object2IntOpenHashMap.class), @RecordComponents.Value(name="sortingSectionCounts", type=int[].class)})
    @NestHost(value=RenderListManager.class)
    public static final class RenderListDebugStatistics
    extends J_L_Record {
        private final Object2IntOpenHashMap<TerrainRenderPass> renderPassCounts;
        private final int[] sortingSectionCounts;

        public RenderListDebugStatistics(Object2IntOpenHashMap<TerrainRenderPass> renderPassCounts, int[] sortingSectionCounts) {
            this.renderPassCounts = renderPassCounts;
            this.sortingSectionCounts = sortingSectionCounts;
        }

        public String getSortingString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Sorting: ");
            TranslucentQuadAnalyzer.Level[] values = TranslucentQuadAnalyzer.Level.VALUES;
            for (int i = 0; i < values.length; ++i) {
                TranslucentQuadAnalyzer.Level level = values[i];
                sb.append(level.name());
                sb.append('=');
                sb.append(this.sortingSectionCounts[level.ordinal()]);
                if (i + 1 >= values.length) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public final String toString() {
            return RenderListDebugStatistics.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return RenderListDebugStatistics.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return RenderListDebugStatistics.jvmdowngrader$equals$equals(this, o);
        }

        public Object2IntOpenHashMap<TerrainRenderPass> renderPassCounts() {
            return this.renderPassCounts;
        }

        public int[] sortingSectionCounts() {
            return this.sortingSectionCounts;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(RenderListDebugStatistics renderListDebugStatistics) {
            RenderListDebugStatistics renderListDebugStatistics2 = renderListDebugStatistics;
            return "RenderListManager$RenderListDebugStatistics[" + "renderPassCounts=" + renderListDebugStatistics.renderPassCounts + ", " + "sortingSectionCounts=" + renderListDebugStatistics.sortingSectionCounts + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(RenderListDebugStatistics renderListDebugStatistics) {
            Object[] objectArray = new Object[]{renderListDebugStatistics.renderPassCounts, renderListDebugStatistics.sortingSectionCounts};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(RenderListDebugStatistics renderListDebugStatistics, Object object) {
            if (renderListDebugStatistics == object) {
                return true;
            }
            if (object != null && object instanceof RenderListDebugStatistics) {
                RenderListDebugStatistics renderListDebugStatistics2 = (RenderListDebugStatistics)((Object)object);
                if (Objects.equals(renderListDebugStatistics.renderPassCounts, renderListDebugStatistics2.renderPassCounts) && Objects.equals(renderListDebugStatistics.sortingSectionCounts, renderListDebugStatistics2.sortingSectionCounts)) {
                    return true;
                }
            }
            return false;
        }
    }
}

