/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.data;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.embeddedt.embeddium.impl.util.iterator.ConcatenatedIterator;
import xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MinecraftBuiltRenderSectionData<SPRITE, BLOCKENTITY>
extends BuiltRenderSectionData {
    public Collection<SPRITE> animatedSprites = new ObjectOpenHashSet();
    public List<BLOCKENTITY> culledBlockEntities = new ArrayList<BLOCKENTITY>();
    public List<BLOCKENTITY> globalBlockEntities = new ArrayList<BLOCKENTITY>();

    @Override
    public void bake() {
        super.bake();
        this.animatedSprites = J_U_List.copyOf(this.animatedSprites);
        this.culledBlockEntities = J_U_List.copyOf(this.culledBlockEntities);
        this.globalBlockEntities = J_U_List.copyOf(this.globalBlockEntities);
    }

    @Override
    public int getVisualBitmaskForSection() {
        int flags = super.getVisualBitmaskForSection();
        if (!this.animatedSprites.isEmpty()) {
            flags |= 2;
        }
        if (!this.culledBlockEntities.isEmpty() || !this.globalBlockEntities.isEmpty()) {
            flags |= 4;
        }
        return flags;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MinecraftBuiltRenderSectionData that = (MinecraftBuiltRenderSectionData)o;
        return Objects.equals(this.animatedSprites, that.animatedSprites) && Objects.equals(this.culledBlockEntities, that.culledBlockEntities) && Objects.equals(this.globalBlockEntities, that.globalBlockEntities);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.animatedSprites, this.culledBlockEntities, this.globalBlockEntities);
    }

    public static <BLOCKENTITY> Iterator<BLOCKENTITY> generateBlockEntityIterator(SortedRenderLists renderLists, Collection<RenderSection> globalSections) {
        ArrayList<Iterator<BLOCKENTITY>> iterators = new ArrayList<Iterator<BLOCKENTITY>>();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                BuiltRenderSectionData context;
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                if (renderSection == null || !((context = renderSection.getBuiltContext()) instanceof MinecraftBuiltRenderSectionData)) continue;
                MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
                iterators.add(mcData.culledBlockEntities.iterator());
            }
        }
        for (RenderSection renderSection : globalSections) {
            BuiltRenderSectionData context = renderSection.getBuiltContext();
            if (!(context instanceof MinecraftBuiltRenderSectionData)) continue;
            MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
            iterators.add(mcData.globalBlockEntities.iterator());
        }
        if (iterators.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new ConcatenatedIterator(iterators.iterator());
    }

    public static <BLOCKENTITY> void forEachBlockEntity(Consumer<BLOCKENTITY> consumer, SortedRenderLists renderLists, Collection<RenderSection> globalSections) {
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                BuiltRenderSectionData context;
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                if (renderSection == null || !((context = renderSection.getBuiltContext()) instanceof MinecraftBuiltRenderSectionData)) continue;
                MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
                mcData.culledBlockEntities.forEach(consumer);
            }
        }
        for (RenderSection renderSection : globalSections) {
            BuiltRenderSectionData context = renderSection.getBuiltContext();
            if (!(context instanceof MinecraftBuiltRenderSectionData)) continue;
            MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
            mcData.globalBlockEntities.forEach(consumer);
        }
    }
}

