/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.sorting;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.util.sorting.MergeSort;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class QuadPrimitiveType
implements ChunkPrimitiveType {
    public static final QuadPrimitiveType TRIANGULATED = new QuadPrimitiveType(true);
    public static final QuadPrimitiveType DIRECT = new QuadPrimitiveType(false);
    private final boolean triangulating;
    private static final int VERTICES_PER_PRIMITIVE = 4;
    private static final int FAKE_STATIC_CAMERA_OFFSET = 1000;

    public QuadPrimitiveType(boolean triangulating) {
        this.triangulating = triangulating;
    }

    @Override
    public int getIndexBufferElementsPerPrimitive() {
        return this.triangulating ? 6 : 4;
    }

    @Override
    public int getVerticesPerPrimitive() {
        return 4;
    }

    @Override
    public void generateSimpleIndexBuffer(ByteBuffer indexBuffer, int numPrimitives) {
        int minimumRequiredBufferSize = this.getIndexBufferSize(numPrimitives);
        if (indexBuffer.capacity() < minimumRequiredBufferSize) {
            throw new IllegalStateException(QuadPrimitiveType.jvmdowngrader$concat$generateSimpleIndexBuffer$1(indexBuffer.capacity(), minimumRequiredBufferSize));
        }
        long ptr = LWJGLServiceProvider.LWJGL.memAddress(indexBuffer);
        int elementsPerPrimitive = this.getIndexBufferElementsPerPrimitive();
        boolean triangulating = this.triangulating;
        for (int primitiveIndex = 0; primitiveIndex < numPrimitives; ++primitiveIndex) {
            int indexOffset = primitiveIndex * elementsPerPrimitive;
            int vertexOffset = primitiveIndex * 4;
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 0) * 4), vertexOffset + 0);
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 1) * 4), vertexOffset + 1);
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 2) * 4), vertexOffset + 2);
            if (triangulating) {
                LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 3) * 4), vertexOffset + 2);
                LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 4) * 4), vertexOffset + 3);
                LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 5) * 4), vertexOffset + 0);
                continue;
            }
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 3) * 4), vertexOffset + 3);
        }
    }

    private void generateIndexBuffer(ByteBuffer indexBuffer, int[] primitiveMapping) {
        int bufferSize = this.getIndexBufferSize(primitiveMapping.length);
        if (indexBuffer.capacity() != bufferSize) {
            throw new IllegalStateException(QuadPrimitiveType.jvmdowngrader$concat$generateIndexBuffer$1(indexBuffer.capacity(), bufferSize));
        }
        long ptr = LWJGLServiceProvider.LWJGL.memAddress(indexBuffer);
        int elementsPerPrimitive = this.getIndexBufferElementsPerPrimitive();
        boolean triangulating = this.triangulating;
        for (int primitiveIndex = 0; primitiveIndex < primitiveMapping.length; ++primitiveIndex) {
            int indexOffset = primitiveIndex * elementsPerPrimitive;
            int vertexOffset = primitiveMapping[primitiveIndex] * 4;
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 0) * 4), vertexOffset + 0);
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 1) * 4), vertexOffset + 1);
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 2) * 4), vertexOffset + 2);
            if (triangulating) {
                LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 3) * 4), vertexOffset + 2);
                LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 4) * 4), vertexOffset + 3);
                LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 5) * 4), vertexOffset + 0);
                continue;
            }
            LWJGLServiceProvider.LWJGL.memPutInt(ptr + (long)((indexOffset + 3) * 4), vertexOffset + 3);
        }
    }

    private static void buildStaticDistanceArray(float[] centers, float[] distanceArray, float x, float y, float z, float normX, float normY, float normZ, int quadCount, BitSet normalSigns) {
        for (int quadIdx = 0; quadIdx < quadCount; ++quadIdx) {
            int centerIdx = quadIdx * 3;
            float qX = centers[centerIdx + 0] - x;
            float qY = centers[centerIdx + 1] - y;
            float qZ = centers[centerIdx + 2] - z;
            distanceArray[quadIdx] = (normX * qX + normY * qY + normZ * qZ) * (float)(normalSigns.get(quadIdx) ? 1 : -1);
        }
    }

    private static void buildDynamicDistanceArray(float[] centers, float[] distanceArray, int quadCount, float x, float y, float z) {
        for (int quadIdx = 0; quadIdx < quadCount; ++quadIdx) {
            int centerIdx = quadIdx * 3;
            float qX = centers[centerIdx + 0] - x;
            float qY = centers[centerIdx + 1] - y;
            float qZ = centers[centerIdx + 2] - z;
            distanceArray[quadIdx] = qX * qX + qY * qY + qZ * qZ;
        }
    }

    @Override
    public void generateSortedIndexBuffer(ByteBuffer indexBuffer, int quadCount, @Nullable TranslucentQuadAnalyzer.SortState chunkData, float x, float y, float z) {
        if (chunkData == null || chunkData.level() == TranslucentQuadAnalyzer.Level.NONE || chunkData.centersLength() < 3) {
            this.generateSimpleIndexBuffer(indexBuffer, quadCount);
            return;
        }
        if (quadCount != chunkData.centersLength() / 3) {
            throw new IllegalStateException(String.format("Mismatched SortState (%d) vs given quad count (%d)", chunkData.centersLength() / 3, quadCount));
        }
        float[] centers = chunkData.centers();
        int[] indicesArray = new int[quadCount];
        float[] distanceArray = new float[quadCount];
        boolean isStatic = chunkData.level() == TranslucentQuadAnalyzer.Level.STATIC;
        for (int quadIdx = 0; quadIdx < quadCount; ++quadIdx) {
            indicesArray[quadIdx] = quadIdx;
        }
        if (isStatic) {
            QuadPrimitiveType.buildStaticDistanceArray(centers, distanceArray, centers[0] + chunkData.sharedNormal().x * 1000.0f, centers[1] + chunkData.sharedNormal().y * 1000.0f, centers[2] + chunkData.sharedNormal().z * 1000.0f, chunkData.sharedNormal().x, chunkData.sharedNormal().y, chunkData.sharedNormal().z, quadCount, chunkData.normalSigns());
        } else {
            QuadPrimitiveType.buildDynamicDistanceArray(centers, distanceArray, quadCount, x, y, z);
        }
        MergeSort.mergeSort(indicesArray, distanceArray);
        this.generateIndexBuffer(indexBuffer, indicesArray);
    }

    private static /* synthetic */ String jvmdowngrader$concat$generateSimpleIndexBuffer$1(int n, int n2) {
        return "Given index buffer has length " + n + " but we need " + n2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$generateIndexBuffer$1(int n, int n2) {
        return "Given index buffer has length " + n + " but we expected " + n2;
    }
}

