/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.executor;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkTaskOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={MetricsData.class, MetricStats.class})
public class ChunkJobMetricsTracker {
    public static final long OBSERVATION_COUNT_TIME = TimeUnit.SECONDS.toNanos(1L);
    private final Reference2ReferenceMap<Class<? extends ChunkTaskOutput>, MetricsData> metricsByTask = new Reference2ReferenceArrayMap(2);
    private long lastTimeIntervalFlip = System.nanoTime();

    public void tick() {
        long time = System.nanoTime();
        if (time - this.lastTimeIntervalFlip >= OBSERVATION_COUNT_TIME) {
            for (MetricsData data : this.metricsByTask.values()) {
                data.jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$set$observationsInLastTimeInterval(data.jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$get$observationsInCurrentTimeInterval());
                data.jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$set$observationsInCurrentTimeInterval(0);
            }
            this.lastTimeIntervalFlip = time;
        }
    }

    public void collectMetrics(ChunkJobResult.Success<? extends ChunkTaskOutput> successfulResult) {
        if (successfulResult.executionTimeNanos() < 0L) {
            return;
        }
        MetricsData data = (MetricsData)this.metricsByTask.computeIfAbsent(successfulResult.output().getClass(), $ -> new MetricsData());
        data.collect(successfulResult.executionTimeNanos());
    }

    public Reference2ReferenceMap<Class<? extends ChunkTaskOutput>, MetricsData> getMetrics() {
        return Reference2ReferenceMaps.unmodifiable(this.metricsByTask);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ChunkJobMetricsTracker.class)
    public static class MetricsData {
        private static final int MAX_OBSERVATIONS = 10000;
        private final LongArrayList observations = new LongArrayList(10000);
        private int nextInsertPoint = 0;
        private int observationsInLastTimeInterval;
        private int observationsInCurrentTimeInterval;

        public void collect(long observation) {
            if (this.observations.size() < 10000) {
                this.observations.add(observation);
            } else {
                this.observations.set(this.nextInsertPoint++, observation);
                if (this.nextInsertPoint >= 10000) {
                    this.nextInsertPoint = 0;
                }
            }
            ++this.observationsInCurrentTimeInterval;
        }

        public int getObservationsInLastTimeInterval() {
            return this.observationsInLastTimeInterval;
        }

        public MetricStats getStats() {
            int count = this.observations.size();
            if (count == 0) {
                return new MetricStats(0L, 0L, 0L);
            }
            LongListIterator iter = this.observations.iterator();
            long sum = 0L;
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            while (iter.hasNext()) {
                long observation = (Long)iter.next();
                sum += observation;
                min = Math.min(min, observation);
                max = Math.max(max, observation);
            }
            return new MetricStats(sum / (long)count, max, min);
        }

        public /* synthetic */ int jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$get$observationsInCurrentTimeInterval() {
            return this.observationsInCurrentTimeInterval;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$set$observationsInCurrentTimeInterval(int n) {
            this.observationsInCurrentTimeInterval = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$get$observationsInLastTimeInterval() {
            return this.observationsInLastTimeInterval;
        }

        public /* synthetic */ void jvmdowngrader$nest$org_embeddedt_embeddium_impl_render_chunk_compile_executor_ChunkJobMetricsTracker$MetricsData$set$observationsInLastTimeInterval(int n) {
            this.observationsInLastTimeInterval = n;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="avg", type=long.class), @RecordComponents.Value(name="max", type=long.class), @RecordComponents.Value(name="min", type=long.class)})
    @NestHost(value=ChunkJobMetricsTracker.class)
    public static final class MetricStats
    extends J_L_Record {
        private final long avg;
        private final long max;
        private final long min;

        public MetricStats(long avg, long max, long min) {
            this.avg = avg;
            this.max = max;
            this.min = min;
        }

        public String toString(LongFunction<String> observationStringifier) {
            return MetricStats.jvmdowngrader$concat$toString$1(observationStringifier.apply(this.avg), observationStringifier.apply(this.max), observationStringifier.apply(this.min));
        }

        @NotNull
        public String toString() {
            return this.toString(String::valueOf);
        }

        public final int hashCode() {
            return MetricStats.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return MetricStats.jvmdowngrader$equals$equals(this, o);
        }

        public long avg() {
            return this.avg;
        }

        public long max() {
            return this.max;
        }

        public long min() {
            return this.min;
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(MetricStats metricStats) {
            Object[] objectArray = new Object[]{metricStats.avg, metricStats.max, metricStats.min};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(MetricStats metricStats, Object object) {
            if (metricStats == object) {
                return true;
            }
            if (object != null && object instanceof MetricStats) {
                MetricStats metricStats2 = (MetricStats)((Object)object);
                if (metricStats.avg == metricStats2.avg && metricStats.max == metricStats2.max && metricStats.min == metricStats2.min) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3) {
            return "avg = " + string + ", max = " + string2 + ", min = " + string3;
        }
    }
}

