/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.embeddedt.embeddium.impl.common.util.MathUtil;
import org.embeddedt.embeddium.impl.common.util.TimeUtil;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferArena;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.profiling.TimerQueryManager;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.ChunkUpdateType;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkTaskOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobCollector;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobMetricsTracker;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobTyped;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderSortTask;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRebuildLists;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.RenderListManager;
import org.embeddedt.embeddium.impl.render.chunk.lists.SectionTicker;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.metrics.RenderSectionMetricsTracker;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.AsyncOcclusionMode;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegionManager;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderFogComponent;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.embeddedt.embeddium.impl.util.suppliers.ExpiringSupplier;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3ic;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class RenderSectionManager {
    protected static final boolean CONTINUOUSLY_REMESH_WORLD = false;
    private final ChunkBuilder builder;
    private final Thread renderThread = Thread.currentThread();
    private final RenderRegionManager regions;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final ConcurrentLinkedDeque<ChunkJobResult<? extends ChunkTaskOutput>> buildResults = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<Runnable> asyncSubmittedTasks = new ConcurrentLinkedDeque();
    private final ChunkRenderer chunkRenderer;
    private final int renderDistance;
    @Nullable
    protected Vector3ic lastCameraPosition;
    protected Vector3d cameraPosition = new Vector3d();
    private final RenderPassConfiguration<?> renderPassConfiguration;
    private final Set<TerrainRenderPass> disabledRenderPasses;
    private final int minSection;
    private final int maxSection;
    protected final RenderListManager renderListManager;
    @Nullable
    protected final RenderListManager shadowRenderListManager;
    protected final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private final Object2ObjectOpenHashMap<TerrainRenderPass, TimerQueryManager> renderPassDrawTimers = new Object2ObjectOpenHashMap();
    protected final ReferenceSet<RenderSection> sectionsRequestingUpdate = new ReferenceOpenHashSet();
    protected final ChunkJobMetricsTracker jobMetricsTracker = new ChunkJobMetricsTracker();
    protected final RenderSectionMetricsTracker sectionMetricsTracker = new RenderSectionMetricsTracker();
    private static final float NEARBY_REBUILD_DISTANCE = MathUtil.square(16.0f);
    protected final Supplier<Object2LongMap<TerrainRenderPass>> renderPassTimingsDebounced = new ExpiringSupplier<Object2LongMap>(this::computeRenderPassTimingsMap, 1L, TimeUnit.SECONDS);

    @Deprecated
    public RenderSectionManager(RenderPassConfiguration<?> configuration, Supplier<ChunkBuildContext> contextSupplier, BiFunction<RenderDevice, RenderPassConfiguration<?>, ChunkRenderer> chunkRenderer, int renderDistance, CommandList commandList, int minSection, int maxSection, int requestedThreads) {
        this(configuration, contextSupplier, chunkRenderer, renderDistance, commandList, minSection, maxSection, requestedThreads, false);
    }

    public RenderSectionManager(RenderPassConfiguration<?> configuration, Supplier<ChunkBuildContext> contextSupplier, BiFunction<RenderDevice, RenderPassConfiguration<?>, ChunkRenderer> chunkRenderer, int renderDistance, CommandList commandList, int minSection, int maxSection, int requestedThreads, boolean hasShadowPass) {
        this.chunkRenderer = chunkRenderer.apply(RenderDevice.INSTANCE, configuration);
        this.renderPassConfiguration = configuration;
        this.builder = new ChunkBuilder(this::managedBlock, contextSupplier, requestedThreads);
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(commandList, this.renderPassConfiguration);
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.renderListManager = new RenderListManager(this.minSection, this.maxSection, this.getAsyncOcclusionMode() == AsyncOcclusionMode.EVERYTHING, this.createSectionTicker());
        this.shadowRenderListManager = hasShadowPass ? new RenderListManager(this.minSection, this.maxSection, this.getAsyncOcclusionMode() != AsyncOcclusionMode.NONE, this.createSectionTicker()) : null;
        this.disabledRenderPasses = new ReferenceArraySet();
    }

    protected abstract AsyncOcclusionMode getAsyncOcclusionMode();

    @Nullable
    protected SectionTicker createSectionTicker() {
        return null;
    }

    public void managedBlock(BooleanSupplier isDone) {
        while (!isDone.getAsBoolean()) {
            Runnable task = this.asyncSubmittedTasks.poll();
            if (task != null) {
                task.run();
                continue;
            }
            LockSupport.parkNanos("Wait", 100000L);
        }
    }

    public void runAsyncTasks() {
        Runnable task;
        while ((task = this.asyncSubmittedTasks.poll()) != null) {
            task.run();
        }
        this.renderPassDrawTimers.values().forEach(TimerQueryManager::updateTime);
    }

    public boolean isInShadowPass() {
        return false;
    }

    protected boolean isDebugInfoShown() {
        return false;
    }

    public void update(Viewport positionedViewport, int frame, boolean spectator) {
        this.lastCameraPosition = positionedViewport.getBlockCoord();
        CameraTransform transform = positionedViewport.getTransform();
        this.cameraPosition = new Vector3d(transform.x, transform.y, transform.z);
        this.createTerrainRenderList(positionedViewport, frame, spectator);
        if (this.isInShadowPass()) {
            return;
        }
        this.checkTranslucencyChange();
        this.getCurrentRenderListManager().setNeedsUpdate(false);
    }

    private void checkTranslucencyChange() {
        if (this.lastCameraPosition == null) {
            return;
        }
        int camSectionX = PositionUtil.posToSectionCoord(this.cameraPosition.x);
        int camSectionY = PositionUtil.posToSectionCoord(this.cameraPosition.y);
        int camSectionZ = PositionUtil.posToSectionCoord(this.cameraPosition.z);
        this.scheduleTranslucencyUpdates(camSectionX, camSectionY, camSectionZ);
    }

    private void scheduleTranslucencyUpdates(int camSectionX, int camSectionY, int camSectionZ) {
        RenderListManager renderListManager = this.getCurrentRenderListManager();
        Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists = renderListManager.getRebuildLists().byUpdateType();
        ArrayDeque<RenderSection> sortRebuildList = rebuildLists.get((Object)ChunkUpdateType.SORT);
        ArrayDeque<RenderSection> importantSortRebuildList = rebuildLists.get((Object)ChunkUpdateType.IMPORTANT_SORT);
        boolean allowImportant = this.allowImportantRebuilds();
        TerrainRenderPass translucentPass = this.renderPassConfiguration.defaultTranslucentMaterial().pass;
        if (!this.hasTranslucencySortedSections()) {
            return;
        }
        Iterator<ChunkRenderList> it = renderListManager.getRenderLists().iterator();
        while (it.hasNext()) {
            ByteIterator sectionIterator;
            ChunkRenderList entry = it.next();
            RenderRegion region = entry.getRegion();
            if (!region.hasSectionsInPass(translucentPass) || (sectionIterator = entry.sectionsWithGeometryIterator(false)) == null) continue;
            while (sectionIterator.hasNext()) {
                boolean cameraChangedSection;
                double dz;
                double dy;
                double dx;
                double camDelta;
                ChunkUpdateType update;
                RenderSection section = region.getSection(sectionIterator.nextByteAsInt());
                if (section == null || !section.isNeedsDynamicTranslucencySorting() || (update = ChunkUpdateType.getPromotionUpdateType(section.getPendingUpdate(), allowImportant && this.shouldPrioritizeRebuild(section) ? ChunkUpdateType.IMPORTANT_SORT : ChunkUpdateType.SORT)) == null || (camDelta = (dx = this.cameraPosition.x - section.lastCameraX) * dx + (dy = this.cameraPosition.y - section.lastCameraY) * dy + (dz = this.cameraPosition.z - section.lastCameraZ) * dz) < 1.0) continue;
                boolean bl = cameraChangedSection = camSectionX != PositionUtil.posToSectionCoord(section.lastCameraX) || camSectionY != PositionUtil.posToSectionCoord(section.lastCameraY) || camSectionZ != PositionUtil.posToSectionCoord(section.lastCameraZ);
                if (!cameraChangedSection && !section.isAlignedWithSectionOnGrid(camSectionX, camSectionY, camSectionZ)) continue;
                section.setPendingUpdate(update);
                (update == ChunkUpdateType.IMPORTANT_SORT ? importantSortRebuildList : sortRebuildList).add(section);
                section.lastCameraX = this.cameraPosition.x;
                section.lastCameraY = this.cameraPosition.y;
                section.lastCameraZ = this.cameraPosition.z;
            }
        }
    }

    protected abstract boolean shouldRespectUpdateTaskQueueSizeLimit();

    private void createTerrainRenderList(Viewport viewport, int frame, boolean spectator) {
        float searchDistance = this.getSearchDistance();
        boolean useOcclusionCulling = this.shouldUseOcclusionCulling(viewport, spectator);
        this.getCurrentRenderListManager().startGraphUpdate(viewport, frame, this.regions.getRegionIdsLength(), searchDistance, useOcclusionCulling, !this.shouldRespectUpdateTaskQueueSizeLimit());
    }

    protected abstract boolean useFogOcclusion();

    private float getSearchDistance() {
        float distance = this.useFogOcclusion() ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    protected abstract boolean shouldUseOcclusionCulling(Viewport var1, boolean var2);

    private boolean hasTranslucencySortedSections() {
        return this.getCurrentRenderListManager().getRenderLists().getPasses().stream().anyMatch(TerrainRenderPass::isSorted);
    }

    protected abstract boolean isSectionVisuallyEmpty(int var1, int var2, int var3);

    public void onSectionAdded(int x, int y, int z) {
        long key = PositionUtil.packSection(x, y, z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        this.renderListManager.attachRenderSection(renderSection);
        if (this.shadowRenderListManager != null) {
            this.shadowRenderListManager.attachRenderSection(renderSection);
        }
        this.invalidateCachedSectionData(renderSection);
        if (this.isSectionVisuallyEmpty(x, y, z)) {
            this.updateSectionInfo(renderSection, RenderSection.EMPTY_DATA);
        } else {
            renderSection.setPendingUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.markGraphDirty();
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderSection section = (RenderSection)this.sectionByPosition.remove(PositionUtil.packSection(x, y, z));
        if (section == null) {
            return;
        }
        RenderRegion region = section.getRegion();
        if (region != null) {
            region.removeSection(section);
        }
        this.invalidateCachedSectionData(section);
        this.updateSectionInfo(section, null);
        this.renderListManager.detachRenderSection(section);
        if (this.shadowRenderListManager != null) {
            this.shadowRenderListManager.detachRenderSection(section);
        }
        this.sectionMetricsTracker.removeSection(section);
        section.delete();
        this.markGraphDirty();
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, CameraTransform occlusionCamera, CameraTransform camera) {
        if (this.disabledRenderPasses.contains(pass)) {
            return;
        }
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        boolean shouldProfile = this.isDebugInfoShown();
        TimerQueryManager timer = null;
        if (shouldProfile) {
            timer = (TimerQueryManager)this.renderPassDrawTimers.computeIfAbsent((Object)pass, $ -> new TimerQueryManager());
            timer.startProfiling();
        }
        this.chunkRenderer.render(matrices, commandList, this.getCurrentRenderListManager().getRenderLists(), pass, occlusionCamera, camera);
        if (shouldProfile) {
            timer.finishProfiling();
        }
        commandList.flush();
    }

    public boolean isSectionVisible(int x, int y, int z) {
        return this.getCurrentRenderListManager().isSectionVisible(x, y, z);
    }

    private boolean rebuildListHasUpdates() {
        for (ArrayDeque<RenderSection> queue : this.getCurrentRenderListManager().getRebuildLists().byUpdateType().values()) {
            if (queue.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void promoteInterimRebuildList() {
        Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists = this.getCurrentRenderListManager().getRebuildLists().byUpdateType();
        for (RenderSection section : this.sectionsRequestingUpdate) {
            rebuildLists.get((Object)section.getPendingUpdate()).add(section);
        }
    }

    public void updateChunks(boolean updateImmediately) {
        this.regions.update();
        this.jobMetricsTracker.tick();
        if (!this.renderListManager.isNeedsUpdate() && !this.sectionsRequestingUpdate.isEmpty()) {
            this.promoteInterimRebuildList();
        }
        this.sectionsRequestingUpdate.clear();
        if (!this.rebuildListHasUpdates()) {
            return;
        }
        ChunkJobCollector blockingRebuilds = new ChunkJobCollector(Integer.MAX_VALUE, this.buildResults::add);
        ChunkJobCollector deferredRebuilds = new ChunkJobCollector(this.builder.getSchedulingBudget(), this.buildResults::add);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_REBUILD);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_SORT);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.REBUILD);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.INITIAL_BUILD);
        ChunkJobCollector deferredSorts = new ChunkJobCollector(Math.max(4, this.builder.getSchedulingBudget() * 4), this.buildResults::add);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredSorts, ChunkUpdateType.SORT);
        blockingRebuilds.awaitCompletion(this.builder);
        this.builder.tick();
    }

    public void uploadChunks() {
        ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>> results = this.collectChunkBuildResults();
        if (results.isEmpty()) {
            return;
        }
        this.finishAllGraphUpdates();
        this.processChunkBuildResults(results);
        for (ChunkJobResult.Success<? extends ChunkTaskOutput> result : results) {
            result.output().delete();
        }
        if (this.getCurrentRenderListManager().getRebuildLists().hasAdditionalUpdates()) {
            this.markGraphDirty();
        }
    }

    public final void tickVisibleRenders() {
        this.getCurrentRenderListManager().tickVisibleRenders();
    }

    private void processChunkBuildResults(ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>> results) {
        List<ChunkJobResult.Success<? extends ChunkTaskOutput>> filtered = RenderSectionManager.filterChunkBuildResults(results);
        this.regions.uploadMeshes(RenderDevice.INSTANCE.createCommandList(), filtered, this::markGraphDirty);
        for (ChunkJobResult.Success<? extends ChunkTaskOutput> holder : filtered) {
            CancellationToken job;
            ChunkTaskOutput result = holder.output();
            if (result instanceof ChunkBuildOutput) {
                ChunkBuildOutput buildResult = (ChunkBuildOutput)result;
                boolean changed = this.updateSectionInfo(result.render, buildResult.info);
                if (changed) {
                    this.markGraphDirty();
                }
                this.updateTranslucencyInfo(result.render, (Map<TerrainRenderPass, BuiltSectionMeshParts>)buildResult.meshes);
            }
            if ((job = result.render.getBuildCancellationToken()) != null && result.buildTime >= result.render.getLastSubmittedFrame()) {
                result.render.setBuildCancellationToken(null);
            }
            result.render.setLastBuiltFrame(result.buildTime);
            this.sectionMetricsTracker.updateSectionBuildDuration(result.render, holder.executionTimeNanos());
        }
    }

    private void updateTranslucencyInfo(RenderSection render, Map<TerrainRenderPass, BuiltSectionMeshParts> meshes) {
        Reference2ObjectArrayMap sortStates = new Reference2ObjectArrayMap();
        for (Map.Entry<TerrainRenderPass, BuiltSectionMeshParts> entry : meshes.entrySet()) {
            if (!entry.getKey().isSorted()) continue;
            sortStates.put(entry.getKey(), Objects.requireNonNull(entry.getValue().sortState()).compactForStorage());
        }
        render.setTranslucencySortStates((Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState>)(sortStates.isEmpty() ? Collections.emptyMap() : sortStates));
    }

    @MustBeInvokedByOverriders
    protected boolean updateSectionInfo(RenderSection render, @Nullable BuiltRenderSectionData info) {
        boolean changed = render.setInfo(info);
        if (changed) {
            long visibilityData = info != null ? info.visibilityData : 0L;
            this.renderListManager.updateVisibilityData(render.getChunkX(), render.getChunkY(), render.getChunkZ(), visibilityData);
            if (this.shadowRenderListManager != null) {
                this.shadowRenderListManager.updateVisibilityData(render.getChunkX(), render.getChunkY(), render.getChunkZ(), visibilityData);
            }
            if (!(info instanceof MinecraftBuiltRenderSectionData)) {
                this.sectionsWithGlobalEntities.remove((Object)render);
            } else {
                MinecraftBuiltRenderSectionData data = (MinecraftBuiltRenderSectionData)info;
                if (!data.globalBlockEntities.isEmpty()) {
                    this.sectionsWithGlobalEntities.add((Object)render);
                }
            }
        }
        return changed;
    }

    private static List<ChunkJobResult.Success<? extends ChunkTaskOutput>> filterChunkBuildResults(ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (ChunkJobResult.Success<? extends ChunkTaskOutput> holder : outputs) {
            RenderSection render;
            ChunkJobResult.Success previousHolder;
            ChunkTaskOutput output = holder.output();
            if (output.render.isDisposed() || output.render.getLastBuiltFrame() > output.buildTime || (previousHolder = (ChunkJobResult.Success)map.get((Object)(render = output.render))) != null && ((ChunkTaskOutput)previousHolder.output()).buildTime >= output.buildTime) continue;
            map.put((Object)render, holder);
        }
        return new ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>>((Collection<ChunkJobResult.Success<? extends ChunkTaskOutput>>)map.values());
    }

    private ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>> collectChunkBuildResults() {
        ChunkJobResult<? extends ChunkTaskOutput> result;
        ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>> results = new ArrayList<ChunkJobResult.Success<? extends ChunkTaskOutput>>();
        while ((result = this.buildResults.poll()) != null) {
            if (result instanceof ChunkJobResult.Success) {
                ChunkJobResult.Success successfulResult = (ChunkJobResult.Success)result;
                this.jobMetricsTracker.collectMetrics(successfulResult);
                results.add(successfulResult);
                continue;
            }
            if (result instanceof ChunkJobResult.Failure) {
                ChunkJobResult.Failure failure = (ChunkJobResult.Failure)result;
                failure.abort();
                continue;
            }
            throw new AssertionError();
        }
        return results;
    }

    private void submitRebuildTasks(ChunkJobCollector collector, ChunkUpdateType type) {
        ArrayDeque<RenderSection> queue = this.getCurrentRenderListManager().getRebuildLists().byUpdateType().get((Object)type);
        int frame = this.getCurrentRenderListManager().getLastUpdatedFrame();
        while (!queue.isEmpty() && collector.canOffer()) {
            ChunkBuilderTask task;
            RenderSection section = queue.remove();
            if (section.isDisposed() || section.getPendingUpdate() != type) continue;
            ChunkBuilderTask chunkBuilderTask = task = type.isSort() ? this.createSortTask(section, frame) : this.createRebuildTask(section, frame);
            if (task == null && type.isSort()) {
                section.setPendingUpdate(null);
                continue;
            }
            if (task != null) {
                ChunkJobTyped job = this.builder.scheduleTask(task, type.isImportant(), collector::onJobFinished);
                collector.addSubmittedJob(job);
                section.setBuildCancellationToken(job);
                if (!type.isSort()) {
                    section.setNeedsDynamicTranslucencySorting(false);
                }
            } else {
                ChunkJobResult.Success<ChunkBuildOutput> result = new ChunkJobResult.Success<ChunkBuildOutput>(new ChunkBuildOutput(section, RenderSection.EMPTY_DATA, (Reference2ReferenceMap<TerrainRenderPass, BuiltSectionMeshParts>)Reference2ReferenceMaps.emptyMap(), frame), -1L);
                this.buildResults.add(result);
                section.setBuildCancellationToken(null);
            }
            section.setLastSubmittedFrame(frame);
            section.setPendingUpdate(null);
        }
    }

    @Nullable
    protected abstract ChunkBuilderTask<ChunkBuildOutput> createRebuildTask(RenderSection var1, int var2);

    public ChunkBuilderSortTask createSortTask(RenderSection render, int frame) {
        if (!render.isNeedsDynamicTranslucencySorting()) {
            return null;
        }
        return new ChunkBuilderSortTask(render, (float)this.cameraPosition.x, (float)this.cameraPosition.y, (float)this.cameraPosition.z, frame, render.getTranslucencySortStates(), this.renderPassConfiguration);
    }

    public void markGraphDirty() {
        if (this.shadowRenderListManager != null) {
            this.shadowRenderListManager.setNeedsUpdate(true);
        }
        this.renderListManager.setNeedsUpdate(true);
    }

    public void finishAllGraphUpdates() {
        this.renderListManager.finishPreviousGraphUpdate();
        if (this.shadowRenderListManager != null) {
            this.shadowRenderListManager.finishPreviousGraphUpdate();
        }
    }

    public boolean needsUpdate() {
        return this.getCurrentRenderListManager().isNeedsUpdate();
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.finishAllGraphUpdates();
        this.builder.shutdown();
        for (ChunkJobResult.Success<? extends ChunkTaskOutput> result : this.collectChunkBuildResults()) {
            result.output().delete();
        }
        this.renderListManager.destroy();
        if (this.shadowRenderListManager != null) {
            this.shadowRenderListManager.destroy();
        }
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
        this.renderPassDrawTimers.values().forEach(TimerQueryManager::close);
        this.renderPassDrawTimers.clear();
        this.sectionsWithGlobalEntities.clear();
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.getCurrentRenderListManager().getRenderLists().iterator();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    public final void scheduleAsyncTask(Runnable runnable) {
        if (Thread.currentThread() == this.renderThread) {
            runnable.run();
        } else {
            this.asyncSubmittedTasks.add(runnable);
        }
    }

    private void scheduleRebuildOffThread(int x, int y, int z, boolean important) {
        this.scheduleAsyncTask(() -> this.scheduleSectionForRebuild(x, y, z, important));
    }

    public final void scheduleRebuild(int x, int y, int z, boolean important) {
        if (Thread.currentThread() != this.renderThread) {
            this.scheduleRebuildOffThread(x, y, z, important);
            return;
        }
        this.scheduleSectionForRebuild(x, y, z, important);
    }

    protected void invalidateCachedSectionData(RenderSection section) {
    }

    protected void scheduleSectionForRebuild(int x, int y, int z, boolean important) {
        RenderSection section = (RenderSection)this.sectionByPosition.get(PositionUtil.packSection(x, y, z));
        if (section != null) {
            this.invalidateCachedSectionData(section);
            ChunkUpdateType pendingUpdate = this.allowImportantRebuilds() && (important || this.shouldPrioritizeRebuild(section)) ? ChunkUpdateType.IMPORTANT_REBUILD : ChunkUpdateType.REBUILD;
            if (section.requestUpdate(pendingUpdate)) {
                if (!this.getCurrentRenderListManager().isNeedsUpdate() && this.sectionsRequestingUpdate.size() < this.builder.getSchedulingBudget()) {
                    this.sectionsRequestingUpdate.add((Object)section);
                } else {
                    this.markGraphDirty();
                }
            }
        }
    }

    public void scheduleRebuildAll() {
        for (RenderSection section : this.sectionByPosition.values()) {
            if (this.isSectionVisuallyEmpty(section.getChunkX(), section.getChunkY(), section.getChunkZ())) continue;
            this.invalidateCachedSectionData(section);
            section.requestUpdate(ChunkUpdateType.REBUILD);
        }
        this.markGraphDirty();
    }

    private boolean shouldPrioritizeRebuild(RenderSection section) {
        return this.lastCameraPosition != null && section.getSquaredDistanceFromBlockCenter(this.lastCameraPosition.x(), this.lastCameraPosition.y(), this.lastCameraPosition.z()) < NEARBY_REBUILD_DISTANCE;
    }

    protected abstract boolean allowImportantRebuilds();

    private float getEffectiveRenderDistance() {
        float[] color = ChunkShaderFogComponent.FOG_SERVICE.getFogColor();
        float alpha = color[3];
        float distance = ChunkShaderFogComponent.FOG_SERVICE.getFogCutoff();
        float renderDistance = this.getRenderDistance();
        if (Math.abs(alpha - 1.0f) >= 1.0E-5f) {
            return renderDistance;
        }
        return Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return (float)this.renderDistance * 16.0f;
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(PositionUtil.packSection(x, y, z));
    }

    public Collection<RenderSection> getAllRenderSections() {
        return Collections.unmodifiableCollection(this.sectionByPosition.values());
    }

    private Collection<String> getSortingStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int[] sectionCounts = new int[TranslucentQuadAnalyzer.Level.VALUES.length];
        Iterator<ChunkRenderList> it = this.getCurrentRenderListManager().getRenderLists().iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator listIter = renderList.sectionsWithGeometryIterator(false);
            if (listIter == null) continue;
            while (listIter.hasNext()) {
                RenderSection section = region.getSection(listIter.nextByteAsInt());
                if (section == null || section.getTranslucencySortStates().isEmpty()) continue;
                int n = section.getHighestSortingLevel().ordinal();
                sectionCounts[n] = sectionCounts[n] + 1;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Sorting: ");
        TranslucentQuadAnalyzer.Level[] values = TranslucentQuadAnalyzer.Level.VALUES;
        for (int i = 0; i < values.length; ++i) {
            TranslucentQuadAnalyzer.Level level = values[i];
            sb.append(level.name());
            sb.append('=');
            sb.append(sectionCounts[level.ordinal()]);
            if (i + 1 >= values.length) continue;
            sb.append(", ");
        }
        list.add(sb.toString());
        return list;
    }

    private Object2LongMap<TerrainRenderPass> computeRenderPassTimingsMap() {
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        for (Map.Entry entry : this.renderPassDrawTimers.entrySet()) {
            map.put((Object)((TerrainRenderPass)entry.getKey()), ((TimerQueryManager)entry.getValue()).getLastTime());
        }
        return map;
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        int indexCount = 0;
        long deviceUsed = 0L;
        long deviceAllocated = 0L;
        long indexUsed = 0L;
        long indexAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            for (RenderRegion.DeviceResources resources : region.getAllResources()) {
                GlBufferArena buffer = resources.getGeometryArena();
                deviceUsed += buffer.getDeviceUsedMemoryL();
                deviceAllocated += buffer.getDeviceAllocatedMemoryL();
                GlBufferArena indexBuffer = resources.getIndexArena();
                if (indexBuffer != null) {
                    indexUsed += indexBuffer.getDeviceUsedMemoryL();
                    indexAllocated += indexBuffer.getDeviceAllocatedMemoryL();
                    ++indexCount;
                }
                ++count;
            }
        }
        list.add(String.format("G: %d/%d, I: %d/%d MiB (%d buffers)", MathUtil.toMib(deviceUsed), MathUtil.toMib(deviceAllocated), MathUtil.toMib(indexUsed), MathUtil.toMib(indexAllocated), count));
        list.add(String.format("Transfer Queue: %s", this.regions.getStagingBuffer().toString()));
        ChunkRebuildLists rebuildLists = this.getCurrentRenderListManager().getRebuildLists();
        list.add(String.format("Chunk Queues: U=%02d (P0=%03d | P1=%03d | P2=%03d)", this.buildResults.size(), rebuildLists.getUpdateCount(ChunkUpdateType.IMPORTANT_REBUILD), rebuildLists.getUpdateCount(ChunkUpdateType.REBUILD), rebuildLists.getUpdateCount(ChunkUpdateType.INITIAL_BUILD)));
        RenderListManager.RenderListDebugStatistics debugStats = this.renderListManager.getDebugStatistics();
        Iterator counts = debugStats.renderPassCounts().object2IntEntrySet().stream().sorted(Comparator.comparingInt(e -> -e.getIntValue())).iterator();
        Object2LongMap<TerrainRenderPass> timingMap = this.renderPassTimingsDebounced.get();
        while (counts.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)counts.next();
            long duration = timingMap.getLong(entry.getKey());
            String time = duration == 0L ? "?? ms" : TimeUtil.stringifyTime(duration, TimeUnit.NANOSECONDS);
            list.add(RenderSectionManager.jvmdowngrader$concat$getDebugStrings$1(((TerrainRenderPass)entry.getKey()).name(), entry.getIntValue(), time));
        }
        if (this.renderListManager.getRenderLists().getPasses().stream().anyMatch(TerrainRenderPass::isSorted)) {
            list.add(debugStats.getSortingString());
        }
        return list;
    }

    private RenderListManager getCurrentRenderListManager() {
        return this.isInShadowPass() ? this.shadowRenderListManager : this.renderListManager;
    }

    public SortedRenderLists getRenderLists() {
        return this.getCurrentRenderListManager().getRenderLists();
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.minSection; y < this.maxSection; ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.minSection; y < this.maxSection; ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public void toggleRenderingForTerrainPass(TerrainRenderPass pass) {
        if (this.disabledRenderPasses.contains(pass)) {
            this.disabledRenderPasses.remove(pass);
        } else {
            this.disabledRenderPasses.add(pass);
        }
    }

    public final Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }

    public String getTickerDebugString() {
        return this.getCurrentRenderListManager().getTickerDebugString();
    }

    public RenderPassConfiguration<?> getRenderPassConfiguration() {
        return this.renderPassConfiguration;
    }

    public ChunkJobMetricsTracker getJobMetricsTracker() {
        return this.jobMetricsTracker;
    }

    public RenderSectionMetricsTracker getSectionMetricsTracker() {
        return this.sectionMetricsTracker;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getDebugStrings$1(String string, int n, String string2) {
        return string + " - " + n + " sections, " + string2;
    }
}

