/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RecordComponents(value={@RecordComponents.Value(name="chunkRenderTypeToMaterialMap", type=Map.class), @RecordComponents.Value(name="vanillaRenderStages", type=Map.class), @RecordComponents.Value(name="defaultSolidMaterial", type=Material.class), @RecordComponents.Value(name="defaultCutoutMippedMaterial", type=Material.class), @RecordComponents.Value(name="defaultTranslucentMaterial", type=Material.class)})
public final class RenderPassConfiguration<R>
extends J_L_Record {
    private final Map<R, Material> chunkRenderTypeToMaterialMap;
    private final Map<R, Collection<TerrainRenderPass>> vanillaRenderStages;
    private final Material defaultSolidMaterial;
    private final Material defaultCutoutMippedMaterial;
    private final Material defaultTranslucentMaterial;

    public RenderPassConfiguration(Map<R, Material> chunkRenderTypeToMaterialMap, Map<R, Collection<TerrainRenderPass>> vanillaRenderStages, Material defaultSolidMaterial, Material defaultCutoutMippedMaterial, Material defaultTranslucentMaterial) {
        this.chunkRenderTypeToMaterialMap = chunkRenderTypeToMaterialMap;
        this.vanillaRenderStages = vanillaRenderStages;
        this.defaultSolidMaterial = defaultSolidMaterial;
        this.defaultCutoutMippedMaterial = defaultCutoutMippedMaterial;
        this.defaultTranslucentMaterial = defaultTranslucentMaterial;
    }

    @Deprecated
    public ChunkVertexType getVertexTypeForPass(TerrainRenderPass pass) {
        return pass.vertexType();
    }

    @Deprecated
    public ChunkPrimitiveType getPrimitiveTypeForPass(TerrainRenderPass pass) {
        return pass.primitiveType();
    }

    public Material getMaterialForRenderType(Object type) {
        Objects.requireNonNull(type, "Null render type provided");
        Material material = this.chunkRenderTypeToMaterialMap.get(type);
        if (material == null) {
            throw new IllegalArgumentException(type.toString());
        }
        return material;
    }

    public Stream<TerrainRenderPass> getAllKnownRenderPasses() {
        return this.vanillaRenderStages().values().stream().flatMap(Collection::stream).distinct();
    }

    public final String toString() {
        return RenderPassConfiguration.jvmdowngrader$toString$toString(this);
    }

    public final int hashCode() {
        return RenderPassConfiguration.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return RenderPassConfiguration.jvmdowngrader$equals$equals(this, o);
    }

    public Map<R, Material> chunkRenderTypeToMaterialMap() {
        return this.chunkRenderTypeToMaterialMap;
    }

    public Map<R, Collection<TerrainRenderPass>> vanillaRenderStages() {
        return this.vanillaRenderStages;
    }

    public Material defaultSolidMaterial() {
        return this.defaultSolidMaterial;
    }

    public Material defaultCutoutMippedMaterial() {
        return this.defaultCutoutMippedMaterial;
    }

    public Material defaultTranslucentMaterial() {
        return this.defaultTranslucentMaterial;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(RenderPassConfiguration renderPassConfiguration) {
        RenderPassConfiguration renderPassConfiguration2 = renderPassConfiguration;
        return "RenderPassConfiguration[" + "chunkRenderTypeToMaterialMap=" + renderPassConfiguration.chunkRenderTypeToMaterialMap + ", " + "vanillaRenderStages=" + renderPassConfiguration.vanillaRenderStages + ", " + "defaultSolidMaterial=" + renderPassConfiguration.defaultSolidMaterial + ", " + "defaultCutoutMippedMaterial=" + renderPassConfiguration.defaultCutoutMippedMaterial + ", " + "defaultTranslucentMaterial=" + renderPassConfiguration.defaultTranslucentMaterial + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(RenderPassConfiguration renderPassConfiguration) {
        Object[] objectArray = new Object[]{renderPassConfiguration.chunkRenderTypeToMaterialMap, renderPassConfiguration.vanillaRenderStages, renderPassConfiguration.defaultSolidMaterial, renderPassConfiguration.defaultCutoutMippedMaterial, renderPassConfiguration.defaultTranslucentMaterial};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(RenderPassConfiguration renderPassConfiguration, Object object) {
        if (renderPassConfiguration == object) {
            return true;
        }
        if (object != null && object instanceof RenderPassConfiguration) {
            RenderPassConfiguration renderPassConfiguration2 = (RenderPassConfiguration)((Object)object);
            if (Objects.equals(renderPassConfiguration.chunkRenderTypeToMaterialMap, renderPassConfiguration2.chunkRenderTypeToMaterialMap) && Objects.equals(renderPassConfiguration.vanillaRenderStages, renderPassConfiguration2.vanillaRenderStages) && Objects.equals(renderPassConfiguration.defaultSolidMaterial, renderPassConfiguration2.defaultSolidMaterial) && Objects.equals(renderPassConfiguration.defaultCutoutMippedMaterial, renderPassConfiguration2.defaultCutoutMippedMaterial) && Objects.equals(renderPassConfiguration.defaultTranslucentMaterial, renderPassConfiguration2.defaultTranslucentMaterial)) {
                return true;
            }
        }
        return false;
    }
}

