/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.light.flat;

import java.util.Arrays;
import org.embeddedt.embeddium.api.util.NormI8;
import org.embeddedt.embeddium.impl.model.light.DiffuseProvider;
import org.embeddedt.embeddium.impl.model.light.LightPipeline;
import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;
import org.embeddedt.embeddium.impl.model.light.data.QuadLightData;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;
    private final DiffuseProvider diffuseProvider;
    private final boolean useQuadNormalsForShading;

    @Override
    public void calculate(ModelQuadView quad, int x, int y, int z, QuadLightData out, ModelQuadFacing cullFace, ModelQuadFacing lightFace, boolean shade, boolean applyAoDepthBlending) {
        int flags;
        if (!lightFace.isDirection()) {
            throw new IllegalStateException();
        }
        int lightmap = cullFace.isDirection() ? this.getOffsetLightmap(x, y, z, cullFace) : (((flags = quad.getFlags()) & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(x, y, z)) ? this.getOffsetLightmap(x, y, z, lightFace) : LightDataAccess.getEmissiveLightmap(this.lightCache.get(x, y, z)));
        Arrays.fill(out.lm, lightmap);
        if ((quad.getFlags() & 8) != 0 || !this.useQuadNormalsForShading) {
            Arrays.fill(out.br, this.diffuseProvider.getDiffuse(lightFace, shade));
        } else {
            this.applySidedBrightnessFromNormals(quad, out, shade);
        }
    }

    public void applySidedBrightnessFromNormals(ModelQuadView quad, QuadLightData out, boolean shade) {
        int normal = quad.getModFaceNormal();
        Arrays.fill(out.br, this.diffuseProvider.getDiffuse(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal), shade));
    }

    private int getOffsetLightmap(int x, int y, int z, ModelQuadFacing face) {
        int word = this.lightCache.get(x, y, z);
        if (LightDataAccess.unpackEM(word)) {
            return LightDataAccess.FULL_BRIGHT;
        }
        int adjWord = this.lightCache.get(x, y, z, face);
        return LightDataAccess.pack(Math.max(LightDataAccess.unpackBL(adjWord), LightDataAccess.unpackLU(word)), LightDataAccess.unpackSL(adjWord));
    }

    public FlatLightPipeline(LightDataAccess lightCache, DiffuseProvider diffuseProvider, boolean useQuadNormalsForShading) {
        this.lightCache = lightCache;
        this.diffuseProvider = diffuseProvider;
        this.useQuadNormalsForShading = useQuadNormalsForShading;
    }
}

