/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.framework;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gui.framework.TextFormattingStyle;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Styled.class, Translatable.class, Literal.class})
public interface TextComponent {
    default public List<TextComponent> children() {
        return J_U_List.of();
    }

    default public TextComponent withStyle(TextFormattingStyle style, TextFormattingStyle ... rest) {
        return new Styled(this, EnumSet.of(style, rest));
    }

    public static TextComponent literal(String text) {
        return new Literal(text);
    }

    public static TextComponent translatable(String key, Object ... args) {
        return new Translatable(J_U_List.of((Object)key), Arrays.asList(args));
    }

    public static TextComponent translatable(List<String> keys, Object ... args) {
        return new Translatable(keys, Arrays.asList(args));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="inner", type=TextComponent.class), @RecordComponents.Value(name="styles", type=EnumSet.class)})
    @NestHost(value=TextComponent.class)
    public static final class Styled
    extends J_L_Record
    implements TextComponent {
        private final TextComponent inner;
        private final EnumSet<TextFormattingStyle> styles;

        public Styled(TextComponent inner, EnumSet<TextFormattingStyle> styles) {
            this.inner = inner;
            this.styles = styles;
        }

        @Override
        public List<TextComponent> children() {
            return J_U_List.of((Object)this.inner);
        }

        @Override
        public TextComponent withStyle(TextFormattingStyle style, TextFormattingStyle ... rest) {
            EnumSet<TextFormattingStyle> newSet = EnumSet.copyOf(this.styles);
            newSet.add(style);
            newSet.addAll(Arrays.asList(rest));
            return new Styled(this.inner, newSet);
        }

        @NotNull
        public String toString() {
            return Styled.jvmdowngrader$concat$toString$1(this.inner.toString());
        }

        public final int hashCode() {
            return Styled.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Styled.jvmdowngrader$equals$equals(this, o);
        }

        public TextComponent inner() {
            return this.inner;
        }

        public EnumSet<TextFormattingStyle> styles() {
            return this.styles;
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(Styled styled) {
            Object[] objectArray = new Object[]{styled.inner, styled.styles};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(Styled styled, Object object) {
            if (styled == object) {
                return true;
            }
            if (object != null && object instanceof Styled) {
                Styled styled2 = (Styled)object;
                if (Objects.equals(styled.inner, styled2.inner) && Objects.equals(styled.styles, styled2.styles)) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string) {
            return string + "[styled]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="text", type=String.class)})
    @NestHost(value=TextComponent.class)
    public static final class Literal
    extends J_L_Record
    implements TextComponent {
        private final String text;

        public Literal(String text) {
            this.text = text;
        }

        @NotNull
        public String toString() {
            return this.text;
        }

        public final int hashCode() {
            return Literal.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Literal.jvmdowngrader$equals$equals(this, o);
        }

        public String text() {
            return this.text;
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(Literal literal) {
            Object[] objectArray = new Object[]{literal.text};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(Literal literal, Object object) {
            if (literal == object) {
                return true;
            }
            if (object != null && object instanceof Literal) {
                Literal literal2 = (Literal)object;
                if (Objects.equals(literal.text, literal2.text)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="keys", type=List.class), @RecordComponents.Value(name="args", type=List.class)})
    @NestHost(value=TextComponent.class)
    public static final class Translatable
    extends J_L_Record
    implements TextComponent {
        private final List<String> keys;
        private final List<?> args;

        public Translatable(List<String> keys, List<?> args) {
            this.keys = keys;
            this.args = args;
        }

        @NotNull
        public String toString() {
            String keyString;
            String string = keyString = this.keys.size() == 1 ? this.keys.getFirst() : this.keys.toString();
            if (this.args.isEmpty()) {
                return keyString;
            }
            return Translatable.jvmdowngrader$concat$toString$1(keyString, String.valueOf(this.args));
        }

        public final int hashCode() {
            return Translatable.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Translatable.jvmdowngrader$equals$equals(this, o);
        }

        public List<String> keys() {
            return this.keys;
        }

        public List<?> args() {
            return this.args;
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(Translatable translatable) {
            Object[] objectArray = new Object[]{translatable.keys, translatable.args};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(Translatable translatable, Object object) {
            if (translatable == object) {
                return true;
            }
            if (object != null && object instanceof Translatable) {
                Translatable translatable2 = (Translatable)object;
                if (Objects.equals(translatable.keys, translatable2.keys) && Objects.equals(translatable.args, translatable2.args)) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
            return string + string2;
        }
    }
}

