/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame.tab;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.embeddedt.embeddium.impl.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.impl.gui.frame.OptionPageFrame;
import org.embeddedt.embeddium.impl.gui.frame.ScrollableFrame;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.taumc.celeritas.api.options.OptionIdentifier;
import org.taumc.celeritas.api.options.structure.Option;
import org.taumc.celeritas.api.options.structure.OptionPage;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@RecordComponents(value={@RecordComponents.Value(name="id", type=OptionIdentifier.class), @RecordComponents.Value(name="title", type=TextComponent.class), @RecordComponents.Value(name="onSelectFunction", type=Supplier.class), @RecordComponents.Value(name="frameFunction", type=Function.class)})
@NestMembers(value={Builder.class})
public final class Tab<T extends AbstractFrame>
extends J_L_Record {
    private final OptionIdentifier<Void> id;
    private final TextComponent title;
    private final Supplier<Boolean> onSelectFunction;
    private final Function<Dim2i, T> frameFunction;

    public Tab(OptionIdentifier<Void> id, TextComponent title, Supplier<Boolean> onSelectFunction, Function<Dim2i, T> frameFunction) {
        this.id = id;
        this.title = title;
        this.onSelectFunction = onSelectFunction;
        this.frameFunction = frameFunction;
    }

    public static Builder<?> createBuilder() {
        return new Builder();
    }

    public T createFrame(Dim2i dim) {
        return (T)(this.frameFunction != null ? (AbstractFrame)this.frameFunction.apply(dim) : null);
    }

    public static Tab<ScrollableFrame> from(OptionPage page, Predicate<Option<?>> optionFilter, AtomicReference<Integer> verticalScrollBarOffset) {
        Function<Dim2i, ScrollableFrame> frameFunction = dim2i -> ScrollableFrame.createBuilder().setDimension((Dim2i)dim2i).setFrame(OptionPageFrame.createBuilder().setDimension(new Dim2i(dim2i.x(), dim2i.y(), dim2i.width(), dim2i.height())).setOptionPage(page).setOptionFilter(optionFilter).build()).setVerticalScrollBarOffset(verticalScrollBarOffset).build();
        return Tab.builder().setTitle(page.getName()).setId(page.getId()).setFrameFunction(frameFunction).build();
    }

    public static <T extends AbstractFrame> Builder<T> builder() {
        return new Builder();
    }

    public final String toString() {
        return Tab.jvmdowngrader$toString$toString(this);
    }

    public final int hashCode() {
        return Tab.jvmdowngrader$hashCode$hashCode(this);
    }

    public final boolean equals(Object o) {
        return Tab.jvmdowngrader$equals$equals(this, o);
    }

    public OptionIdentifier<Void> id() {
        return this.id;
    }

    public TextComponent title() {
        return this.title;
    }

    public Supplier<Boolean> onSelectFunction() {
        return this.onSelectFunction;
    }

    public Function<Dim2i, T> frameFunction() {
        return this.frameFunction;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(Tab tab) {
        Tab tab2 = tab;
        return "Tab[" + "id=" + tab.id + ", " + "title=" + tab.title + ", " + "onSelectFunction=" + tab.onSelectFunction + ", " + "frameFunction=" + tab.frameFunction + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(Tab tab) {
        Object[] objectArray = new Object[]{tab.id, tab.title, tab.onSelectFunction, tab.frameFunction};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(Tab tab, Object object) {
        if (tab == object) {
            return true;
        }
        if (object != null && object instanceof Tab) {
            Tab tab2 = (Tab)((Object)object);
            if (Objects.equals(tab.id, tab2.id) && Objects.equals(tab.title, tab2.title) && Objects.equals(tab.onSelectFunction, tab2.onSelectFunction) && Objects.equals(tab.frameFunction, tab2.frameFunction)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=Tab.class)
    public static class Builder<T extends AbstractFrame> {
        private OptionIdentifier<Void> id;
        private TextComponent title;
        private Supplier<Boolean> onSelectFunction;
        private Function<Dim2i, T> frameFunction;

        Builder() {
        }

        public Builder<T> setId(OptionIdentifier<Void> id) {
            this.id = id;
            return this;
        }

        public Builder<T> setTitle(TextComponent title) {
            this.title = title;
            return this;
        }

        public Builder<T> setOnSelectFunction(Supplier<Boolean> onSelectFunction) {
            this.onSelectFunction = onSelectFunction;
            return this;
        }

        public Builder<T> setFrameFunction(Function<Dim2i, T> frameFunction) {
            this.frameFunction = frameFunction;
            return this;
        }

        public Tab<T> build() {
            return new Tab<T>(this.id, this.title, this.onSelectFunction, this.frameFunction);
        }

        public String toString() {
            return Builder.jvmdowngrader$concat$toString$1(String.valueOf(this.id), String.valueOf(this.title), String.valueOf(this.onSelectFunction), String.valueOf(this.frameFunction));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4) {
            return "Tab.Builder(id=" + string + ", title=" + string2 + ", onSelectFunction=" + string3 + ", frameFunction=" + string4 + ")";
        }
    }
}

