/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame;

import java.util.concurrent.atomic.AtomicReference;
import org.embeddedt.embeddium.impl.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.impl.gui.frame.components.ScrollBarComponent;
import org.embeddedt.embeddium.impl.gui.framework.DrawContext;
import org.embeddedt.embeddium.impl.gui.framework.InteractionContext;
import org.embeddedt.embeddium.impl.util.Dim2i;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Builder.class})
public class ScrollableFrame
extends AbstractFrame {
    protected final Dim2i frameOrigin;
    protected final AbstractFrame frame;
    private boolean canScrollHorizontal;
    private boolean canScrollVertical;
    private Dim2i viewPortDimension = null;
    private ScrollBarComponent verticalScrollBar = null;
    private ScrollBarComponent horizontalScrollBar = null;

    public ScrollableFrame(Dim2i dim, AbstractFrame frame, boolean renderOutline, AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        super(dim, renderOutline);
        this.frame = frame;
        this.frameOrigin = new Dim2i(frame.dim.x(), frame.dim.y(), 0, 0);
        this.setupFrame(verticalScrollBarOffset, horizontalScrollBarOffset);
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame(AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        int maxWidth = 0;
        int maxHeight = 0;
        if (!this.dim.canFitDimension(this.frame.dim)) {
            int value;
            if (this.dim.getLimitX() < this.frame.dim.getLimitX() && maxWidth < (value = this.frame.dim.x() - this.dim.x() + this.frame.dim.width())) {
                maxWidth = value;
            }
            if (this.dim.getLimitY() < this.frame.dim.getLimitY() && maxHeight < (value = this.frame.dim.y() - this.dim.y() + this.frame.dim.height())) {
                maxHeight = value;
            }
        }
        if (maxWidth > 0) {
            this.canScrollHorizontal = true;
        }
        if (maxHeight > 0) {
            this.canScrollVertical = true;
        }
        if (this.canScrollHorizontal && this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height() - 11);
        } else if (this.canScrollHorizontal) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height() - 11);
            this.frame.dim = this.frame.dim.withHeight(this.frame.dim.height() - 11);
        } else if (this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height());
            this.frame.dim = this.frame.dim.withWidth(this.frame.dim.width() - 11);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.x(), this.viewPortDimension.getLimitY() + 1, this.viewPortDimension.width(), 10), ScrollBarComponent.Mode.HORIZONTAL, this.frame.dim.width(), this.viewPortDimension.width(), offset -> horizontalScrollBarOffset.set((Integer)offset));
            this.horizontalScrollBar.setOffset(horizontalScrollBarOffset.get());
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.getLimitX() + 1, this.viewPortDimension.y(), 10, this.viewPortDimension.height()), ScrollBarComponent.Mode.VERTICAL, this.frame.dim.height(), this.viewPortDimension.height(), offset -> verticalScrollBarOffset.set((Integer)offset), this.viewPortDimension);
            this.verticalScrollBar.setOffset(verticalScrollBarOffset.get());
        }
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.updateThumbPosition();
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.updateThumbPosition();
        }
        this.frame.buildFrame();
        this.children.add(this.frame);
        super.buildFrame();
    }

    private double applyOffset(ScrollBarComponent component, double coord, boolean negate) {
        if (component == null) {
            return coord;
        }
        return coord + (double)(component.getOffset() * (negate ? -1 : 1));
    }

    @Override
    public void render(DrawContext drawContext, int mouseX, int mouseY, float delta) {
        if (this.canScrollHorizontal || this.canScrollVertical) {
            if (this.renderOutline) {
                drawContext.drawBorder(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
            }
            boolean mouseInViewport = this.viewPortDimension.containsCursor(mouseX, mouseY);
            drawContext.enableScissor(this.viewPortDimension.x(), this.viewPortDimension.y(), this.viewPortDimension.getLimitX(), this.viewPortDimension.getLimitY());
            drawContext.pushMatrix();
            drawContext.translate(this.applyOffset(this.horizontalScrollBar, 0.0, true), this.applyOffset(this.verticalScrollBar, 0.0, true), 0.0);
            super.render(drawContext, mouseInViewport ? (int)this.applyOffset(this.horizontalScrollBar, mouseX, false) : -1, mouseInViewport ? (int)this.applyOffset(this.verticalScrollBar, mouseY, false) : -1, delta);
            drawContext.popMatrix();
            drawContext.disableScissor();
        } else {
            super.render(drawContext, mouseX, mouseY, delta);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.render(drawContext, mouseX, mouseY, delta);
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.render(drawContext, mouseX, mouseY, delta);
        }
    }

    @Override
    public boolean mouseClicked(InteractionContext context, double mouseX, double mouseY, int button) {
        return this.canScrollHorizontal && this.horizontalScrollBar.mouseClicked(context, mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.mouseClicked(context, mouseX, mouseY, button) || super.mouseClicked(context, this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button);
    }

    @Override
    public boolean mouseDragged(InteractionContext context, double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.canScrollHorizontal && this.horizontalScrollBar.mouseDragged(context, mouseX, mouseY, button, deltaX, deltaY) || this.canScrollVertical && this.verticalScrollBar.mouseDragged(context, mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(context, this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(InteractionContext context, double mouseX, double mouseY, int button) {
        return this.canScrollHorizontal && this.horizontalScrollBar.mouseReleased(context, mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.mouseReleased(context, mouseX, mouseY, button) || super.mouseReleased(context, this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button);
    }

    @Override
    public boolean mouseScrolled(InteractionContext context, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.canScrollHorizontal && this.horizontalScrollBar.mouseScrolled(context, mouseX, mouseY, horizontalAmount, verticalAmount) || this.canScrollVertical && this.verticalScrollBar.mouseScrolled(context, mouseX, mouseY, horizontalAmount, verticalAmount) || super.mouseScrolled(context, this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), horizontalAmount, verticalAmount);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ScrollableFrame.class)
    public static class Builder {
        private boolean renderOutline = false;
        private Dim2i dim = null;
        private AbstractFrame frame = null;
        private AtomicReference<Integer> verticalScrollBarOffset = new AtomicReference<Integer>(0);
        private AtomicReference<Integer> horizontalScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean state) {
            this.renderOutline = state;
            return this;
        }

        public Builder setVerticalScrollBarOffset(AtomicReference<Integer> verticalScrollBarOffset) {
            this.verticalScrollBarOffset = verticalScrollBarOffset;
            return this;
        }

        public Builder setHorizontalScrollBarOffset(AtomicReference<Integer> horizontalScrollBarOffset) {
            this.horizontalScrollBarOffset = horizontalScrollBarOffset;
            return this;
        }

        public Builder setFrame(AbstractFrame frame) {
            this.frame = frame;
            return this;
        }

        public ScrollableFrame build() {
            return new ScrollableFrame(this.dim, this.frame, this.renderOutline, this.verticalScrollBarOffset, this.horizontalScrollBarOffset);
        }
    }
}

