/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.gui.options.TextProvider;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.AsyncOcclusionMode;
import org.taumc.celeritas.api.options.structure.OptionStorage;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={GraphicsQuality.class, NotificationSettings.class, QualitySettings.class, AdvancedSettings.class, PerformanceSettings.class})
public class SodiumGameOptions
implements OptionStorage<SodiumGameOptions> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_FILE_NAME = "embeddium-options.json";
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final PerformanceSettings performance = new PerformanceSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    private boolean readOnly;
    private Path configPath;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public static SodiumGameOptions defaults() {
        SodiumGameOptions options = new SodiumGameOptions();
        options.configPath = SodiumGameOptions.getConfigPath(DEFAULT_FILE_NAME);
        return options;
    }

    @Override
    public SodiumGameOptions getData() {
        return this;
    }

    @Override
    public void save() {
        try {
            this.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't save configuration changes", e);
        }
        LOGGER.info("Flushed changes to Embeddium configuration");
    }

    public static SodiumGameOptions load() {
        return SodiumGameOptions.load(DEFAULT_FILE_NAME);
    }

    public static SodiumGameOptions load(String name) {
        SodiumGameOptions config;
        Path path = SodiumGameOptions.getConfigPath(name);
        boolean resaveConfig = true;
        if (Files.exists(path, new LinkOption[0])) {
            try (FileReader reader = new FileReader(path.toFile());){
                config = (SodiumGameOptions)GSON.fromJson((Reader)reader, SodiumGameOptions.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse config", e);
            }
            catch (JsonSyntaxException e) {
                LOGGER.error("Could not parse config, will fallback to default settings", (Throwable)e);
                config = new SodiumGameOptions();
                resaveConfig = false;
            }
        } else {
            config = new SodiumGameOptions();
        }
        config.configPath = path;
        config.notifications.forceDisableDonationPrompts = false;
        try {
            if (resaveConfig) {
                config.writeChanges();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    private static Path getConfigPath(String name) {
        return Paths.get("config", name);
    }

    @Deprecated
    public void writeChanges() throws IOException {
        SodiumGameOptions.writeToDisk(this);
    }

    public static void writeToDisk(SodiumGameOptions config) throws IOException {
        if (config.isReadOnly()) {
            throw new IllegalStateException("Config file is read-only");
        }
        Path dir = config.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException(SodiumGameOptions.jvmdowngrader$concat$writeToDisk$1(String.valueOf(dir)));
        }
        Path tempPath = config.configPath.resolveSibling(SodiumGameOptions.jvmdowngrader$concat$writeToDisk$2(String.valueOf(config.configPath.getFileName())));
        J_N_F_Files.writeString((Path)tempPath, (CharSequence)GSON.toJson((Object)config), (OpenOption[])new OpenOption[0]);
        Files.move(tempPath, config.configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String getFileName() {
        return this.configPath.getFileName().toString();
    }

    private static /* synthetic */ String jvmdowngrader$concat$writeToDisk$1(String string) {
        return "Not a directory: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$writeToDisk$2(String string) {
        return string + ".tmp";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=SodiumGameOptions.class)
    public static class QualitySettings {
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality leavesQuality = GraphicsQuality.DEFAULT;
        public boolean enableVignette = true;
        @SerializedName(value="use_quad_normals_for_shading_v2")
        public boolean useQuadNormalsForShading = true;
        public int chunkFadeInDuration = 0;
        public int legacyBiomeBlendRadius = 0;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=SodiumGameOptions.class)
    public static class AdvancedSettings {
        public boolean enableMemoryTracing = false;
        public boolean useAdvancedStagingBuffers = true;
        public boolean disableIncompatibleModWarnings = false;
        public int cpuRenderAheadLimit = 3;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=SodiumGameOptions.class)
    public static class PerformanceSettings {
        public int chunkBuilderThreads = 0;
        @SerializedName(value="always_defer_chunk_updates_v2")
        public boolean alwaysDeferChunkUpdates = true;
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useBlockFaceCulling = true;
        public boolean useCompactVertexFormat = false;
        @SerializedName(value="use_translucent_face_sorting_v2")
        public boolean useTranslucentFaceSorting = true;
        public boolean useRenderPassOptimization = true;
        public boolean useRenderPassConsolidation = true;
        public boolean useFasterClouds = true;
        public boolean useNoErrorGLContext = true;
        public AsyncOcclusionMode asyncOcclusionMode = AsyncOcclusionMode.ONLY_SHADOW;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=SodiumGameOptions.class)
    public static class NotificationSettings {
        public boolean forceDisableDonationPrompts = false;
        public boolean hasClearedDonationButton = false;
        public boolean hasSeenDonationPrompt = false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=SodiumGameOptions.class)
    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT(J_U_List.of((Object)"options.gamma.default", (Object)"generator.default")),
        FANCY("options.clouds.fancy"),
        FAST("options.clouds.fast");

        private final TextComponent name;

        private GraphicsQuality(String name) {
            this.name = TextComponent.translatable(name, new Object[0]);
        }

        private GraphicsQuality(List<String> names) {
            this.name = TextComponent.translatable(names, new Object[0]);
        }

        @Override
        public TextComponent getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(boolean fancyGraphics) {
            return this == FANCY || this == DEFAULT && fancyGraphics;
        }
    }
}

