/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.tessellation;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeBinding;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.gl.tessellation.TessellationBinding;

public abstract class GlAbstractTessellation
implements GlTessellation {
    protected final TessellationBinding[] bindings;

    protected GlAbstractTessellation(TessellationBinding[] bindings) {
        this.bindings = bindings;
    }

    protected void bindAttributes(CommandList commandList) {
        for (TessellationBinding binding : this.bindings) {
            commandList.bindBuffer(binding.target(), binding.buffer());
            for (GlVertexAttributeBinding attrib : binding.attributeBindings()) {
                if (attrib.isIntType()) {
                    LWJGLServiceProvider.LWJGL.glVertexAttribIPointer(attrib.getIndex(), attrib.getCount(), attrib.getFormat().typeId(), attrib.getStride(), attrib.getPointer());
                } else {
                    LWJGLServiceProvider.LWJGL.glVertexAttribPointer(attrib.getIndex(), attrib.getCount(), attrib.getFormat().typeId(), attrib.isNormalized(), attrib.getStride(), attrib.getPointer());
                }
                LWJGLServiceProvider.LWJGL.glEnableVertexAttribArray(attrib.getIndex());
            }
        }
    }
}

