/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.sync;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import com.mitchej123.lwjgl.MemoryStack;
import java.nio.IntBuffer;

public class GlFence {
    private final long id;
    private boolean disposed;

    public GlFence(long id) {
        this.id = id;
    }

    public boolean isCompleted() {
        int result;
        this.checkDisposed();
        try (MemoryStack stack = LWJGLServiceProvider.LWJGL.stackPush();){
            IntBuffer count = stack.callocInt(1);
            result = LWJGLServiceProvider.LWJGL.glGetSynci(this.id, 37140, count);
            if (count.get(0) != 1) {
                throw new RuntimeException("glGetSync returned more than one value");
            }
        }
        return result == 37145;
    }

    public void sync() {
        this.checkDisposed();
        this.sync(Long.MAX_VALUE);
    }

    public void sync(long timeout) {
        this.checkDisposed();
        LWJGLServiceProvider.LWJGL.glWaitSync(this.id, 1, timeout);
    }

    public void delete() {
        LWJGLServiceProvider.LWJGL.glDeleteSync(this.id);
        this.disposed = true;
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Fence object has been disposed");
        }
    }
}

