/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.functions;

import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLServiceProvider;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferStorageFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferTarget;
import org.embeddedt.embeddium.impl.gl.util.EnumBitField;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@PermittedSubClasses(value={1.class, 2.class, 3.class})
@NestMembers(value={3.class, 2.class, 1.class})
public enum BufferStorageFunctions {
    NONE{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CORE{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            LWJGLServiceProvider.LWJGL.glBufferStorage(target.getTargetParameter(), length, flags.getBitField());
        }
    }
    ,
    ARB{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            LWJGLServiceProvider.LWJGL.glBufferStorage(target.getTargetParameter(), length, flags.getBitField());
        }
    };


    public static BufferStorageFunctions pickBest() {
        if (LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(4, 4)) {
            return CORE;
        }
        if (LWJGLServiceProvider.LWJGL.isExtensionSupported(GLExtension.ARB_buffer_storage)) {
            return ARB;
        }
        return NONE;
    }

    public abstract void createBufferStorage(GlBufferTarget var1, long var2, EnumBitField<GlBufferStorageFlags> var4);
}

