/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.functions;

import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLServiceProvider;
import org.embeddedt.embeddium.impl.gl.buffer.GlBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferTarget;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@PermittedSubClasses(value={1.class, 2.class})
@NestMembers(value={2.class, 1.class})
public enum BufferCopyFunctions {
    CORE{

        @Override
        public void copyBufferSubData(CommandList commandList, GlBuffer src, GlBuffer dst, long readOffset, long writeOffset, long bytes) {
            commandList.bindBuffer(GlBufferTarget.COPY_READ_BUFFER, src);
            commandList.bindBuffer(GlBufferTarget.COPY_WRITE_BUFFER, dst);
            LWJGLServiceProvider.LWJGL.glCopyBufferSubData(36662, 36663, readOffset, writeOffset, bytes);
        }
    }
    ,
    PIXEL_PACK{

        @Override
        public void copyBufferSubData(CommandList commandList, GlBuffer src, GlBuffer dst, long readOffset, long writeOffset, long bytes) {
            if (src.getActiveMapping() != null || dst.getActiveMapping() != null) {
                throw new IllegalStateException("Cannot use PIXEL_PACK copy strategy on mapped buffers");
            }
            commandList.bindBuffer(GlBufferTarget.PIXEL_PACK_BUFFER, src);
            commandList.bindBuffer(GlBufferTarget.PIXEL_UNPACK_BUFFER, dst);
            long srcBufPtr = LWJGLServiceProvider.LWJGL.nglMapBuffer(GlBufferTarget.PIXEL_PACK_BUFFER.getTargetParameter(), 35000);
            if (srcBufPtr == 0L) {
                throw new IllegalStateException("Source buffer could not be mapped");
            }
            long dstBufPtr = LWJGLServiceProvider.LWJGL.nglMapBuffer(GlBufferTarget.PIXEL_UNPACK_BUFFER.getTargetParameter(), 35001);
            if (dstBufPtr == 0L) {
                throw new IllegalStateException("Destination buffer could not be mapped");
            }
            LWJGLServiceProvider.LWJGL.memCopy(srcBufPtr + readOffset, dstBufPtr + writeOffset, bytes);
            LWJGLServiceProvider.LWJGL.glUnmapBuffer(GlBufferTarget.PIXEL_PACK_BUFFER.getTargetParameter());
            LWJGLServiceProvider.LWJGL.glUnmapBuffer(GlBufferTarget.PIXEL_UNPACK_BUFFER.getTargetParameter());
            commandList.bindBuffer(GlBufferTarget.PIXEL_PACK_BUFFER, null);
            commandList.bindBuffer(GlBufferTarget.PIXEL_UNPACK_BUFFER, null);
        }
    };


    public abstract void copyBufferSubData(CommandList var1, GlBuffer var2, GlBuffer var3, long var4, long var6, long var8);

    public static BufferCopyFunctions pickBest() {
        if (LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(3, 1) || LWJGLServiceProvider.LWJGL.isExtensionSupported(GLExtension.ARB_copy_buffer)) {
            return CORE;
        }
        return PIXEL_PACK;
    }
}

