/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.device;

import com.mitchej123.lwjgl.LWJGLServiceProvider;

public final class MultiDrawBatch {
    public final long pElementPointer;
    public final long pElementCount;
    public final long pBaseVertex;
    private final int capacity;
    public int size;

    public MultiDrawBatch(int capacity) {
        this.pElementPointer = LWJGLServiceProvider.LWJGL.nmemAlignedAlloc(32L, (long)capacity * (long)LWJGLServiceProvider.POINTER_SIZE);
        if (this.pElementPointer == 0L) {
            throw new OutOfMemoryError("Failed to allocate element pointer array");
        }
        LWJGLServiceProvider.LWJGL.memSet(this.pElementPointer, 0, (long)capacity * (long)LWJGLServiceProvider.POINTER_SIZE);
        this.pElementCount = LWJGLServiceProvider.LWJGL.nmemAlignedAlloc(32L, (long)capacity * 4L);
        if (this.pElementCount == 0L) {
            LWJGLServiceProvider.LWJGL.nmemAlignedFree(this.pElementPointer);
            throw new OutOfMemoryError("Failed to allocate element count array");
        }
        this.pBaseVertex = LWJGLServiceProvider.LWJGL.nmemAlignedAlloc(32L, (long)capacity * 4L);
        if (this.pBaseVertex == 0L) {
            LWJGLServiceProvider.LWJGL.nmemAlignedFree(this.pElementPointer);
            LWJGLServiceProvider.LWJGL.nmemAlignedFree(this.pElementCount);
            throw new OutOfMemoryError("Failed to allocate base vertex array");
        }
        this.capacity = capacity;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        this.size = 0;
    }

    public void delete() {
        LWJGLServiceProvider.LWJGL.nmemAlignedFree(this.pElementPointer);
        LWJGLServiceProvider.LWJGL.nmemAlignedFree(this.pElementCount);
        LWJGLServiceProvider.LWJGL.nmemAlignedFree(this.pBaseVertex);
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public int getIndexBufferSize() {
        int elements = 0;
        for (int index = 0; index < this.size; ++index) {
            elements = Math.max(elements, LWJGLServiceProvider.LWJGL.memGetInt(this.pElementCount + (long)index * 4L));
        }
        return elements;
    }
}

