/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.debug;

import com.mitchej123.lwjgl.DebugExtension;
import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.io.PrintStream;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={UnsupportedDebugState.class, KHRDebugState.class, DebugState.class, 1.class})
public final class GLDebug {
    static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/GLDebug");
    private static DebugState debugState = new UnsupportedDebugState();

    public static int setupDebugMessageCallback() {
        GLDebug.reloadDebugState();
        return GLDebug.setupDebugMessageCallback(LWJGLServiceProvider.LWJGL.getDebugStream());
    }

    private static void trace(Consumer<String> output) {
        StackTraceElement[] elems;
        for (StackTraceElement ste : elems = GLDebug.filterStackTrace(new Throwable(), 4).getStackTrace()) {
            output.accept(ste.toString());
        }
    }

    public static Throwable filterStackTrace(Throwable throwable, int offset) {
        StackTraceElement[] elems = throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        throwable.setStackTrace(newElems);
        return throwable;
    }

    private static void printTrace(final PrintStream stream) {
        GLDebug.trace(new Consumer<String>(){
            boolean first = true;

            @Override
            public void accept(String str) {
                if (this.first) {
                    GLDebug.printDetail(stream, "Stacktrace", str);
                    this.first = false;
                } else {
                    GLDebug.printDetailLine(stream, "Stacktrace", str);
                }
            }
        });
    }

    public static int setupDebugMessageCallback(PrintStream stream) {
        return LWJGLServiceProvider.LWJGL.setupDebugCallback((source, type, id, severity, message, extension) -> {
            if (extension == DebugExtension.AMD_DEBUG_OUTPUT) {
                stream.println("[LWJGL] AMD_debug_output message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Category", GLDebug.getCategoryAMD(source));
                GLDebug.printDetail(stream, "Severity", GLDebug.getSeverityAMD(severity));
                GLDebug.printDetail(stream, "Message", message);
            } else if (extension == DebugExtension.ARB_DEBUG_OUTPUT) {
                stream.println("[LWJGL] ARB_debug_output message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getSourceARB(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getTypeARB(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getSeverityARB(severity));
                GLDebug.printDetail(stream, "Message", message);
            } else {
                stream.println("[LWJGL] OpenGL debug message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getDebugSource(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getDebugType(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getDebugSeverity(severity));
                GLDebug.printDetail(stream, "Message", message);
            }
            GLDebug.printTrace(stream);
        });
    }

    public static int disableDebugMessages() {
        LWJGLServiceProvider.LWJGL.disableDebugCallback();
        return 1;
    }

    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("\t%s: %s\n", type, message);
    }

    private static void printDetailLine(PrintStream stream, String type, String message) {
        stream.append("    ");
        for (int i = 0; i < type.length(); ++i) {
            stream.append(" ");
        }
        stream.append(message).append("\n");
    }

    private static String unknownToken(int token) {
        return GLDebug.jvmdowngrader$concat$unknownToken$1(Integer.toHexString(token).toUpperCase());
    }

    private static String getDebugSource(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = GLDebug.unknownToken(source);
            }
        }
        return string;
    }

    private static String getDebugType(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            case 33384: {
                string = "MARKER";
                break;
            }
            default: {
                string = GLDebug.unknownToken(type);
            }
        }
        return string;
    }

    private static String getDebugSeverity(int severity) {
        String string;
        switch (severity) {
            case 33387: {
                string = "NOTIFICATION";
                break;
            }
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = GLDebug.unknownToken(severity);
            }
        }
        return string;
    }

    private static String getSourceARB(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = GLDebug.unknownToken(source);
            }
        }
        return string;
    }

    private static String getTypeARB(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            default: {
                string = GLDebug.unknownToken(type);
            }
        }
        return string;
    }

    private static String getSeverityARB(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = GLDebug.unknownToken(severity);
            }
        }
        return string;
    }

    private static String getCategoryAMD(int category) {
        String string;
        switch (category) {
            case 37193: {
                string = "API ERROR";
                break;
            }
            case 37194: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 37195: {
                string = "DEPRECATION";
                break;
            }
            case 37196: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 37197: {
                string = "PERFORMANCE";
                break;
            }
            case 37198: {
                string = "SHADER COMPILER";
                break;
            }
            case 37199: {
                string = "APPLICATION";
                break;
            }
            case 37200: {
                string = "OTHER";
                break;
            }
            default: {
                string = GLDebug.unknownToken(category);
            }
        }
        return string;
    }

    private static String getSeverityAMD(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = GLDebug.unknownToken(severity);
            }
        }
        return string;
    }

    public static void reloadDebugState() {
        debugState = Boolean.getBoolean("celeritas.enableGLDebug") && (LWJGLServiceProvider.LWJGL.isExtensionSupported(GLExtension.KHR_debug) || LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(4, 3)) ? new KHRDebugState() : new UnsupportedDebugState();
    }

    public static void nameObject(int id, int object, String name) {
        debugState.nameObject(id, object, name);
    }

    public static void pushGroup(int id, String name) {
        debugState.pushGroup(id, name);
    }

    public static void popGroup() {
        debugState.popGroup();
    }

    private static /* synthetic */ String jvmdowngrader$concat$unknownToken$1(String string) {
        return "Unknown (0x" + string + ")";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GLDebug.class)
    private static class KHRDebugState
    implements DebugState {
        private static final boolean ENABLE_DEBUG_GROUPS = true;
        private int stackSize;

        KHRDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
            LWJGLServiceProvider.LWJGL.glObjectLabel(id, object, name);
        }

        @Override
        public void pushGroup(int id, String name) {
            LWJGLServiceProvider.LWJGL.glPushDebugGroup(33354, id, name);
            ++this.stackSize;
        }

        @Override
        public void popGroup() {
            if (this.stackSize != 0) {
                LWJGLServiceProvider.LWJGL.glPopDebugGroup();
                --this.stackSize;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GLDebug.class)
    private static interface DebugState {
        public void nameObject(int var1, int var2, String var3);

        public void pushGroup(int var1, String var2);

        public void popGroup();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GLDebug.class)
    private static class UnsupportedDebugState
    implements DebugState {
        UnsupportedDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
        }

        @Override
        public void pushGroup(int id, String name) {
        }

        @Override
        public void popGroup() {
        }
    }
}

