/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.custom;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kroppeb.stareval.element.ExpressionElement;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.expression.VariableExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.parser.Parser;
import kroppeb.stareval.resolver.ExpressionResolver;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.uniform.LocationalUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.parsing.IrisFunctions;
import net.coderbot.iris.parsing.IrisOptions;
import net.coderbot.iris.parsing.VectorType;
import net.coderbot.iris.uniforms.custom.CustomUniformFixedInputUniformsHolder;
import net.coderbot.iris.uniforms.custom.cached.CachedUniform;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Builder.class, Builder.Variable.class})
public class CustomUniforms
implements FunctionContext {
    private final Map<String, CachedUniform> variables = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, Expression> variablesExpressions = new Object2ObjectLinkedOpenHashMap();
    private final CustomUniformFixedInputUniformsHolder inputHolder;
    private final List<CachedUniform> uniformOrder;
    private final Map<Object, Object2IntMap<CachedUniform>> locationMap = new Object2ObjectOpenHashMap();
    private final Map<CachedUniform, List<CachedUniform>> dependsOn;

    CustomUniforms(CustomUniformFixedInputUniformsHolder inputHolder, Map<String, Builder.Variable> variables) {
        this.inputHolder = inputHolder;
        ExpressionResolver resolver = new ExpressionResolver(IrisFunctions.functions, name -> {
            Type type = this.inputHolder.getType((String)name);
            if (type != null) {
                return type;
            }
            Builder.Variable variable = (Builder.Variable)((Object)((Object)variables.get(name)));
            if (variable != null) {
                return variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$type();
            }
            return null;
        }, true);
        for (Builder.Variable variable : variables.values()) {
            try {
                Expression expression = resolver.resolveExpression(variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$type(), variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$expression());
                CachedUniform cachedUniform = CachedUniform.forExpression(variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$name(), variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$type(), expression, this);
                this.addVariable(expression, cachedUniform);
                if (!variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$uniform()) continue;
                ArrayList<CachedUniform> uniforms = new ArrayList<CachedUniform>();
                uniforms.add(cachedUniform);
            }
            catch (Exception e) {
                Iris.logger.warn(CustomUniforms.jvmdowngrader$concat$$init$$1(variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$name(), e.getMessage(), String.valueOf(variable.jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$expression())), e);
            }
        }
        this.dependsOn = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap requiredBy = new Object2ObjectOpenHashMap();
        Object2IntOpenHashMap dependsOnCount = new Object2IntOpenHashMap();
        for (CachedUniform input : this.inputHolder.getAll()) {
            requiredBy.put(input, new ObjectArrayList());
        }
        for (CachedUniform input : this.variables.values()) {
            requiredBy.put(input, new ObjectArrayList());
        }
        FunctionReturn functionReturn = new FunctionReturn();
        ObjectOpenHashSet requires = new ObjectOpenHashSet();
        ObjectOpenHashSet brokenUniforms = new ObjectOpenHashSet();
        for (Map.Entry<String, Expression> entry2 : this.variablesExpressions.entrySet()) {
            requires.clear();
            entry2.getValue().listVariables((Collection<? super VariableExpression>)requires);
            if (requires.isEmpty()) continue;
            CachedUniform uniform = this.variables.get(entry2.getKey());
            ArrayList<CachedUniform> dependencies = new ArrayList<CachedUniform>();
            for (VariableExpression v : requires) {
                Expression evaluated = v.partialEval(this, functionReturn);
                if (evaluated instanceof CachedUniform) {
                    dependencies.add((CachedUniform)evaluated);
                    continue;
                }
                brokenUniforms.add(uniform);
            }
            if (dependencies.isEmpty()) continue;
            this.dependsOn.put(uniform, dependencies);
            dependsOnCount.put((Object)uniform, dependencies.size());
            for (CachedUniform dependency : dependencies) {
                ((List)requiredBy.get(dependency)).add(uniform);
            }
        }
        ObjectArrayList ordered = new ObjectArrayList();
        ObjectArrayList free = new ObjectArrayList();
        for (CachedUniform entry3 : requiredBy.keySet()) {
            if (dependsOnCount.containsKey((Object)entry3)) continue;
            free.add(entry3);
        }
        while (!free.isEmpty()) {
            CachedUniform pop = (CachedUniform)free.remove(free.size() - 1);
            if (!brokenUniforms.contains(pop)) {
                ordered.add(pop);
            } else {
                brokenUniforms.addAll((Collection)requiredBy.get(pop));
            }
            for (CachedUniform dependent : (List)requiredBy.get(pop)) {
                int count = dependsOnCount.mergeInt((Object)dependent, -1, Integer::sum);
                assert (count >= 0);
                if (count != 0) continue;
                free.add(dependent);
                dependsOnCount.removeInt((Object)dependent);
            }
        }
        if (!brokenUniforms.isEmpty()) {
            Iris.logger.warn(CustomUniforms.jvmdowngrader$concat$$init$$1(brokenUniforms.stream().map(CachedUniform::getName).collect(Collectors.joining(", "))));
        }
        if (!dependsOnCount.isEmpty()) {
            throw new IllegalStateException(CustomUniforms.jvmdowngrader$concat$$init$$2(dependsOnCount.object2IntEntrySet().stream().map(entry -> CustomUniforms.jvmdowngrader$concat$lambda$new$1$1(((CachedUniform)entry.getKey()).getName(), entry.getIntValue())).collect(Collectors.joining(", "))));
        }
        this.uniformOrder = ordered;
    }

    private void addVariable(Expression expression, CachedUniform uniform) throws Exception {
        String name = uniform.getName();
        if (this.variables.containsKey(name)) {
            throw new Exception(CustomUniforms.jvmdowngrader$concat$addVariable$1(name));
        }
        if (this.inputHolder.containsKey(name)) {
            throw new Exception(CustomUniforms.jvmdowngrader$concat$addVariable$2(name));
        }
        this.variables.put(name, uniform);
        this.variablesExpressions.put(name, expression);
    }

    public void assignTo(LocationalUniformHolder targetHolder) {
        Object2IntOpenHashMap locations = new Object2IntOpenHashMap();
        for (CachedUniform uniform : this.uniformOrder) {
            try {
                OptionalInt location = targetHolder.location(uniform.getName(), Type.convert(uniform.getType()));
                if (!location.isPresent()) continue;
                locations.put((Object)uniform, location.getAsInt());
            }
            catch (Exception e) {
                throw new RuntimeException(uniform.getName(), e);
            }
        }
        this.locationMap.put(targetHolder, (Object2IntMap<CachedUniform>)locations);
    }

    public void mapholderToPass(LocationalUniformHolder holder, Object pass) {
        this.locationMap.put(pass, this.locationMap.remove(holder));
    }

    public void update() {
        for (CachedUniform value : this.uniformOrder) {
            value.update();
        }
    }

    public void push(Object pass) {
        Object2IntMap<CachedUniform> uniforms = this.locationMap.get(pass);
        if (uniforms != null) {
            uniforms.forEach(CachedUniform::pushIfChanged);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void optimise() {
        void var3_7;
        Object2IntOpenHashMap dependedByCount = new Object2IntOpenHashMap();
        for (List<CachedUniform> list : this.dependsOn.values()) {
            for (CachedUniform dependency : list) {
                dependedByCount.mergeInt((Object)dependency, 1, Integer::sum);
            }
        }
        for (Object2IntMap object2IntMap : this.locationMap.values()) {
            for (CachedUniform cachedUniform : object2IntMap.keySet()) {
                dependedByCount.mergeInt((Object)cachedUniform, 1, Integer::sum);
            }
        }
        ObjectOpenHashSet unused = new ObjectOpenHashSet();
        int n = this.uniformOrder.size() - 1;
        while (var3_7 >= 0) {
            CachedUniform uniform = this.uniformOrder.get((int)var3_7);
            if (!dependedByCount.containsKey((Object)uniform)) {
                unused.add(uniform);
                List<CachedUniform> dependencies = this.dependsOn.get(uniform);
                if (dependencies != null) {
                    for (CachedUniform dependency : dependencies) {
                        dependedByCount.computeIntIfPresent((Object)dependency, (key, value) -> value - 1);
                    }
                }
            }
            --var3_7;
        }
        this.uniformOrder.removeAll((Collection<?>)unused);
    }

    @Override
    public boolean hasVariable(String name) {
        return this.inputHolder.containsKey(name) || this.variables.containsKey(name);
    }

    @Override
    public Expression getVariable(String name) {
        CachedUniform inputUniform = this.inputHolder.getUniform(name);
        if (inputUniform != null) {
            return inputUniform;
        }
        CachedUniform customUniform = this.variables.get(name);
        if (customUniform != null) {
            return customUniform;
        }
        throw new RuntimeException(CustomUniforms.jvmdowngrader$concat$getVariable$1(name));
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, String string2, String string3) {
        return "Failed to resolve uniform " + string + ", reason: " + string2 + " ( = " + string3 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
        return "The following uniforms won't work, either because they are broken, or reference a broken uniform: \n" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$2(String string) {
        return "Circular reference detected between: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addVariable$1(String string) {
        return "Duplicated variable: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addVariable$2(String string) {
        return "Variable shadows build in uniform: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getVariable$1(String string) {
        return "Unknown variable: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$1$1(String string, int n) {
        return string + " (" + n + ")";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=CustomUniforms.class)
    public static class Builder {
        private static final Map<String, Type> types = new ImmutableMap.Builder().put((Object)"bool", (Object)Type.Boolean).put((Object)"float", (Object)Type.Float).put((Object)"int", (Object)Type.Int).put((Object)"vec2", VectorType.VEC2).put((Object)"vec3", VectorType.VEC3).put((Object)"vec4", VectorType.VEC4).build();
        final Map<String, Variable> variables = new Object2ObjectLinkedOpenHashMap();

        public void addVariable(String type, String name, String expression, boolean isUniform) {
            if (this.variables.containsKey(name)) {
                Iris.logger.warn(Builder.jvmdowngrader$concat$addVariable$1(name));
                return;
            }
            Type parsedType = types.get(type);
            if (parsedType == null) {
                Iris.logger.warn(Builder.jvmdowngrader$concat$addVariable$1(type, name));
                return;
            }
            try {
                ExpressionElement ast = Parser.parse(expression, IrisOptions.options);
                this.variables.put(name, new Variable(parsedType, name, ast, isUniform));
            }
            catch (Exception e) {
                Iris.logger.warn(Builder.jvmdowngrader$concat$addVariable$2(name, expression), e);
            }
        }

        public CustomUniforms build(CustomUniformFixedInputUniformsHolder inputHolder) {
            return new CustomUniforms(inputHolder, this.variables);
        }

        @SafeVarargs
        public final CustomUniforms build(Consumer<UniformHolder> ... uniforms) {
            CustomUniformFixedInputUniformsHolder.Builder inputs = new CustomUniformFixedInputUniformsHolder.Builder();
            for (Consumer<UniformHolder> uniform : uniforms) {
                uniform.accept(inputs);
            }
            return this.build(inputs.build());
        }

        private static /* synthetic */ String jvmdowngrader$concat$addVariable$1(String string) {
            return "Ignoring duplicated custom uniform name: " + string;
        }

        private static /* synthetic */ String jvmdowngrader$concat$addVariable$1(String string, String string2) {
            return "Ignoring invalid uniform type: " + string + " of " + string2;
        }

        private static /* synthetic */ String jvmdowngrader$concat$addVariable$2(String string, String string2) {
            return "Failed to parse custom variable/uniform " + string + " with expression " + string2;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @RecordComponents(value={@RecordComponents.Value(name="type", type=Type.class), @RecordComponents.Value(name="name", type=String.class), @RecordComponents.Value(name="expression", type=ExpressionElement.class), @RecordComponents.Value(name="uniform", type=boolean.class)})
        @NestHost(value=CustomUniforms.class)
        private static final class Variable
        extends J_L_Record {
            private final Type type;
            private final String name;
            private final ExpressionElement expression;
            private final boolean uniform;

            Variable(Type type, String name, ExpressionElement expression, boolean uniform) {
                this.type = type;
                this.name = name;
                this.expression = expression;
                this.uniform = uniform;
            }

            public final String toString() {
                return Variable.jvmdowngrader$toString$toString(this);
            }

            public final int hashCode() {
                return Variable.jvmdowngrader$hashCode$hashCode(this);
            }

            public final boolean equals(Object o) {
                return Variable.jvmdowngrader$equals$equals(this, o);
            }

            public Type type() {
                return this.type;
            }

            public String name() {
                return this.name;
            }

            public ExpressionElement expression() {
                return this.expression;
            }

            public boolean uniform() {
                return this.uniform;
            }

            private static /* synthetic */ String jvmdowngrader$toString$toString(Variable variable) {
                Variable variable2 = variable;
                return "CustomUniforms$Builder$Variable[" + "type=" + variable.type + ", " + "name=" + variable.name + ", " + "expression=" + variable.expression + ", " + "uniform=" + variable.uniform + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(Variable variable) {
                Object[] objectArray = new Object[]{variable.type, variable.name, variable.expression, variable.uniform};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals$equals(Variable variable, Object object) {
                if (variable == object) {
                    return true;
                }
                if (object != null && object instanceof Variable) {
                    Variable variable2 = (Variable)((Object)object);
                    if (Objects.equals(variable.type, variable2.type) && Objects.equals(variable.name, variable2.name) && Objects.equals(variable.expression, variable2.expression) && variable.uniform == variable2.uniform) {
                        return true;
                    }
                }
                return false;
            }

            public /* synthetic */ String jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$name() {
                return this.name;
            }

            public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$set$name(String string) {
                this.name = string;
            }

            public /* synthetic */ boolean jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$uniform() {
                return this.uniform;
            }

            public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$set$uniform(boolean bl) {
                this.uniform = bl;
            }

            public /* synthetic */ ExpressionElement jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$expression() {
                return this.expression;
            }

            public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$set$expression(ExpressionElement expressionElement) {
                this.expression = expressionElement;
            }

            public /* synthetic */ Type jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$get$type() {
                return this.type;
            }

            public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_uniforms_custom_CustomUniforms$Builder$Variable$set$type(Type type) {
                this.type = type;
            }
        }
    }
}

