/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemMaterialHelper {
    private static final Reference2ObjectMap<Item, Int2IntMap> MATERIAL_CACHE = new Reference2ObjectOpenHashMap();
    private static final int CACHE_MISS_SENTINEL = Integer.MIN_VALUE;
    public static final IntSet WARNED_UNKNOWN_ARMOR_INDICES = new IntOpenHashSet();

    public static int getMaterialId(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return -1;
        }
        return ItemMaterialHelper.getMaterialId(itemStack.func_77973_b(), itemStack.func_77960_j());
    }

    public static int getMaterialId(Item item, int metadata) {
        int cached;
        if (item == null) {
            return -1;
        }
        Int2IntMap metadataCache = (Int2IntMap)MATERIAL_CACHE.get((Object)item);
        if (metadataCache != null && (cached = metadataCache.getOrDefault(metadata, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            return cached;
        }
        int materialId = ItemMaterialHelper.lookupMaterialId(item, metadata);
        if (metadataCache == null) {
            metadataCache = new Int2IntOpenHashMap();
            metadataCache.defaultReturnValue(Integer.MIN_VALUE);
            MATERIAL_CACHE.put((Object)item, (Object)metadataCache);
        }
        metadataCache.put(metadata, materialId);
        return materialId;
    }

    private static int lookupMaterialId(Item item, int metadata) {
        String itemIdString;
        Object2IntFunction<NamespacedId> itemIds;
        if (item instanceof ItemBlock) {
            int id;
            Int2IntMap metaMap;
            Reference2ObjectMap<Block, Int2IntMap> blockMetaMatches;
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.field_150939_a;
            if (block != null && (blockMetaMatches = BlockRenderingSettings.INSTANCE.getBlockMetaMatches()) != null && (metaMap = (Int2IntMap)blockMetaMatches.get((Object)block)) != null && (id = metaMap.get(itemBlock.func_77647_b(metadata))) != -1) {
                return id;
            }
        }
        if ((itemIds = BlockRenderingSettings.INSTANCE.getItemIds()) != null && (itemIdString = Item.field_150901_e.func_148750_c((Object)item)) != null) {
            ResourceLocation itemId = new ResourceLocation(itemIdString);
            return itemIds.applyAsInt((Object)new NamespacedId(itemId.func_110624_b(), itemId.func_110623_a()));
        }
        return -1;
    }

    public static void clearCache() {
        MATERIAL_CACHE.clear();
        WARNED_UNKNOWN_ARMOR_INDICES.clear();
    }
}

