/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;

public final class EntityIdHelper {
    private static final NamespacedId CONVERTING_VILLAGER = new NamespacedId("minecraft", "zombie_villager_converting");
    private static final NamespacedId CURRENT_PLAYER = new NamespacedId("minecraft", "current_player");
    private static final NamespacedId LIGHTNING_BOLT_ID = new NamespacedId("minecraft", "lightning_bolt");
    private static final Object2IntMap<Class<?>> entityIdCache = new Object2IntOpenHashMap();
    private static Object2IntFunction<NamespacedId> cachedEntityIdMap;

    private EntityIdHelper() {
    }

    public static int getEntityId(Entity entity) {
        Object2IntFunction<NamespacedId> entityIdMap = BlockRenderingSettings.INSTANCE.getEntityIds();
        if (entityIdMap == null) {
            return -1;
        }
        if (entityIdMap != cachedEntityIdMap) {
            entityIdCache.clear();
            cachedEntityIdMap = entityIdMap;
        }
        int normalId = EntityIdHelper.getNormalEntityId(entity, entityIdMap);
        int specialId = EntityIdHelper.getSpecialEntityId(entity, entityIdMap);
        if (specialId != -1) {
            return specialId;
        }
        return normalId;
    }

    private static int getSpecialEntityId(Entity entity, Object2IntFunction<NamespacedId> entityIdMap) {
        EntityZombie zombie;
        int currentPlayerId;
        EntityLivingBase cameraEntity = Minecraft.func_71410_x().field_71451_h;
        if (entity == cameraEntity && entity instanceof EntityPlayer && (currentPlayerId = entityIdMap.applyAsInt((Object)CURRENT_PLAYER)) != -1) {
            return currentPlayerId;
        }
        if (entity instanceof EntityZombie && (zombie = (EntityZombie)entity).func_82230_o()) {
            return entityIdMap.applyAsInt((Object)CONVERTING_VILLAGER);
        }
        return -1;
    }

    private static int getNormalEntityId(Entity entity, Object2IntFunction<NamespacedId> entityIdMap) {
        Class<?> entityClass = entity.getClass();
        int cached = entityIdCache.getInt(entityClass);
        if (cached != Integer.MIN_VALUE) {
            return cached;
        }
        int resolvedId = EntityIdHelper.resolveEntityId(entity, entityClass, entityIdMap);
        entityIdCache.put(entityClass, resolvedId);
        return resolvedId;
    }

    private static int resolveEntityId(Entity entity, Class<?> entityClass, Object2IntFunction<NamespacedId> entityIdMap) {
        String entityType = EntityList.func_75621_b((Entity)entity);
        if (entityType != null) {
            return entityIdMap.applyAsInt((Object)new NamespacedId(entityType));
        }
        String simpleClassName = entityClass.getSimpleName();
        int id = entityIdMap.applyAsInt((Object)new NamespacedId(simpleClassName));
        if (id == -1) {
            String className = entityClass.getName();
            id = entityIdMap.applyAsInt((Object)new NamespacedId(className));
        }
        if (id == -1 && entity instanceof EntityLightningBolt) {
            id = entityIdMap.applyAsInt((Object)LIGHTNING_BOLT_ID);
        }
        return id;
    }

    static {
        entityIdCache.defaultReturnValue(Integer.MIN_VALUE);
    }
}

