/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.gtnewhorizons.angelica.compat.iris.BiomeCategoryCache;
import com.gtnewhorizons.angelica.compat.iris.ModdedBiomeDetector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.parsing.BiomeCategories;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenEnd;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenMushroomIsland;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.biome.BiomeGenSavanna;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraft.world.biome.BiomeGenStoneBeach;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BiomeUniforms {
    private static final Logger LOGGER = LogManager.getLogger((String)"BiomeUniforms");
    private static final Minecraft client = Minecraft.func_71410_x();
    private static BiomeGenBase cachedBiome = null;
    private static long cachedWorldTime = -1L;
    private static int cachedPlayerX = Integer.MIN_VALUE;
    private static int cachedPlayerZ = Integer.MIN_VALUE;
    private static final Map<Class<? extends BiomeGenBase>, BiomeCategories> VANILLA_CLASS_MAP = BiomeUniforms.createVanillaClassMap();

    public static void addBiomeUniforms(UniformHolder uniforms) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "biome", BiomeUniforms::getBiomeId).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_category", BiomeUniforms::getBiomeCategory).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_precipitation", BiomeUniforms::getBiomePrecipitation).uniform1f(UniformUpdateFrequency.PER_TICK, "rainfall", BiomeUniforms::getBiomeRainfall).uniform1f(UniformUpdateFrequency.PER_TICK, "temperature", BiomeUniforms::getBiomeTemperature);
    }

    private static BiomeGenBase getCachedBiome() {
        if (BiomeUniforms.client.field_71439_g == null || BiomeUniforms.client.field_71441_e == null) {
            return null;
        }
        long worldTime = BiomeUniforms.client.field_71441_e.func_82737_E();
        int playerX = MathHelper.func_76128_c((double)BiomeUniforms.client.field_71439_g.field_70165_t);
        int playerZ = MathHelper.func_76128_c((double)BiomeUniforms.client.field_71439_g.field_70161_v);
        if (cachedBiome == null || cachedWorldTime != worldTime || cachedPlayerX != playerX || cachedPlayerZ != playerZ) {
            cachedBiome = BiomeUniforms.client.field_71441_e.func_72807_a(playerX, playerZ);
            cachedWorldTime = worldTime;
            cachedPlayerX = playerX;
            cachedPlayerZ = playerZ;
        }
        return cachedBiome;
    }

    public static int getBiomePrecipitation() {
        BiomeGenBase biome = BiomeUniforms.getCachedBiome();
        if (biome == null) {
            return 0;
        }
        if (!biome.field_76765_S && !biome.field_76766_R) {
            return 0;
        }
        float temp = biome.func_150564_a(MathHelper.func_76128_c((double)BiomeUniforms.client.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)BiomeUniforms.client.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)BiomeUniforms.client.field_71439_g.field_70161_v));
        return temp > 0.15f ? 1 : 2;
    }

    public static float getBiomeRainfall() {
        BiomeGenBase biome = BiomeUniforms.getCachedBiome();
        return biome != null ? biome.field_76751_G : 0.0f;
    }

    public static float getBiomeTemperature() {
        BiomeGenBase biome = BiomeUniforms.getCachedBiome();
        return biome != null ? biome.field_76750_F : 0.0f;
    }

    public static int getBiomeId() {
        BiomeGenBase biome = BiomeUniforms.getCachedBiome();
        return biome != null ? biome.field_76756_M : 0;
    }

    public static int getBiomeCategory() {
        BiomeGenBase biome = BiomeUniforms.getCachedBiome();
        if (biome == null) {
            return BiomeCategories.NONE.ordinal();
        }
        if (biome instanceof BiomeCategoryCache) {
            BiomeCategoryCache cache = (BiomeCategoryCache)biome;
            int cached = cache.iris$getCachedCategory();
            if (cached != -1) {
                return cached;
            }
            int category = BiomeUniforms.determineBiomeCategory(biome);
            cache.iris$setCachedCategory(category);
            BiomeCategories[] categories = BiomeCategories.values();
            String categoryName = category >= 0 && category < categories.length ? categories[category].name() : BiomeUniforms.jvmdowngrader$concat$getBiomeCategory$1(category);
            LOGGER.debug("Cached biome category for '{}': {}", new Object[]{biome.field_76791_y, categoryName});
            return category;
        }
        return BiomeUniforms.determineBiomeCategory(biome);
    }

    private static int determineBiomeCategory(BiomeGenBase biome) {
        BiomeGenBase lookupBiome = biome;
        if (biome instanceof BiomeGenMutated) {
            BiomeGenMutated mutated = (BiomeGenMutated)biome;
            if (mutated.field_150611_aD != null) {
                lookupBiome = mutated.field_150611_aD;
            }
        }
        BiomeCategories category = null;
        if (Arrays.asList(BiomeGenBase.func_150565_n()).contains(biome)) {
            category = BiomeUniforms.getVanillaBiomeCategory(lookupBiome.field_76756_M);
            if (category != null) {
                return category.ordinal();
            }
            if (BiomeDictionary.isBiomeRegistered((BiomeGenBase)biome)) {
                category = BiomeUniforms.detectBiomeByBiomeDictionary(biome);
            }
        }
        if (category != null) {
            return category.ordinal();
        }
        category = BiomeUniforms.detectVanillaBiomeByClass(biome);
        if (category != null) {
            return category.ordinal();
        }
        category = BiomeUniforms.detectModdedBiome(biome);
        if (category != null) {
            return category.ordinal();
        }
        category = BiomeUniforms.detectBiomeByName(biome);
        if (category != null) {
            return category.ordinal();
        }
        category = BiomeUniforms.detectBiomeByProperties(biome);
        if (category != null) {
            return category.ordinal();
        }
        return BiomeCategories.NONE.ordinal();
    }

    private static BiomeCategories getVanillaBiomeCategory(int biomeID) {
        BiomeCategories biomeCategories;
        switch (biomeID) {
            case 0: 
            case 10: 
            case 24: {
                biomeCategories = BiomeCategories.OCEAN;
                break;
            }
            case 1: {
                biomeCategories = BiomeCategories.PLAINS;
                break;
            }
            case 2: 
            case 17: {
                biomeCategories = BiomeCategories.DESERT;
                break;
            }
            case 3: 
            case 20: 
            case 34: {
                biomeCategories = BiomeCategories.EXTREME_HILLS;
                break;
            }
            case 4: 
            case 18: 
            case 27: 
            case 28: 
            case 29: {
                biomeCategories = BiomeCategories.FOREST;
                break;
            }
            case 5: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                biomeCategories = BiomeCategories.TAIGA;
                break;
            }
            case 6: {
                biomeCategories = BiomeCategories.SWAMP;
                break;
            }
            case 7: 
            case 11: {
                biomeCategories = BiomeCategories.RIVER;
                break;
            }
            case 8: {
                biomeCategories = BiomeCategories.NETHER;
                break;
            }
            case 9: {
                biomeCategories = BiomeCategories.THE_END;
                break;
            }
            case 12: 
            case 13: {
                biomeCategories = BiomeCategories.ICY;
                break;
            }
            case 14: 
            case 15: {
                biomeCategories = BiomeCategories.MUSHROOM;
                break;
            }
            case 16: 
            case 25: 
            case 26: {
                biomeCategories = BiomeCategories.BEACH;
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                biomeCategories = BiomeCategories.JUNGLE;
                break;
            }
            case 35: 
            case 36: {
                biomeCategories = BiomeCategories.SAVANNA;
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                biomeCategories = BiomeCategories.MESA;
                break;
            }
            default: {
                biomeCategories = null;
            }
        }
        return biomeCategories;
    }

    private static Map<Class<? extends BiomeGenBase>, BiomeCategories> createVanillaClassMap() {
        HashMap<Class<? extends BiomeGenBase>, BiomeCategories> map = new HashMap<Class<? extends BiomeGenBase>, BiomeCategories>();
        map.put(BiomeGenStoneBeach.class, BiomeCategories.BEACH);
        map.put(BiomeGenBeach.class, BiomeCategories.BEACH);
        map.put(BiomeGenMushroomIsland.class, BiomeCategories.MUSHROOM);
        map.put(BiomeGenOcean.class, BiomeCategories.OCEAN);
        map.put(BiomeGenPlains.class, BiomeCategories.PLAINS);
        map.put(BiomeGenDesert.class, BiomeCategories.DESERT);
        map.put(BiomeGenHills.class, BiomeCategories.EXTREME_HILLS);
        map.put(BiomeGenForest.class, BiomeCategories.FOREST);
        map.put(BiomeGenTaiga.class, BiomeCategories.TAIGA);
        map.put(BiomeGenSwamp.class, BiomeCategories.SWAMP);
        map.put(BiomeGenRiver.class, BiomeCategories.RIVER);
        map.put(BiomeGenHell.class, BiomeCategories.NETHER);
        map.put(BiomeGenEnd.class, BiomeCategories.THE_END);
        map.put(BiomeGenSnow.class, BiomeCategories.ICY);
        map.put(BiomeGenJungle.class, BiomeCategories.JUNGLE);
        map.put(BiomeGenSavanna.class, BiomeCategories.SAVANNA);
        map.put(BiomeGenMesa.class, BiomeCategories.MESA);
        return map;
    }

    private static BiomeCategories detectVanillaBiomeByClass(BiomeGenBase biome) {
        BiomeCategories direct = VANILLA_CLASS_MAP.get(biome.getClass());
        if (direct != null) {
            return direct;
        }
        for (Map.Entry<Class<? extends BiomeGenBase>, BiomeCategories> entry : VANILLA_CLASS_MAP.entrySet()) {
            if (!entry.getKey().isInstance(biome)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static BiomeCategories detectModdedBiome(BiomeGenBase biome) {
        return ModdedBiomeDetector.detectModdedBiome(biome);
    }

    private static BiomeCategories detectBiomeByName(BiomeGenBase biome) {
        if (biome.field_76791_y == null) {
            return null;
        }
        String name = biome.field_76791_y.toLowerCase();
        if (name.contains("nether")) {
            return BiomeCategories.NETHER;
        }
        if (name.contains("end")) {
            return BiomeCategories.THE_END;
        }
        if (name.contains("ocean") || name.contains("sea")) {
            return BiomeCategories.OCEAN;
        }
        if (name.contains("river") || name.contains("stream")) {
            return BiomeCategories.RIVER;
        }
        if (name.contains("beach") || name.contains("shore") || name.contains("coast")) {
            return BiomeCategories.BEACH;
        }
        if (name.contains("mushroom")) {
            return BiomeCategories.MUSHROOM;
        }
        if (name.contains("swamp") || name.contains("marsh") || name.contains("bog")) {
            return BiomeCategories.SWAMP;
        }
        if (name.contains("jungle")) {
            return BiomeCategories.JUNGLE;
        }
        if (name.contains("savanna") || name.contains("savannah")) {
            return BiomeCategories.SAVANNA;
        }
        if (name.contains("mesa") || name.contains("badlands")) {
            return BiomeCategories.MESA;
        }
        if (name.contains("desert")) {
            return BiomeCategories.DESERT;
        }
        if (name.contains("mountain") || name.contains("peak") || name.contains("alpine") || name.contains("cliff") || name.contains("crag")) {
            return BiomeCategories.MOUNTAIN;
        }
        if (name.contains("ice") || name.contains("frozen") || name.contains("snow") || name.contains("arctic") || name.contains("tundra") || name.contains("glacier")) {
            return BiomeCategories.ICY;
        }
        if (name.contains("taiga") || name.contains("boreal") || name.contains("conifer")) {
            return BiomeCategories.TAIGA;
        }
        if (name.contains("forest") || name.contains("wood") || name.contains("grove") || name.contains("thicket")) {
            return BiomeCategories.FOREST;
        }
        if (name.contains("plain") || name.contains("field") || name.contains("meadow") || name.contains("grassland") || name.contains("prairie")) {
            return BiomeCategories.PLAINS;
        }
        return null;
    }

    private static BiomeCategories detectBiomeByProperties(BiomeGenBase biome) {
        float temp = biome.field_76750_F;
        float rain = biome.field_76751_G;
        if (temp <= 0.0f && biome.field_76766_R) {
            return BiomeCategories.ICY;
        }
        if (temp >= 2.0f && !biome.field_76765_S) {
            return BiomeCategories.DESERT;
        }
        if (temp >= 1.0f && rain <= 0.1f && !biome.field_76765_S) {
            return BiomeCategories.SAVANNA;
        }
        if (rain >= 0.85f && temp >= 0.5f && temp <= 1.0f) {
            return BiomeCategories.SWAMP;
        }
        if (temp >= 0.0f && temp <= 0.4f && rain >= 0.4f) {
            return BiomeCategories.TAIGA;
        }
        if (temp >= 0.4f && temp <= 0.9f && rain >= 0.5f) {
            return BiomeCategories.FOREST;
        }
        if (temp >= 0.4f && temp <= 1.0f && rain >= 0.3f && rain <= 0.6f) {
            return BiomeCategories.PLAINS;
        }
        return null;
    }

    private static BiomeCategories detectBiomeByBiomeDictionary(BiomeGenBase biome) {
        List<BiomeDictionary.Type> biomeDictTypes = Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome));
        if (biomeDictTypes.contains(BiomeDictionary.Type.SAVANNA)) {
            return BiomeCategories.SAVANNA;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.JUNGLE)) {
            return BiomeCategories.JUNGLE;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.NETHER)) {
            return BiomeCategories.NETHER;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.END)) {
            return BiomeCategories.THE_END;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.MUSHROOM)) {
            return BiomeCategories.MUSHROOM;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.OCEAN)) {
            return BiomeCategories.OCEAN;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.RIVER)) {
            return BiomeCategories.RIVER;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.MESA)) {
            return BiomeCategories.MESA;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.FOREST)) {
            return BiomeCategories.FOREST;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.PLAINS)) {
            return BiomeCategories.PLAINS;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.MOUNTAIN)) {
            return BiomeCategories.MOUNTAIN;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.SWAMP)) {
            return BiomeCategories.SWAMP;
        }
        if (biomeDictTypes.contains(BiomeDictionary.Type.SANDY)) {
            return BiomeCategories.DESERT;
        }
        return null;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getBiomeCategory$1(int n) {
        return "INVALID(" + n + ")";
    }
}

