/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.texture.TextureTracker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoaderRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={PBRTextureHolderImpl.class, PBRTextureConsumerImpl.class, 1.class})
public class PBRTextureManager {
    public static final PBRTextureManager INSTANCE = new PBRTextureManager();
    private static Runnable normalTextureChangeListener;
    private static Runnable specularTextureChangeListener;
    private final Int2ObjectMap<PBRTextureHolder> holders = new Int2ObjectOpenHashMap();
    private final PBRTextureConsumerImpl consumer = new PBRTextureConsumerImpl(this);
    private NativeImageBackedSingleColorTexture defaultNormalTexture;
    private NativeImageBackedSingleColorTexture defaultSpecularTexture;
    private final PBRTextureHolder defaultHolder = new PBRTextureHolder(this){
        final /* synthetic */ PBRTextureManager this$0;
        {
            PBRTextureManager pBRTextureManager = this$0;
            Objects.requireNonNull(pBRTextureManager);
            this.this$0 = pBRTextureManager;
        }

        @Override
        @NotNull
        public AbstractTexture getNormalTexture() {
            return this.this$0.jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultNormalTexture();
        }

        @Override
        @NotNull
        public AbstractTexture getSpecularTexture() {
            return this.this$0.jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultSpecularTexture();
        }
    };

    private PBRTextureManager() {
    }

    public void init() {
        this.defaultNormalTexture = new NativeImageBackedSingleColorTexture(PBRType.NORMAL.getDefaultValue());
        this.defaultSpecularTexture = new NativeImageBackedSingleColorTexture(PBRType.SPECULAR.getDefaultValue());
    }

    public PBRTextureHolder getHolder(int id) {
        PBRTextureHolder holder = (PBRTextureHolder)this.holders.get(id);
        if (holder == null) {
            return this.defaultHolder;
        }
        return holder;
    }

    public PBRTextureHolder getOrLoadHolder(int id) {
        PBRTextureHolder holder = (PBRTextureHolder)this.holders.get(id);
        if (holder == null) {
            holder = this.loadHolder(id);
            this.holders.put(id, (Object)holder);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PBRTextureHolder loadHolder(int id) {
        Class<?> clazz;
        PBRTextureLoader<?> loader;
        AbstractTexture texture = TextureTracker.INSTANCE.getTexture(id);
        if (texture != null && (loader = PBRTextureLoaderRegistry.INSTANCE.getLoader(clazz = texture.getClass())) != null) {
            int previousTextureBinding = GL11.glGetInteger((int)32873);
            this.consumer.clear();
            try {
                loader.load(texture, Minecraft.func_71410_x().func_110442_L(), this.consumer);
                PBRTextureHolder pBRTextureHolder = this.consumer.toHolder();
                return pBRTextureHolder;
            }
            catch (Exception e) {
                Iris.logger.error(PBRTextureManager.jvmdowngrader$concat$loadHolder$1(id), e);
            }
            finally {
                GLStateManager.glBindTexture(3553, previousTextureBinding);
            }
        }
        return this.defaultHolder;
    }

    public void onDeleteTexture(int id) {
        PBRTextureHolder holder = (PBRTextureHolder)this.holders.remove(id);
        if (holder != null) {
            this.closeHolder(holder);
        }
    }

    public void clear() {
        for (PBRTextureHolder holder : this.holders.values()) {
            if (holder == this.defaultHolder) continue;
            this.closeHolder(holder);
        }
        this.holders.clear();
    }

    public void close() {
        this.clear();
    }

    private void closeHolder(PBRTextureHolder holder) {
        AbstractTexture normalTexture = holder.getNormalTexture();
        AbstractTexture specularTexture = holder.getSpecularTexture();
        if (normalTexture != this.defaultNormalTexture) {
            PBRTextureManager.closeTexture(normalTexture);
        }
        if (specularTexture != this.defaultSpecularTexture) {
            PBRTextureManager.closeTexture(specularTexture);
        }
    }

    private static void closeTexture(AbstractTexture texture) {
        texture.func_147631_c();
    }

    public static void notifyPBRTexturesChanged() {
        if (normalTextureChangeListener != null) {
            normalTextureChangeListener.run();
        }
        if (specularTextureChangeListener != null) {
            specularTextureChangeListener.run();
        }
    }

    static {
        StateUpdateNotifiers.normalTextureChangeNotifier = listener -> {
            normalTextureChangeListener = listener;
        };
        StateUpdateNotifiers.specularTextureChangeNotifier = listener -> {
            specularTextureChangeListener = listener;
        };
    }

    public /* synthetic */ PBRTextureHolder jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultHolder() {
        return this.defaultHolder;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$set$defaultHolder(PBRTextureHolder pBRTextureHolder) {
        this.defaultHolder = pBRTextureHolder;
    }

    public /* synthetic */ NativeImageBackedSingleColorTexture jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultNormalTexture() {
        return this.defaultNormalTexture;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$set$defaultNormalTexture(NativeImageBackedSingleColorTexture nativeImageBackedSingleColorTexture) {
        this.defaultNormalTexture = nativeImageBackedSingleColorTexture;
    }

    public /* synthetic */ NativeImageBackedSingleColorTexture jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultSpecularTexture() {
        return this.defaultSpecularTexture;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$set$defaultSpecularTexture(NativeImageBackedSingleColorTexture nativeImageBackedSingleColorTexture) {
        this.defaultSpecularTexture = nativeImageBackedSingleColorTexture;
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadHolder$1(int n) {
        return "Failed to load PBR textures for texture " + n;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=PBRTextureManager.class)
    private class PBRTextureConsumerImpl
    implements PBRTextureLoader.PBRTextureConsumer {
        private AbstractTexture normalTexture;
        private AbstractTexture specularTexture;
        private boolean changed;
        final /* synthetic */ PBRTextureManager this$0;

        PBRTextureConsumerImpl(PBRTextureManager pBRTextureManager) {
            PBRTextureManager pBRTextureManager2 = pBRTextureManager;
            Objects.requireNonNull(pBRTextureManager2);
            this.this$0 = pBRTextureManager2;
        }

        @Override
        public void acceptNormalTexture(@NotNull AbstractTexture texture) {
            this.normalTexture = texture;
            this.changed = true;
        }

        @Override
        public void acceptSpecularTexture(@NotNull AbstractTexture texture) {
            this.specularTexture = texture;
            this.changed = true;
        }

        public void clear() {
            this.normalTexture = this.this$0.jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultNormalTexture();
            this.specularTexture = this.this$0.jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultSpecularTexture();
            this.changed = false;
        }

        public PBRTextureHolder toHolder() {
            if (this.changed) {
                return new PBRTextureHolderImpl(this.normalTexture, this.specularTexture);
            }
            return this.this$0.jvmdowngrader$nest$net_coderbot_iris_texture_pbr_PBRTextureManager$get$defaultHolder();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=PBRTextureManager.class)
    private static class PBRTextureHolderImpl
    implements PBRTextureHolder {
        private final AbstractTexture normalTexture;
        private final AbstractTexture specularTexture;

        public PBRTextureHolderImpl(AbstractTexture normalTexture, AbstractTexture specularTexture) {
            this.normalTexture = normalTexture;
            this.specularTexture = specularTexture;
        }

        @Override
        @NotNull
        public AbstractTexture getNormalTexture() {
            return this.normalTexture;
        }

        @Override
        @NotNull
        public AbstractTexture getSpecularTexture() {
            return this.specularTexture;
        }
    }
}

