/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.format;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Factory.class})
public interface TextureFormat {
    public String getName();

    @Nullable
    public String getVersion();

    default public List<String> getDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        String defineName = this.getName().toUpperCase(Locale.ROOT).replaceAll("-", "_");
        String define = TextureFormat.jvmdowngrader$concat$getDefines$1(defineName);
        defines.add(define);
        String version = this.getVersion();
        if (version != null) {
            String defineVersion = version.replaceAll("[.-]", "_");
            String versionDefine = TextureFormat.jvmdowngrader$concat$getDefines$1(define, defineVersion);
            defines.add(versionDefine);
        }
        return defines;
    }

    public boolean canInterpolateValues(PBRType var1);

    default public void setupTextureParameters(PBRType pbrType, AbstractTexture texture) {
        if (!this.canInterpolateValues(pbrType)) {
            int minFilter = RenderSystem.getTexParameteri(texture.func_110552_b(), 3553, 10241);
            boolean mipmap = (minFilter & 0x100) == 1;
            RenderSystem.texParameteri(texture.func_110552_b(), 3553, 10241, mipmap ? 9984 : 9728);
            RenderSystem.texParameteri(texture.func_110552_b(), 3553, 10240, 9728);
        }
    }

    @Nullable
    public CustomMipmapGenerator getMipmapGenerator(PBRType var1);

    private static /* synthetic */ String jvmdowngrader$concat$getDefines$1(String string) {
        return "MC_TEXTURE_FORMAT_" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getDefines$1(String string, String string2) {
        return string + "_" + string2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=TextureFormat.class)
    public static interface Factory {
        public TextureFormat createFormat(String var1, @Nullable String var2);
    }
}

