/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BaseClippingPlanes {
    private final Vector4f[] planes = new Vector4f[6];
    private final Matrix4f transformScratch = new Matrix4f();

    public BaseClippingPlanes() {
        for (int i = 0; i < this.planes.length; ++i) {
            this.planes[i] = new Vector4f();
        }
    }

    public void init(Matrix4f view, Matrix4f projection) {
        this.transformScratch.set((Matrix4fc)projection);
        this.transformScratch.mul((Matrix4fc)view);
        this.transformScratch.transpose();
        BaseClippingPlanes.transform(this.transformScratch, -1.0f, 0.0f, 0.0f, this.planes[0]);
        BaseClippingPlanes.transform(this.transformScratch, 1.0f, 0.0f, 0.0f, this.planes[1]);
        BaseClippingPlanes.transform(this.transformScratch, 0.0f, -1.0f, 0.0f, this.planes[2]);
        BaseClippingPlanes.transform(this.transformScratch, 0.0f, 1.0f, 0.0f, this.planes[3]);
        BaseClippingPlanes.transform(this.transformScratch, 0.0f, 0.0f, -1.0f, this.planes[4]);
        BaseClippingPlanes.transform(this.transformScratch, 0.0f, 0.0f, 1.0f, this.planes[5]);
    }

    private static void transform(Matrix4f transform, float x, float y, float z, Vector4f dest) {
        dest.set(x, y, z, 1.0f);
        dest.mul((Matrix4fc)transform);
        dest.normalize();
    }

    public Vector4f[] getPlanes() {
        return this.planes;
    }
}

