/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.util.AxisAlignedBB;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.render.viewport.ViewportProvider;
import org.embeddedt.embeddium.impl.render.viewport.frustum.Frustum;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class AdvancedShadowCullingFrustum
extends Frustrum
implements ViewportProvider,
Frustum {
    private static final int MAX_CLIPPING_PLANES = 13;
    private static final Vector3f scratch3a = new Vector3f();
    private static final Vector3f scratch3b = new Vector3f();
    private static final Vector3f scratch3c = new Vector3f();
    private static final Vector3f scratch3d = new Vector3f();
    private static final Vector3f scratch3e = new Vector3f();
    private static final Vector3f scratch3f = new Vector3f();
    private final Vector4f[] planes = new Vector4f[13];
    private int planeCount = 0;
    private final Vector3f shadowLightVectorFromOrigin = new Vector3f();
    protected BoxCuller boxCuller;
    private final Vector3d position = new Vector3d();
    private final BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes();
    private final boolean[] isBackArray = new boolean[6];

    public AdvancedShadowCullingFrustum() {
        for (int i = 0; i < 13; ++i) {
            this.planes[i] = new Vector4f();
        }
    }

    public void init(Matrix4f playerView, Matrix4f playerProjection, Vector3f shadowLightVector, BoxCuller boxCuller) {
        this.shadowLightVectorFromOrigin.set((Vector3fc)shadowLightVector);
        this.boxCuller = boxCuller;
        this.planeCount = 0;
        this.baseClippingPlanes.init(playerView, playerProjection);
        this.addBackPlanes(this.baseClippingPlanes, this.isBackArray);
        this.addEdgePlanes(this.baseClippingPlanes, this.isBackArray);
    }

    private void addPlane(Vector4f plane) {
        this.planes[this.planeCount].set((Vector4fc)plane);
        ++this.planeCount;
    }

    private void addPlane(float x, float y, float z, float w) {
        this.planes[this.planeCount].set(x, y, z, w);
        ++this.planeCount;
    }

    private void addBackPlanes(BaseClippingPlanes baseClippingPlanes, boolean[] isBack) {
        Vector4f[] basePlanes = baseClippingPlanes.getPlanes();
        for (int planeIndex = 0; planeIndex < basePlanes.length; ++planeIndex) {
            Vector4f plane = basePlanes[planeIndex];
            this.truncate(plane, scratch3a);
            float dot = scratch3a.dot((Vector3fc)this.shadowLightVectorFromOrigin);
            boolean back = (double)dot > 0.0;
            boolean edge = (double)dot == 0.0;
            isBack[planeIndex] = back;
            if (!back && !edge) continue;
            this.addPlane(plane);
        }
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] isBack) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            if (!isBack[planeIndex]) continue;
            Vector4f plane = planes[planeIndex];
            NeighboringPlaneSet neighbors = NeighboringPlaneSet.forPlane(planeIndex);
            if (!isBack[neighbors.getPlane0()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane0()]);
            }
            if (!isBack[neighbors.getPlane1()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane1()]);
            }
            if (!isBack[neighbors.getPlane2()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane2()]);
            }
            if (isBack[neighbors.getPlane3()]) continue;
            this.addEdgePlane(plane, planes[neighbors.getPlane3()]);
        }
    }

    private Vector3f truncate(Vector4f base, Vector3f dest) {
        return dest.set(base.x(), base.y(), base.z());
    }

    private float lengthSquared(Vector3f v) {
        float x = v.x();
        float y = v.y();
        float z = v.z();
        return x * x + y * y + z * z;
    }

    private Vector3f cross(Vector3f first, Vector3f second, Vector3f dest) {
        return dest.set((Vector3fc)first).cross((Vector3fc)second);
    }

    private void addEdgePlane(Vector4f backPlane4, Vector4f frontPlane4) {
        Vector3f backPlaneNormal = this.truncate(backPlane4, scratch3a);
        Vector3f frontPlaneNormal = this.truncate(frontPlane4, scratch3b);
        Vector3f intersection = this.cross(backPlaneNormal, frontPlaneNormal, scratch3c);
        Vector3f edgePlaneNormal = this.cross(intersection, this.shadowLightVectorFromOrigin, scratch3d);
        Vector3f ixb = this.cross(intersection, backPlaneNormal, scratch3e);
        Vector3f fxi = this.cross(frontPlaneNormal, intersection, scratch3f);
        ixb.mul(-frontPlane4.w());
        fxi.mul(-backPlane4.w());
        ixb.add((Vector3fc)fxi);
        Vector3f point = ixb;
        point.mul(1.0f / this.lengthSquared(intersection));
        float d = edgePlaneNormal.dot((Vector3fc)point);
        this.addPlane(edgePlaneNormal.x(), edgePlaneNormal.y(), edgePlaneNormal.z(), -d);
    }

    public void func_78547_a(double cameraX, double cameraY, double cameraZ) {
        super.func_78547_a(cameraX, cameraY, cameraZ);
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(cameraX, cameraY, cameraZ);
        }
    }

    public boolean func_78546_a(AxisAlignedBB aabb) {
        if (this.boxCuller != null && this.boxCuller.isCulled(aabb)) {
            return false;
        }
        return this.isVisible(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    @Override
    public boolean testAab(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.boxCuller != null && this.boxCuller.isCulledViewRelative(minX, minY, minZ, maxX, maxY, maxZ)) {
            return false;
        }
        return this.checkCornerVisibility(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public Viewport sodium$createViewport() {
        return new Viewport(this, this.position.set(this.field_78550_b, this.field_78551_c, this.field_78549_d));
    }

    protected boolean isVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.checkCornerVisibility((float)(minX - this.field_78550_b), (float)(minY - this.field_78551_c), (float)(minZ - this.field_78549_d), (float)(maxX - this.field_78550_b), (float)(maxY - this.field_78551_c), (float)(maxZ - this.field_78549_d));
    }

    protected boolean checkCornerVisibility(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        for (int i = 0; i < this.planeCount; ++i) {
            float outsideBoundZ;
            Vector4f plane = this.planes[i];
            float outsideBoundX = plane.x() < 0.0f ? minX : maxX;
            float outsideBoundY = plane.y() < 0.0f ? minY : maxY;
            float f = outsideBoundZ = plane.z() < 0.0f ? minZ : maxZ;
            if (!(Math.fma((float)plane.x(), (float)outsideBoundX, (float)Math.fma((float)plane.y(), (float)outsideBoundY, (float)(plane.z() * outsideBoundZ))) < -plane.w())) continue;
            return false;
        }
        return true;
    }
}

