/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.buffer.ShaderStorageBufferHolder;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.framebuffer.ViewportData;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.state.FogMode;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.FilledIndirectPointer;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={ComputeOnlyPass.class, Pass.class})
public class ShadowCompositeRenderer {
    private final ShadowRenderTargets renderTargets;
    private final ImmutableList<Pass> passes;
    private final TextureAccess noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final Object2ObjectMap<String, TextureAccess> customTextureIds;
    private final ImmutableSet<Integer> flippedAtLeastOnceFinal;
    private final CustomUniforms customUniforms;
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures;
    private final WorldRenderingPipeline pipeline;
    private final Set<GlImage> irisCustomImages;
    @Nullable
    private final ShaderStorageBufferHolder ssboHolder;

    public ShadowCompositeRenderer(WorldRenderingPipeline pipeline, PackDirectives packDirectives, ProgramSource[] sources, ComputeSource[][] computes, ShadowRenderTargets renderTargets, @Nullable ShaderStorageBufferHolder ssboHolder, TextureAccess noiseTexture, FrameUpdateNotifier updateNotifier, Object2ObjectMap<String, TextureAccess> customTextureIds, Set<GlImage> customImages, ImmutableMap<Integer, Boolean> explicitPreFlips, Object2ObjectMap<String, TextureAccess> irisCustomTextures, CustomUniforms customUniforms) {
        this.pipeline = pipeline;
        this.noiseTexture = noiseTexture;
        this.updateNotifier = updateNotifier;
        this.renderTargets = renderTargets;
        this.ssboHolder = ssboHolder;
        this.customTextureIds = customTextureIds;
        this.irisCustomTextures = irisCustomTextures;
        this.irisCustomImages = customImages;
        this.customUniforms = customUniforms;
        PackRenderTargetDirectives renderTargetDirectives = packDirectives.getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> renderTargetSettings = renderTargetDirectives.getRenderTargetSettings();
        ImmutableList.Builder passes = ImmutableList.builder();
        ImmutableSet.Builder flippedAtLeastOnce = new ImmutableSet.Builder();
        explicitPreFlips.forEach((buffer, shouldFlip) -> {
            if (shouldFlip.booleanValue()) {
                renderTargets.flip((int)buffer);
            }
        });
        int sourcesLength = sources.length;
        for (int i = 0; i < sourcesLength; ++i) {
            int[] nArray;
            Pass pass;
            ProgramSource source = sources[i];
            ImmutableSet<Integer> flipped = renderTargets.snapshot();
            ImmutableSet flippedAtLeastOnceSnapshot = flippedAtLeastOnce.build();
            if (source == null || !source.isValid()) {
                if (computes[i] == null) continue;
                pass = new ComputeOnlyPass();
                ((ComputeOnlyPass)pass).computes = this.createComputes(computes[i], flipped, (ImmutableSet<Integer>)flippedAtLeastOnceSnapshot, renderTargets);
                passes.add((Object)pass);
                continue;
            }
            pass = new Pass();
            ProgramDirectives directives = source.getDirectives();
            pass.program = this.createProgram(source, flipped, (ImmutableSet<Integer>)flippedAtLeastOnceSnapshot, renderTargets);
            pass.computes = this.createComputes(computes[i], flipped, (ImmutableSet<Integer>)flippedAtLeastOnceSnapshot, renderTargets);
            if (directives.hasUnknownDrawBuffers()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else {
                nArray = directives.getDrawBuffers();
            }
            int[] drawBuffers = nArray;
            GlFramebuffer framebuffer = renderTargets.createColorFramebuffer(flipped, drawBuffers);
            pass.stageReadsFromAlt = flipped;
            pass.framebuffer = framebuffer;
            pass.viewportScale = directives.getViewportScale();
            pass.mipmappedBuffers = directives.getMipmappedBuffers();
            pass.flippedAtLeastOnce = flippedAtLeastOnceSnapshot;
            passes.add((Object)pass);
            ImmutableMap<Integer, Boolean> explicitFlips = directives.getExplicitFlips();
            for (int buffer2 : drawBuffers) {
                if (explicitFlips.get((Object)buffer2) == Boolean.FALSE) continue;
                renderTargets.flip(buffer2);
                flippedAtLeastOnce.add((Object)buffer2);
            }
            explicitFlips.forEach((buffer, shouldFlip) -> {
                if (shouldFlip.booleanValue()) {
                    renderTargets.flip((int)buffer);
                    flippedAtLeastOnce.add(buffer);
                }
            });
        }
        this.passes = passes.build();
        this.flippedAtLeastOnceFinal = flippedAtLeastOnce.build();
        GLStateManager.glBindFramebuffer(36008, 0);
    }

    private static void setupMipmapping(RenderTarget target, boolean readFromAlt) {
        if (target == null) {
            return;
        }
        int texture = readFromAlt ? target.getAltTexture() : target.getMainTexture();
        RenderSystem.generateMipmaps(texture, 3553);
        RenderSystem.texParameteri(texture, 3553, 10241, target.getInternalFormat().getPixelFormat().isInteger() ? 9984 : 9987);
    }

    private static void resetRenderTarget(RenderTarget target) {
        int filter = 9729;
        if (target.getInternalFormat().getPixelFormat().isInteger()) {
            filter = 9728;
        }
        RenderSystem.texParameteri(target.getMainTexture(), 3553, 10241, filter);
        RenderSystem.texParameteri(target.getAltTexture(), 3553, 10241, filter);
    }

    public ImmutableSet<Integer> getFlippedAtLeastOnceFinal() {
        return this.flippedAtLeastOnceFinal;
    }

    public void renderAll() {
        GLStateManager.disableBlend();
        FullScreenQuadRenderer.INSTANCE.begin();
        for (Pass renderPass : this.passes) {
            boolean ranCompute = false;
            for (ComputeProgram computeProgram : renderPass.computes) {
                if (computeProgram == null) continue;
                ranCompute = true;
                Framebuffer main = Minecraft.func_71410_x().func_147110_a();
                computeProgram.use();
                this.customUniforms.push(computeProgram);
                computeProgram.dispatch(main.field_147621_c, main.field_147618_d);
            }
            if (ranCompute) {
                RenderSystem.memoryBarrier(40);
            }
            Program.unbind();
            if (renderPass instanceof ComputeOnlyPass) continue;
            if (!renderPass.mipmappedBuffers.isEmpty()) {
                GLStateManager.glActiveTexture(33984);
                UnmodifiableIterator unmodifiableIterator = renderPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int index = (Integer)unmodifiableIterator.next();
                    ShadowCompositeRenderer.setupMipmapping(this.renderTargets.get(index), renderPass.stageReadsFromAlt.contains((Object)index));
                }
            }
            float scaledWidth = (float)this.renderTargets.getResolution() * renderPass.viewportScale.scale();
            float scaledHeight = (float)this.renderTargets.getResolution() * renderPass.viewportScale.scale();
            int beginWidth = (int)((float)this.renderTargets.getResolution() * renderPass.viewportScale.viewportX());
            int beginHeight = (int)((float)this.renderTargets.getResolution() * renderPass.viewportScale.viewportY());
            GLStateManager.glViewport(beginWidth, beginHeight, (int)scaledWidth, (int)scaledHeight);
            renderPass.framebuffer.bind();
            renderPass.program.use();
            this.customUniforms.push(renderPass.program);
            FullScreenQuadRenderer.INSTANCE.renderQuad();
        }
        FullScreenQuadRenderer.INSTANCE.end();
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            if (this.renderTargets.get(i) == null) continue;
            ShadowCompositeRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        GLStateManager.glActiveTexture(33984);
    }

    private Program createProgram(ProgramSource source, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, ShadowRenderTargets targets) {
        ProgramBuilder builder;
        Map<PatchShaderType, String> transformed = TransformPatcher.patchComposite(source.getVertexSource().orElseThrow(NullPointerException::new), (String)source.getGeometrySource().orElse(null), (String)source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElseThrow(NullPointerException::new));
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String tessControl = transformed.get((Object)PatchShaderType.TESS_CONTROL);
        String tessEval = transformed.get((Object)PatchShaderType.TESS_EVAL);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        PatchedShaderPrinter.debugPatchedShaders(source.getName(), vertex, geometry, tessControl, tessEval, fragment);
        Objects.requireNonNull(flipped);
        try {
            builder = ProgramBuilder.begin(source.getName(), vertex, geometry, tessControl, tessEval, fragment, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(ShadowCompositeRenderer.jvmdowngrader$concat$createProgram$1(source.getName()), e);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
        CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
        this.customUniforms.assignTo(builder);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
        IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, targets, flipped, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
        IrisImages.addShadowColorImages(builder, targets, flipped);
        IrisImages.addCustomImages(builder, this.irisCustomImages);
        IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.irisCustomImages);
        Program build = builder.build();
        this.customUniforms.mapholderToPass(builder, build);
        return build;
    }

    private ComputeProgram[] createComputes(ComputeSource[] sources, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, ShadowRenderTargets targets) {
        if (sources == null) {
            return new ComputeProgram[0];
        }
        ComputeProgram[] programs = new ComputeProgram[sources.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = sources[i];
            if (source == null || !source.getSource().isPresent()) continue;
            Objects.requireNonNull(flipped);
            try {
                String transformed = TransformPatcher.patchCompute(source.getName(), source.getSource().orElse(null), TextureStage.SHADOWCOMP, this.pipeline.getTextureMap());
                PatchedShaderPrinter.debugPatchedShaders(ShadowCompositeRenderer.jvmdowngrader$concat$createComputes$1(source.getName()), null, null, null, transformed);
                builder = ProgramBuilder.beginCompute(source.getName(), transformed, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(ShadowCompositeRenderer.jvmdowngrader$concat$createComputes$2(source.getName()), e);
            }
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
            CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
            this.customUniforms.assignTo(builder);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, targets, flipped, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
            IrisImages.addShadowColorImages(builder, targets, flipped);
            IrisImages.addCustomImages(builder, this.irisCustomImages);
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.irisCustomImages);
            programs[i] = builder.buildCompute();
            this.customUniforms.mapholderToPass(builder, programs[i]);
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups(), this.ssboHolder != null ? FilledIndirectPointer.basedOff(this.ssboHolder, source.getIndirectPointer()) : null);
        }
        return programs;
    }

    public void destroy() {
        for (Pass renderPass : this.passes) {
            renderPass.destroy();
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$createProgram$1(String string) {
        return "Shader compilation failed for shadow composite " + string + "!";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createComputes$1(String string) {
        return string + "_compute";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createComputes$2(String string) {
        return "Shader compilation failed for shadowcomp compute " + string + "!";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ShadowCompositeRenderer.class)
    private static class ComputeOnlyPass
    extends Pass {
        ComputeOnlyPass() {
        }

        @Override
        protected void destroy() {
            for (ComputeProgram compute : this.computes) {
                if (compute == null) continue;
                compute.destroy();
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ShadowCompositeRenderer.class)
    private static class Pass {
        Program program;
        GlFramebuffer framebuffer;
        ImmutableSet<Integer> flippedAtLeastOnce;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;
        ViewportData viewportScale;
        ComputeProgram[] computes;

        Pass() {
        }

        protected void destroy() {
            this.program.destroy();
            for (ComputeProgram compute : this.computes) {
                if (compute == null) continue;
                compute.destroy();
            }
        }
    }
}

