/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.preprocessor;

import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Feature;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.LexerException;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Preprocessor;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.PreprocessorCommand;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.StringLexerSource;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Token;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesCommentListener;
import net.coderbot.iris.shaderpack.preprocessor.PropertyCollectingListener;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PropertiesPreprocessor {
    public static String preprocessSource(String source, ShaderPackOptions shaderPackOptions, Iterable<StringPair> environmentDefines) {
        String string;
        if (source.contains("#warning IRIS_PASSTHROUGH ") || source.contains("IRIS_PASSTHROUGHBACKSLASH")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        List<String> booleanValues = PropertiesPreprocessor.getBooleanValues(shaderPackOptions);
        Map<String, String> stringValues = PropertiesPreprocessor.getStringValues(shaderPackOptions);
        Preprocessor pp = new Preprocessor();
        try {
            for (String value2 : booleanValues) {
                pp.addMacro(value2);
            }
            for (StringPair envDefine : environmentDefines) {
                pp.addMacro(envDefine.getKey(), envDefine.getValue());
            }
            stringValues.forEach((name, value) -> {
                try {
                    pp.addMacro((String)name, (String)value);
                }
                catch (LexerException e) {
                    e.printStackTrace();
                }
            });
            string = PropertiesPreprocessor.process(pp, source);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException while processing macros", e);
            }
            catch (LexerException e) {
                throw new RuntimeException("Unexpected LexerException processing macros", e);
            }
        }
        pp.close();
        return string;
    }

    public static String preprocessSource(String source, Iterable<StringPair> environmentDefines) {
        if (source.contains("#warning IRIS_PASSTHROUGH ")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        Preprocessor preprocessor = new Preprocessor();
        try {
            for (StringPair envDefine : environmentDefines) {
                preprocessor.addMacro(envDefine.getKey(), envDefine.getValue());
            }
        }
        catch (LexerException e) {
            e.printStackTrace();
        }
        return PropertiesPreprocessor.process(preprocessor, source);
    }

    private static String process(Preprocessor preprocessor, String source) {
        preprocessor.setListener(new PropertiesCommentListener());
        PropertyCollectingListener listener = new PropertyCollectingListener();
        preprocessor.setListener(listener);
        source = PropertiesPreprocessor.jvmdowngrader$concat$process$1(Arrays.stream(source.split("\\R")).map(String::trim).filter(s -> !s.isEmpty()).map(line -> {
            if (line.startsWith("#")) {
                for (PreprocessorCommand command : PreprocessorCommand.values()) {
                    if (!line.startsWith(PropertiesPreprocessor.jvmdowngrader$concat$lambda$process$1$1(command.name().replace("PP_", "").toLowerCase(Locale.ROOT)))) continue;
                    return line;
                }
                return "";
            }
            return line.replace("#", "");
        }).collect(Collectors.joining("\n")));
        source = source.replace("\\", "IRIS_PASSTHROUGHBACKSLASH");
        preprocessor.addInput(new StringLexerSource(source, true));
        preprocessor.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder builder = new StringBuilder();
        try {
            Token tok;
            while ((tok = preprocessor.token()) != null && tok.getType() != 265) {
                builder.append(tok.getText());
            }
        }
        catch (Exception e) {
            Iris.logger.error("Properties pre-processing failed", e);
        }
        source = builder.toString();
        return PropertiesPreprocessor.jvmdowngrader$concat$process$1(listener.collectLines(), source).replace("IRIS_PASSTHROUGHBACKSLASH", "\\");
    }

    private static List<String> getBooleanValues(ShaderPackOptions shaderPackOptions) {
        ArrayList<String> booleanValues = new ArrayList<String>();
        shaderPackOptions.getOptionSet().getBooleanOptions().forEach((string, value) -> {
            boolean trueValue = shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)string);
            if (trueValue) {
                booleanValues.add((String)string);
            }
        });
        return booleanValues;
    }

    private static Map<String, String> getStringValues(ShaderPackOptions shaderPackOptions) {
        HashMap<String, String> stringValues = new HashMap<String, String>();
        shaderPackOptions.getOptionSet().getStringOptions().forEach((optionName, value) -> stringValues.put((String)optionName, shaderPackOptions.getOptionValues().getStringValueOrDefault((String)optionName)));
        return stringValues;
    }

    private static /* synthetic */ String jvmdowngrader$concat$process$1(String string) {
        return string + "\n";
    }

    private static /* synthetic */ String jvmdowngrader$concat$process$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$process$1$1(String string) {
        return "#" + string;
    }
}

