/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.option.BooleanOption;
import net.coderbot.iris.shaderpack.option.MergedBooleanOption;
import net.coderbot.iris.shaderpack.option.MergedStringOption;
import net.coderbot.iris.shaderpack.option.OptionLocation;
import net.coderbot.iris.shaderpack.option.StringOption;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Builder.class})
public class OptionSet {
    private final ImmutableMap<String, MergedBooleanOption> booleanOptions;
    private final ImmutableMap<String, MergedStringOption> stringOptions;

    OptionSet(Builder builder) {
        this.booleanOptions = ImmutableMap.copyOf((Map)builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$Builder$get$booleanOptions());
        this.stringOptions = ImmutableMap.copyOf((Map)builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$Builder$get$stringOptions());
    }

    public ImmutableMap<String, MergedBooleanOption> getBooleanOptions() {
        return this.booleanOptions;
    }

    public ImmutableMap<String, MergedStringOption> getStringOptions() {
        return this.stringOptions;
    }

    public boolean isBooleanOption(String name) {
        return this.booleanOptions.containsKey((Object)name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public /* synthetic */ ImmutableMap jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$get$stringOptions() {
        return this.stringOptions;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$set$stringOptions(ImmutableMap immutableMap) {
        this.stringOptions = immutableMap;
    }

    public /* synthetic */ ImmutableMap jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$get$booleanOptions() {
        return this.booleanOptions;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$set$booleanOptions(ImmutableMap immutableMap) {
        this.booleanOptions = immutableMap;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=OptionSet.class)
    public static class Builder {
        private final Map<String, MergedBooleanOption> booleanOptions = new HashMap<String, MergedBooleanOption>();
        private final Map<String, MergedStringOption> stringOptions = new HashMap<String, MergedStringOption>();

        public void addAll(OptionSet other) {
            if (this.booleanOptions.isEmpty()) {
                this.booleanOptions.putAll((Map<String, MergedBooleanOption>)other.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$get$booleanOptions());
            } else {
                other.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$get$booleanOptions().values().forEach(this::addBooleanOption);
            }
            if (this.stringOptions.isEmpty()) {
                this.stringOptions.putAll((Map<String, MergedStringOption>)other.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$get$stringOptions());
            } else {
                other.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$get$stringOptions().values().forEach(this::addStringOption);
            }
        }

        public void addBooleanOption(OptionLocation location, BooleanOption option) {
            this.addBooleanOption(new MergedBooleanOption(location, option));
        }

        public void addBooleanOption(MergedBooleanOption proposed) {
            MergedBooleanOption merged;
            BooleanOption option = proposed.getOption();
            MergedBooleanOption existing = this.booleanOptions.get(option.getName());
            if (existing != null) {
                merged = existing.merge(proposed);
                if (merged == null) {
                    Iris.logger.warn(Builder.jvmdowngrader$concat$addBooleanOption$1(option.getName()));
                    this.booleanOptions.remove(option.getName());
                    return;
                }
            } else {
                merged = proposed;
            }
            this.booleanOptions.put(option.getName(), merged);
        }

        public void addStringOption(OptionLocation location, StringOption option) {
            this.addStringOption(new MergedStringOption(location, option));
        }

        public void addStringOption(MergedStringOption proposed) {
            MergedStringOption merged;
            StringOption option = proposed.getOption();
            MergedStringOption existing = this.stringOptions.get(option.getName());
            if (existing != null) {
                merged = existing.merge(proposed);
                if (merged == null) {
                    Iris.logger.warn(Builder.jvmdowngrader$concat$addStringOption$1(option.getName()));
                    this.stringOptions.remove(option.getName());
                    return;
                }
            } else {
                merged = proposed;
            }
            this.stringOptions.put(option.getName(), merged);
        }

        public OptionSet build() {
            return new OptionSet(this);
        }

        public /* synthetic */ Map jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$Builder$get$stringOptions() {
            return this.stringOptions;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$Builder$set$stringOptions(Map map) {
            this.stringOptions = map;
        }

        public /* synthetic */ Map jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$Builder$get$booleanOptions() {
            return this.booleanOptions;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionSet$Builder$set$booleanOptions(Map map) {
            this.booleanOptions = map;
        }

        private static /* synthetic */ String jvmdowngrader$concat$addBooleanOption$1(String string) {
            return "Ignoring ambiguous boolean option " + string;
        }

        private static /* synthetic */ String jvmdowngrader$concat$addStringOption$1(String string) {
            return "Ignoring ambiguous string option " + string;
        }
    }
}

