/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.option.BooleanOption;
import net.coderbot.iris.shaderpack.option.OptionLocation;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.OptionType;
import net.coderbot.iris.shaderpack.option.StringOption;
import net.coderbot.iris.shaderpack.option.values.OptionValues;
import net.coderbot.iris.shaderpack.parsing.ParsedString;
import net.coderbot.iris.shaderpack.transform.line.LineTransform;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={AnnotationsBuilder.class})
public final class OptionAnnotatedSource {
    private final ImmutableList<String> lines;
    private final ImmutableMap<Integer, BooleanOption> booleanOptions;
    private final ImmutableMap<Integer, StringOption> stringOptions;
    private final ImmutableMap<Integer, String> diagnostics;
    private final ImmutableMap<String, IntList> booleanDefineReferences;
    private static final ImmutableSet<String> VALID_CONST_OPTION_NAMES = ImmutableSet.of((Object)"shadowMapResolution", (Object)"shadowDistance", (Object)"shadowDistanceRenderMul", (Object)"entityShadowDistanceMul", (Object)"shadowIntervalSize", (Object)"generateShadowMipmap", (Object[])new String[]{"generateShadowColorMipmap", "shadowHardwareFiltering", "shadowHardwareFiltering0", "shadowHardwareFiltering1", "shadowtex0Mipmap", "shadowtexMipmap", "shadowtex1Mipmap", "shadowcolor0Mipmap", "shadowColor0Mipmap", "shadowcolor1Mipmap", "shadowColor1Mipmap", "shadowtex0Nearest", "shadowtexNearest", "shadow0MinMagNearest", "shadowtex1Nearest", "shadow1MinMagNearest", "shadowcolor0Nearest", "shadowColor0Nearest", "shadowColor0MinMagNearest", "shadowcolor1Nearest", "shadowColor1Nearest", "shadowColor1MinMagNearest", "wetnessHalflife", "drynessHalflife", "eyeBrightnessHalflife", "centerDepthHalflife", "sunPathRotation", "ambientOcclusionLevel", "superSamplingLevel", "noiseTextureResolution"});

    public OptionAnnotatedSource(String source) {
        this((ImmutableList<String>)ImmutableList.copyOf((Object[])source.split("\\R")));
    }

    public OptionAnnotatedSource(ImmutableList<String> lines) {
        this.lines = lines;
        AnnotationsBuilder builder = new AnnotationsBuilder();
        for (int index = 0; index < lines.size(); ++index) {
            String line = (String)lines.get(index);
            OptionAnnotatedSource.parseLine(builder, index, line);
        }
        this.booleanOptions = builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanOptions().build();
        this.stringOptions = builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$stringOptions().build();
        this.diagnostics = builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().build();
        this.booleanDefineReferences = ImmutableMap.copyOf((Map)builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanDefineReferences());
    }

    private static void parseLine(AnnotationsBuilder builder, int index, String lineText) {
        if (!(lineText.contains("#define") || lineText.contains("const") || lineText.contains("#ifdef") || lineText.contains("#ifndef"))) {
            return;
        }
        ParsedString line = new ParsedString(lineText.trim());
        if (line.takeLiteral("#ifdef") || line.takeLiteral("#ifndef")) {
            OptionAnnotatedSource.parseIfdef(builder, index, line);
        } else if (line.takeLiteral("const")) {
            OptionAnnotatedSource.parseConst(builder, index, line);
        } else if (line.currentlyContains("#define")) {
            OptionAnnotatedSource.parseDefineOption(builder, index, line);
        }
    }

    private static void parseIfdef(AnnotationsBuilder builder, int index, ParsedString line) {
        if (!line.takeSomeWhitespace()) {
            return;
        }
        String name = line.takeWord();
        line.takeSomeWhitespace();
        if (name == null || !line.isEnd()) {
            return;
        }
        builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanDefineReferences().computeIfAbsent(name, n -> new IntArrayList()).add(index);
    }

    private static void parseConst(AnnotationsBuilder builder, int index, ParsedString line) {
        String comment;
        boolean isString;
        if (!line.takeSomeWhitespace()) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Expected whitespace after const and before type declaration");
            return;
        }
        if (line.takeLiteral("int") || line.takeLiteral("float")) {
            isString = true;
        } else if (line.takeLiteral("bool")) {
            isString = false;
        } else {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Unexpected type declaration after const. Expected int, float, or bool. Vector const declarations cannot be configured using shader options.");
            return;
        }
        if (!line.takeSomeWhitespace()) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Expected whitespace after type declaration.");
            return;
        }
        String name = line.takeWord();
        if (name == null) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Expected name of option after type declaration, but an unexpected character was detected first.");
            return;
        }
        line.takeSomeWhitespace();
        if (!line.takeLiteral("=")) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Unexpected characters before equals sign in const declaration.");
            return;
        }
        line.takeSomeWhitespace();
        String value = line.takeWordOrNumber();
        if (value == null) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Unexpected non-whitespace characters after equals sign");
            return;
        }
        line.takeSomeWhitespace();
        if (!line.takeLiteral(";")) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Value between the equals sign and the semicolon wasn't parsed as a valid word or number.");
            return;
        }
        line.takeSomeWhitespace();
        if (line.takeComments()) {
            comment = line.takeRest().trim();
        } else {
            if (!line.isEnd()) {
                builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Unexpected non-whitespace characters outside of comment after semicolon");
                return;
            }
            comment = null;
        }
        if (!isString) {
            boolean booleanValue;
            if ("true".equals(value)) {
                booleanValue = true;
            } else if ("false".equals(value)) {
                booleanValue = false;
            } else {
                builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)OptionAnnotatedSource.jvmdowngrader$concat$parseConst$1(value));
                return;
            }
            if (!VALID_CONST_OPTION_NAMES.contains((Object)name)) {
                builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)OptionAnnotatedSource.jvmdowngrader$concat$parseConst$2(name));
                return;
            }
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanOptions().put((Object)index, (Object)new BooleanOption(OptionType.CONST, name, comment, booleanValue));
            return;
        }
        if (!VALID_CONST_OPTION_NAMES.contains((Object)name)) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)OptionAnnotatedSource.jvmdowngrader$concat$parseConst$3(name));
            return;
        }
        StringOption option = StringOption.create(OptionType.CONST, name, comment, value);
        if (option != null) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$stringOptions().put((Object)index, (Object)option);
        } else {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Ignoring this const option because it is missing an allowed values listin a comment, but is not a boolean const option.");
        }
    }

    private static void parseDefineOption(AnnotationsBuilder builder, int index, ParsedString line) {
        String comment;
        StringOption option;
        boolean hasLeadingComment = line.takeComments();
        line.takeSomeWhitespace();
        if (!line.takeLiteral("#define")) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"This line contains an occurrence of \"#define\" but it wasn't in a place we expected, ignoring it.");
            return;
        }
        if (!line.takeSomeWhitespace()) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"This line properly starts with a #define statement but doesn't have any whitespace characters after the #define.");
            return;
        }
        String name = line.takeWord();
        if (name == null) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Invalid syntax after #define directive. No alphanumeric or underscore characters detected.");
            return;
        }
        boolean tookWhitespace = line.takeSomeWhitespace();
        if (line.isEnd()) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanOptions().put((Object)index, (Object)new BooleanOption(OptionType.DEFINE, name, null, !hasLeadingComment));
            return;
        }
        if (line.takeComments()) {
            String comment2 = line.takeRest().trim();
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanOptions().put((Object)index, (Object)new BooleanOption(OptionType.DEFINE, name, comment2, !hasLeadingComment));
            return;
        }
        if (!tookWhitespace) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Invalid syntax after #define directive. Only alphanumeric or underscore characters are allowed in option names.");
            return;
        }
        if (hasLeadingComment) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Ignoring potential non-boolean #define option since it has a leading comment. Leading comments (//) are only allowed on boolean #define options.");
            return;
        }
        String value = line.takeWordOrNumber();
        if (value == null) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Ignoring this #define directive because it doesn't appear to be a boolean #define, and its potential value wasn't a valid number or a valid word.");
            return;
        }
        tookWhitespace = line.takeSomeWhitespace();
        if (line.isEnd()) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Ignoring this #define because it doesn't have a comment containing a list of allowed values afterwards, but it has a value so is therefore not a boolean.");
            return;
        }
        if (!tookWhitespace) {
            if (!line.takeComments()) {
                builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Invalid syntax after value #define directive. Invalid characters after number or word.");
                return;
            }
        } else if (!line.takeComments()) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Invalid syntax after value #define directive. Only comments may come after the value.");
            return;
        }
        if ((option = StringOption.create(OptionType.DEFINE, name, comment = line.takeRest().trim(), value)) == null) {
            builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics().put((Object)index, (Object)"Ignoring this #define because it is missing an allowed values listin a comment, but is not a boolean define.");
            return;
        }
        builder.jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$stringOptions().put((Object)index, (Object)option);
    }

    public ImmutableMap<Integer, BooleanOption> getBooleanOptions() {
        return this.booleanOptions;
    }

    public ImmutableMap<Integer, StringOption> getStringOptions() {
        return this.stringOptions;
    }

    public ImmutableMap<Integer, String> getDiagnostics() {
        return this.diagnostics;
    }

    public ImmutableMap<String, IntList> getBooleanDefineReferences() {
        return this.booleanDefineReferences;
    }

    public OptionSet getOptionSet(AbsolutePackPath filePath, Set<String> booleanDefineReferences) {
        OptionSet.Builder builder = OptionSet.builder();
        this.booleanOptions.forEach((lineIndex, option) -> {
            if (booleanDefineReferences.contains(option.getName())) {
                OptionLocation location = new OptionLocation(filePath, (int)lineIndex);
                builder.addBooleanOption(location, (BooleanOption)option);
            }
        });
        this.stringOptions.forEach((lineIndex, option) -> {
            OptionLocation location = new OptionLocation(filePath, (int)lineIndex);
            builder.addStringOption(location, (StringOption)option);
        });
        return builder.build();
    }

    public LineTransform asTransform(OptionValues values) {
        return (index, line) -> this.edit(values, index, line);
    }

    public String apply(OptionValues values) {
        StringBuilder source = new StringBuilder();
        for (int index = 0; index < this.lines.size(); ++index) {
            source.append(this.edit(values, index, (String)this.lines.get(index)));
            source.append('\n');
        }
        return source.toString();
    }

    private String edit(OptionValues values, int index, String existing) {
        BooleanOption booleanOption = (BooleanOption)this.booleanOptions.get((Object)index);
        if (booleanOption != null) {
            OptionalBoolean value2 = values.getBooleanValue(booleanOption.getName());
            if (booleanOption.getType() == OptionType.DEFINE) {
                return OptionAnnotatedSource.setBooleanDefineValue(existing, value2, booleanOption.getDefaultValue());
            }
            if (booleanOption.getType() == OptionType.CONST) {
                if (value2 != OptionalBoolean.DEFAULT) {
                    return this.editConst(existing, Boolean.toString(booleanOption.getDefaultValue()), Boolean.toString(value2.orElse(booleanOption.getDefaultValue())));
                }
                return existing;
            }
            throw new AssertionError((Object)OptionAnnotatedSource.jvmdowngrader$concat$edit$1(String.valueOf((Object)booleanOption.getType())));
        }
        StringOption stringOption = (StringOption)this.stringOptions.get((Object)index);
        if (stringOption != null) {
            return values.getStringValue(stringOption.getName()).map(value -> {
                if (stringOption.getType() == OptionType.DEFINE) {
                    return OptionAnnotatedSource.jvmdowngrader$concat$lambda$edit$0$1(stringOption.getName(), value);
                }
                if (stringOption.getType() == OptionType.CONST) {
                    return this.editConst(existing, stringOption.getDefaultValue(), (String)value);
                }
                throw new AssertionError((Object)OptionAnnotatedSource.jvmdowngrader$concat$edit$1(String.valueOf((Object)stringOption.getType())));
            }).orElse(existing);
        }
        return existing;
    }

    private String editConst(String line, String currentValue, String newValue) {
        int equalsIndex = line.indexOf(61);
        if (equalsIndex == -1) {
            throw new IllegalStateException();
        }
        String firstPart = line.substring(0, equalsIndex);
        String secondPart = line.substring(equalsIndex);
        secondPart = secondPart.replaceFirst(Pattern.quote(currentValue), Matcher.quoteReplacement(newValue));
        return OptionAnnotatedSource.jvmdowngrader$concat$editConst$1(firstPart, secondPart);
    }

    private static boolean hasLeadingComment(String line) {
        return line.trim().startsWith("//");
    }

    private static String removeLeadingComment(String line) {
        ParsedString parsed = new ParsedString(line);
        parsed.takeSomeWhitespace();
        parsed.takeComments();
        return parsed.takeRest();
    }

    private static String setBooleanDefineValue(String line, OptionalBoolean newValue, boolean defaultValue) {
        if (OptionAnnotatedSource.hasLeadingComment(line) && newValue.orElse(defaultValue)) {
            return OptionAnnotatedSource.removeLeadingComment(line);
        }
        if (!newValue.orElse(defaultValue)) {
            return OptionAnnotatedSource.jvmdowngrader$concat$setBooleanDefineValue$1(line);
        }
        return line;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseConst$1(String string) {
        return "Expected true or false as the value of a boolean const option, but got " + string + ".";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseConst$2(String string) {
        return "This was a valid const boolean option declaration, but " + string + " was not recognized as being a name of one of the configurable const options.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseConst$3(String string) {
        return "This was a valid const option declaration, but " + string + " was not recognized as being a name of one of the configurable const options.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$edit$1(String string) {
        return "Unknown option type " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$editConst$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setBooleanDefineValue$1(String string) {
        return "//" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$edit$0$1(String string, String string2) {
        return "#define " + string + " " + string2 + " // OptionAnnotatedSource: Changed option";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=OptionAnnotatedSource.class)
    private static class AnnotationsBuilder {
        private final ImmutableMap.Builder<Integer, BooleanOption> booleanOptions = ImmutableMap.builder();
        private final ImmutableMap.Builder<Integer, StringOption> stringOptions = ImmutableMap.builder();
        private final ImmutableMap.Builder<Integer, String> diagnostics = ImmutableMap.builder();
        private final Map<String, IntList> booleanDefineReferences = new HashMap<String, IntList>();

        AnnotationsBuilder() {
        }

        public /* synthetic */ ImmutableMap.Builder jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$diagnostics() {
            return this.diagnostics;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$set$diagnostics(ImmutableMap.Builder builder) {
            this.diagnostics = builder;
        }

        public /* synthetic */ Map jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanDefineReferences() {
            return this.booleanDefineReferences;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$set$booleanDefineReferences(Map map) {
            this.booleanDefineReferences = map;
        }

        public /* synthetic */ ImmutableMap.Builder jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$stringOptions() {
            return this.stringOptions;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$set$stringOptions(ImmutableMap.Builder builder) {
            this.stringOptions = builder;
        }

        public /* synthetic */ ImmutableMap.Builder jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$get$booleanOptions() {
            return this.booleanOptions;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_option_OptionAnnotatedSource$AnnotationsBuilder$set$booleanOptions(ImmutableMap.Builder builder) {
            this.booleanOptions = builder;
        }
    }
}

