/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.glsm.states.BlendState;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.AlphaTestOverride;
import net.coderbot.iris.gl.blending.BlendModeFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendInformation;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.framebuffer.ViewportData;
import net.coderbot.iris.gl.image.ImageInformation;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.texture.TextureDefinition;
import net.coderbot.iris.gl.texture.TextureScaleOverride;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.IndirectPointer;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ShadowCullState;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Minecraft;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ShaderProperties {
    private final CustomUniforms.Builder customUniforms = new CustomUniforms.Builder();
    private CloudSetting cloudSetting = CloudSetting.DEFAULT;
    private CloudSetting dhCloudSetting = CloudSetting.DEFAULT;
    private OptionalBoolean oldHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean dynamicHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean supportsColorCorrection = OptionalBoolean.DEFAULT;
    private OptionalBoolean oldLighting = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTerrain = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowPlayer = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowBlockEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowLightBlockEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean underwaterOverlay = OptionalBoolean.DEFAULT;
    private OptionalBoolean sun = OptionalBoolean.DEFAULT;
    private OptionalBoolean moon = OptionalBoolean.DEFAULT;
    private OptionalBoolean stars = OptionalBoolean.DEFAULT;
    private OptionalBoolean sky = OptionalBoolean.DEFAULT;
    private OptionalBoolean weather = OptionalBoolean.DEFAULT;
    private OptionalBoolean weatherParticles = OptionalBoolean.DEFAULT;
    private OptionalBoolean vignette = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceSolid = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutout = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutoutMipped = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean rainDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean concurrentCompute = OptionalBoolean.DEFAULT;
    private OptionalBoolean beaconBeamDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateAo = OptionalBoolean.DEFAULT;
    private OptionalBoolean voxelizeLightBlocks = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateEntityDraws = OptionalBoolean.DEFAULT;
    private OptionalBoolean frustumCulling = OptionalBoolean.DEFAULT;
    private OptionalBoolean occlusionCulling = OptionalBoolean.DEFAULT;
    private ShadowCullState shadowCulling = ShadowCullState.DEFAULT;
    private OptionalBoolean shadowEnabled = OptionalBoolean.DEFAULT;
    private OptionalBoolean dhShadowEnabled = OptionalBoolean.DEFAULT;
    private Optional<ParticleRenderingSettings> particleRenderingSettings = Optional.empty();
    private OptionalBoolean prepareBeforeShadow = OptionalBoolean.DEFAULT;
    private List<String> sliderOptions = new ArrayList<String>();
    private final Map<String, List<String>> profiles = new LinkedHashMap<String, List<String>>();
    private List<String> mainScreenOptions = null;
    private final Map<String, List<String>> subScreenOptions = new HashMap<String, List<String>>();
    private Integer mainScreenColumnCount = null;
    private final Map<String, Integer> subScreenColumnCount = new HashMap<String, Integer>();
    private int fallbackTex = 0;
    private final Object2ObjectMap<String, AlphaTestOverride> alphaTestOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ViewportData> viewportScaleOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, TextureScaleOverride> textureScaleOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, BlendModeOverride> blendModeOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, IndirectPointer> indirectPointers = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ArrayList<BufferBlendInformation>> bufferBlendOverrides = new Object2ObjectOpenHashMap();
    private final EnumMap<TextureStage, Object2ObjectMap<String, TextureDefinition>> customTextures = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> customTexturePatching = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private String noiseTexturePath = null;
    private Object2ObjectMap<String, String> conditionallyEnabledPrograms = new Object2ObjectOpenHashMap();
    private List<String> requiredFeatureFlags = new ArrayList<String>();
    private List<String> optionalFeatureFlags = new ArrayList<String>();
    private final Object2ObjectMap<String, ImageInformation> customImages = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<ShaderStorageInfo> bufferObjects = new Int2ObjectOpenHashMap();
    private final Object2ObjectMap<String, TextureDefinition> irisCustomTextures = new Object2ObjectOpenHashMap();
    private int customTexAmount;

    private ShaderProperties() {
    }

    public ShaderProperties(String contents, ShaderPackOptions shaderPackOptions, Iterable<StringPair> environmentDefines) {
        String preprocessedContents = PropertiesPreprocessor.preprocessSource(contents, shaderPackOptions, environmentDefines);
        if (PatchedShaderPrinter.prettyPrintShaders) {
            try {
                Files.write(Minecraft.func_71410_x().field_71412_D.toPath().resolve("preprocessed.properties"), preprocessedContents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                Files.write(Minecraft.func_71410_x().field_71412_D.toPath().resolve("original.properties"), contents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        OrderBackedProperties preprocessed = new OrderBackedProperties();
        OrderBackedProperties original = new OrderBackedProperties();
        try {
            preprocessed.load(new StringReader(preprocessedContents));
            original.load(new StringReader(contents));
        }
        catch (IOException e) {
            Iris.logger.error("Error loading shaders.properties!", e);
        }
        ((Properties)preprocessed).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            if ("texture.noise".equals(key)) {
                this.noiseTexturePath = value;
                return;
            }
            if ("clouds".equals(key)) {
                if ("off".equals(value)) {
                    this.cloudSetting = CloudSetting.OFF;
                } else if ("fast".equals(value)) {
                    this.cloudSetting = CloudSetting.FAST;
                } else if ("fancy".equals(value)) {
                    this.cloudSetting = CloudSetting.FANCY;
                } else {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$0$1(value));
                }
                if (this.dhCloudSetting == CloudSetting.DEFAULT) {
                    this.dhCloudSetting = this.cloudSetting;
                }
            }
            if ("dhClouds".equals(key)) {
                if ("off".equals(value)) {
                    this.dhCloudSetting = CloudSetting.OFF;
                } else if ("on".equals(value) || "fancy".equals(value)) {
                    this.dhCloudSetting = CloudSetting.FANCY;
                } else {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$0$2(value));
                }
            }
            if ("shadow.culling".equals(key)) {
                if ("false".equals(value)) {
                    this.shadowCulling = ShadowCullState.DISTANCE;
                } else if ("true".equals(value)) {
                    this.shadowCulling = ShadowCullState.ADVANCED;
                } else if ("reversed".equals(value) || "safe_zone".equals(value)) {
                    this.shadowCulling = ShadowCullState.SAFE_ZONE;
                } else {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$0$3(value));
                }
            }
            ShaderProperties.handleBooleanDirective(key, value, "oldHandLight", bool -> {
                this.oldHandLight = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "dynamicHandLight", bool -> {
                this.dynamicHandLight = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "oldLighting", bool -> {
                this.oldLighting = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowTerrain", bool -> {
                this.shadowTerrain = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowTranslucent", bool -> {
                this.shadowTranslucent = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowEntities", bool -> {
                this.shadowEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowPlayer", bool -> {
                this.shadowPlayer = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowBlockEntities", bool -> {
                this.shadowBlockEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowLightBlockEntities", bool -> {
                this.shadowLightBlockEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "underwaterOverlay", bool -> {
                this.underwaterOverlay = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "sun", bool -> {
                this.sun = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "moon", bool -> {
                this.moon = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "stars", bool -> {
                this.stars = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "sky", bool -> {
                this.sky = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "vignette", bool -> {
                this.vignette = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.solid", bool -> {
                this.backFaceSolid = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.cutout", bool -> {
                this.backFaceCutout = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.cutoutMipped", bool -> {
                this.backFaceCutoutMipped = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.translucent", bool -> {
                this.backFaceTranslucent = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "rain.depth", bool -> {
                this.rainDepth = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "allowConcurrentCompute", bool -> {
                this.concurrentCompute = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "beacon.beam.depth", bool -> {
                this.beaconBeamDepth = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "separateAo", bool -> {
                this.separateAo = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "voxelizeLightBlocks", bool -> {
                this.voxelizeLightBlocks = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "separateEntityDraws", bool -> {
                this.separateEntityDraws = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "frustum.culling", bool -> {
                this.frustumCulling = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "occlusion.culling", bool -> {
                this.occlusionCulling = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadow.enabled", bool -> {
                this.shadowEnabled = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "dhShadow.enabled", bool -> {
                this.dhShadowEnabled = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "particles.before.deferred", bool -> {
                if (bool.orElse(false) && J_U_Optional.isEmpty(this.particleRenderingSettings)) {
                    this.particleRenderingSettings = Optional.of(ParticleRenderingSettings.BEFORE);
                }
            });
            ShaderProperties.handleBooleanDirective(key, value, "prepareBeforeShadow", bool -> {
                this.prepareBeforeShadow = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "supportsColorCorrection", bool -> {
                this.supportsColorCorrection = bool;
            });
            ShaderProperties.handleIntDirective(key, value, "fallbackTex", val -> {
                this.fallbackTex = val;
            });
            if ("weather".equals(key)) {
                String[] parts = value.split(" ");
                OptionalBoolean optionalBoolean = this.weather = parts[0].equals("true") ? OptionalBoolean.TRUE : OptionalBoolean.FALSE;
                if (parts.length > 1) {
                    OptionalBoolean optionalBoolean2 = this.weatherParticles = parts[1].equals("true") ? OptionalBoolean.TRUE : OptionalBoolean.FALSE;
                }
            }
            if (key.startsWith("particles.ordering")) {
                Optional<ParticleRenderingSettings> settings = ParticleRenderingSettings.fromString(value.trim().toUpperCase(Locale.ROOT));
                if (settings.isPresent()) {
                    this.particleRenderingSettings = settings;
                } else {
                    throw new RuntimeException(ShaderProperties.jvmdowngrader$concat$lambda$new$0$4(value));
                }
            }
            ShaderProperties.handlePassDirective("scale.", key, value, pass -> {
                float scale;
                float offsetX = 0.0f;
                float offsetY = 0.0f;
                String[] parts = value.split(" ");
                try {
                    scale = Float.parseFloat(parts[0]);
                    if (parts.length > 1) {
                        offsetX = Float.parseFloat(parts[1]);
                        offsetY = Float.parseFloat(parts[2]);
                    }
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$34$1(pass, value), e);
                    return;
                }
                this.viewportScaleOverrides.put(pass, (Object)new ViewportData(scale, offsetX, offsetY));
            });
            ShaderProperties.handlePassDirective("size.buffer.", key, value, pass -> {
                String[] parts = value.split(" ");
                if (parts.length != 2) {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$35$1(pass, value));
                    return;
                }
                this.textureScaleOverrides.put(pass, (Object)new TextureScaleOverride(parts[0], parts[1]));
            });
            ShaderProperties.handlePassDirective("alphaTest.", key, value, pass -> {
                float reference;
                if ("off".equals(value) || "false".equals(value)) {
                    this.alphaTestOverrides.put(pass, (Object)AlphaTestOverride.OFF);
                    return;
                }
                String[] parts = value.split(" ");
                if (parts.length > 2) {
                    Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$lambda$new$36$1(pass, value));
                } else if (parts.length < 2) {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$36$2(pass, value));
                    return;
                }
                Optional<AlphaTestFunction> function = AlphaTestFunction.fromString(parts[0]);
                if (!function.isPresent()) {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$36$1(pass, parts[0], value));
                    return;
                }
                try {
                    reference = Float.parseFloat(parts[1]);
                }
                catch (NumberFormatException e) {
                    Iris.logger.error(ShaderProperties.jvmdowngrader$concat$lambda$new$36$3(pass, value), e);
                    return;
                }
                this.alphaTestOverrides.put(pass, (Object)new AlphaTestOverride(new AlphaTest(function.get(), reference)));
            });
            ShaderProperties.handlePassDirective("blend.", key, value, pass -> {
                if (pass.contains(".")) {
                    if (!RenderSystem.supportsBufferBlending()) {
                        Iris.logger.warn("Per-buffer blending directive '{}' ignored - buffer blending requires OpenGL 4.0 or GL_ARB_draw_buffers_blend", key);
                        return;
                    }
                    String[] parts = pass.split("\\.");
                    int index = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf((Object)parts[1]);
                    if (index == -1 && parts[1].startsWith("colortex")) {
                        String id = parts[1].substring("colortex".length());
                        try {
                            index = Integer.parseInt(id);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Failed to parse buffer blend!", e);
                        }
                    }
                    if (index == -1) {
                        throw new RuntimeException(ShaderProperties.jvmdowngrader$concat$lambda$new$37$1(index));
                    }
                    if ("off".equals(value)) {
                        ((ArrayList)this.bufferBlendOverrides.computeIfAbsent((Object)parts[0], list -> new ArrayList())).add(new BufferBlendInformation(index, null));
                        return;
                    }
                    String[] modeArray = value.split(" ");
                    int[] modes = new int[modeArray.length];
                    int i = 0;
                    for (String modeName : modeArray) {
                        modes[i] = BlendModeFunction.fromString(modeName).get().getGlId();
                        ++i;
                    }
                    ((ArrayList)this.bufferBlendOverrides.computeIfAbsent((Object)parts[0], list -> new ArrayList())).add(new BufferBlendInformation(index, new BlendState(modes[0], modes[1], modes[2], modes[3])));
                    return;
                }
                if ("off".equals(value)) {
                    this.blendModeOverrides.put(pass, (Object)BlendModeOverride.OFF);
                    return;
                }
                String[] modeArray = value.split(" ");
                int[] modes = new int[modeArray.length];
                int i = 0;
                for (String modeName : modeArray) {
                    modes[i] = BlendModeFunction.fromString(modeName).get().getGlId();
                    ++i;
                }
                this.blendModeOverrides.put(pass, (Object)new BlendModeOverride(new BlendState(modes[0], modes[1], modes[2], modes[3])));
            });
            ShaderProperties.handleProgramEnabledDirective("program.", key, value, program -> this.conditionallyEnabledPrograms.put(program, (Object)value));
            ShaderProperties.handlePassDirective("indirect.", key, value, pass -> {
                try {
                    String[] locations = value.split(" ");
                    this.indirectPointers.put(pass, (Object)new IndirectPointer(Integer.parseInt(locations[0]), Long.parseLong(locations[1])));
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    Iris.logger.fatal(ShaderProperties.jvmdowngrader$concat$lambda$new$41$1(pass, value));
                }
            });
            ShaderProperties.handleTwoArgDirective("texture.", key, value, (stageName, samplerName) -> {
                String[] parts = value.split(" ");
                samplerName = samplerName.split("\\.")[0];
                Optional<TextureStage> optionalTextureStage = TextureStage.parse(stageName);
                if (!optionalTextureStage.isPresent()) {
                    Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$lambda$new$42$1(stageName, key));
                    return;
                }
                TextureStage stage = optionalTextureStage.get();
                if (parts.length > 1) {
                    String newSamplerName = ShaderProperties.jvmdowngrader$concat$lambda$new$42$1(this.customTexAmount);
                    ++this.customTexAmount;
                    TextureType type = null;
                    if (parts.length == 6) {
                        type = TextureType.TEXTURE_1D;
                        this.irisCustomTextures.put((Object)newSamplerName, (Object)new TextureDefinition.RawDefinition(parts[0], TextureType.valueOf(parts[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(parts[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(parts[3]), 0, 0, PixelFormat.fromString(parts[4]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(parts[5]).orElseThrow(IllegalArgumentException::new)));
                    } else if (parts.length == 7) {
                        type = TextureType.valueOf(parts[1].toUpperCase(Locale.ROOT));
                        this.irisCustomTextures.put((Object)newSamplerName, (Object)new TextureDefinition.RawDefinition(parts[0], TextureType.valueOf(parts[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(parts[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), 0, PixelFormat.fromString(parts[5]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(parts[6]).orElseThrow(IllegalArgumentException::new)));
                    } else if (parts.length == 8) {
                        type = TextureType.TEXTURE_3D;
                        this.irisCustomTextures.put((Object)newSamplerName, (Object)new TextureDefinition.RawDefinition(parts[0], TextureType.valueOf(parts[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(parts[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), Integer.parseInt(parts[5]), PixelFormat.fromString(parts[6]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(parts[7]).orElseThrow(IllegalArgumentException::new)));
                    } else {
                        Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$lambda$new$42$2(key, value));
                    }
                    if (type != null) {
                        this.customTexturePatching.put(new Tri<String, TextureType, TextureStage>((String)samplerName, type, stage), (Object)newSamplerName);
                    }
                    return;
                }
                this.customTextures.computeIfAbsent(stage, _stage -> new Object2ObjectOpenHashMap()).put(samplerName, (Object)new TextureDefinition.PNGDefinition(value));
            });
            ShaderProperties.handleTwoArgDirective("flip.", key, value, (pass, buffer) -> ShaderProperties.handleBooleanValue(key, value, shouldFlip -> ((Object2BooleanMap)this.explicitFlips.computeIfAbsent(pass, _pass -> new Object2BooleanOpenHashMap())).put(buffer, shouldFlip)));
            ShaderProperties.handleWhitespacedListDirective(key, value, "iris.features.required", options -> {
                this.requiredFeatureFlags = options;
            });
            ShaderProperties.handleWhitespacedListDirective(key, value, "iris.features.optional", options -> {
                this.optionalFeatureFlags = options;
            });
            ShaderProperties.handlePassDirective("image.", key, value, imageName -> this.parseCustomImage((String)imageName, value));
            ShaderProperties.handlePassDirective("bufferObject.", key, value, indexStr -> this.parseBufferObject((String)indexStr, value));
            ShaderProperties.handlePassDirective("customTexture.", key, value, samplerName -> {
                TextureDefinition definition = this.parseTextureDefinition(ShaderProperties.jvmdowngrader$concat$lambda$new$51$1(samplerName), value);
                if (definition != null) {
                    this.irisCustomTextures.put(samplerName, (Object)definition);
                    Iris.logger.debug("[CustomTextures] Parsed customTexture.{} = {}", samplerName, value);
                }
            });
            ShaderProperties.handlePassDirective("variable.", key, value, pass -> {
                String[] parts = pass.split("\\.");
                if (parts.length != 2) {
                    Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$lambda$new$52$1(key));
                    return;
                }
                this.customUniforms.addVariable(parts[0], parts[1], value, false);
            });
            ShaderProperties.handlePassDirective("uniform.", key, value, pass -> {
                String[] parts = pass.split("\\.");
                if (parts.length != 2) {
                    Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$lambda$new$53$1(key));
                    return;
                }
                this.customUniforms.addVariable(parts[0], parts[1], value, true);
            });
        }));
        ((Properties)original).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            ShaderProperties.handleWhitespacedListDirective(key, value, "sliders", sliders -> {
                this.sliderOptions = sliders;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("profile.", key, value, this.profiles::put);
            if (ShaderProperties.handleIntDirective(key, value, "screen.columns", columns -> {
                this.mainScreenColumnCount = columns;
            })) {
                return;
            }
            if (ShaderProperties.handleAffixedIntDirective("screen.", ".columns", key, value, this.subScreenColumnCount::put)) {
                return;
            }
            ShaderProperties.handleWhitespacedListDirective(key, value, "screen", options -> {
                this.mainScreenOptions = options;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("screen.", key, value, this.subScreenOptions::put);
        }));
    }

    private static void handleBooleanValue(String key, String value, BooleanConsumer handler) {
        if ("true".equals(value)) {
            handler.accept(true);
        } else if ("false".equals(value)) {
            handler.accept(false);
        } else {
            Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$handleBooleanValue$1(key, value));
        }
    }

    private static void handleBooleanDirective(String key, String value, String expectedKey, Consumer<OptionalBoolean> handler) {
        if (!expectedKey.equals(key)) {
            return;
        }
        if ("true".equals(value)) {
            handler.accept(OptionalBoolean.TRUE);
        } else if ("false".equals(value)) {
            handler.accept(OptionalBoolean.FALSE);
        } else {
            Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$handleBooleanValue$1(key, value));
        }
    }

    private static boolean handleIntDirective(String key, String value, String expectedKey, Consumer<Integer> handler) {
        if (!expectedKey.equals(key)) {
            return false;
        }
        try {
            int result = Integer.parseInt(value);
            handler.accept(result);
        }
        catch (NumberFormatException nex) {
            Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$handleIntDirective$1(key, value));
        }
        return true;
    }

    private static boolean handleAffixedIntDirective(String prefix, String suffix, String key, String value, BiConsumer<String, Integer> handler) {
        if (key.startsWith(prefix) && key.endsWith(suffix)) {
            int substrBegin = prefix.length();
            int substrEnd = key.length() - suffix.length();
            if (substrEnd <= substrBegin) {
                return false;
            }
            String affixStrippedKey = key.substring(substrBegin, substrEnd);
            try {
                int result = Integer.parseInt(value);
                handler.accept(affixStrippedKey, result);
            }
            catch (NumberFormatException nex) {
                Iris.logger.warn(ShaderProperties.jvmdowngrader$concat$handleIntDirective$1(key, value));
            }
            return true;
        }
        return false;
    }

    private static void handlePassDirective(String prefix, String key, String value, Consumer<String> handler) {
        if (key.startsWith(prefix)) {
            String pass = key.substring(prefix.length());
            handler.accept(pass);
        }
    }

    private static void handleProgramEnabledDirective(String prefix, String key, String value, Consumer<String> handler) {
        if (key.startsWith(prefix)) {
            String program = key.substring(prefix.length(), key.indexOf(".", prefix.length()));
            handler.accept(program);
        }
    }

    private static void handleWhitespacedListDirective(String key, String value, String expectedKey, Consumer<List<String>> handler) {
        if (!expectedKey.equals(key)) {
            return;
        }
        String[] elements = value.split(" +");
        handler.accept(Arrays.asList(elements));
    }

    private static void handlePrefixedWhitespacedListDirective(String prefix, String key, String value, BiConsumer<String, List<String>> handler) {
        if (key.startsWith(prefix)) {
            String prefixStrippedKey = key.substring(prefix.length());
            String[] elements = value.split(" +");
            handler.accept(prefixStrippedKey, Arrays.asList(elements));
        }
    }

    private static void handleTwoArgDirective(String prefix, String key, String value, BiConsumer<String, String> handler) {
        if (key.startsWith(prefix)) {
            int endOfPassIndex = key.indexOf(".", prefix.length());
            String stage = key.substring(prefix.length(), endOfPassIndex);
            String sampler = key.substring(endOfPassIndex + 1);
            handler.accept(stage, sampler);
        }
    }

    public static ShaderProperties empty() {
        return new ShaderProperties();
    }

    public Optional<String> getNoiseTexturePath() {
        return Optional.ofNullable(this.noiseTexturePath);
    }

    public Optional<List<String>> getMainScreenOptions() {
        return Optional.ofNullable(this.mainScreenOptions);
    }

    public Optional<Integer> getMainScreenColumnCount() {
        return Optional.ofNullable(this.mainScreenColumnCount);
    }

    public Optional<ParticleRenderingSettings> getParticleRenderingSettings() {
        if (this.separateEntityDraws == OptionalBoolean.TRUE) {
            return Optional.of(ParticleRenderingSettings.MIXED);
        }
        return this.particleRenderingSettings;
    }

    private void parseCustomImage(String imageName, String value) {
        if (this.customImages.size() >= 16) {
            Iris.logger.error(ShaderProperties.jvmdowngrader$concat$parseCustomImage$1(imageName));
            return;
        }
        String[] parts = value.split("\\s+");
        if (parts.length < 6) {
            Iris.logger.error(ShaderProperties.jvmdowngrader$concat$parseCustomImage$1(imageName, parts.length));
            return;
        }
        try {
            ImageInformation imageInfo;
            Optional<PixelFormat> pixelFormatOpt;
            String samplerName = parts[0];
            if (samplerName.equals("none") || samplerName.equals("null") || samplerName.isEmpty()) {
                samplerName = null;
            }
            if (!(pixelFormatOpt = PixelFormat.fromString(parts[1].toUpperCase())).isPresent()) {
                Iris.logger.error("Invalid pixel format for custom image {}: {}", imageName, parts[1]);
                return;
            }
            PixelFormat pixelFormat = pixelFormatOpt.get();
            Optional<InternalTextureFormat> internalFormatOpt = InternalTextureFormat.fromString(parts[2].toUpperCase());
            if (!internalFormatOpt.isPresent()) {
                Iris.logger.error("Invalid internal format for custom image {}: {}", imageName, parts[2]);
                return;
            }
            InternalTextureFormat internalFormat = internalFormatOpt.get();
            Optional<PixelType> pixelTypeOpt = PixelType.fromString(parts[3].toUpperCase());
            if (!pixelTypeOpt.isPresent()) {
                Iris.logger.error("Invalid pixel type for custom image {}: {}", imageName, parts[3]);
                return;
            }
            PixelType pixelType = pixelTypeOpt.get();
            boolean clear = Boolean.parseBoolean(parts[4]);
            boolean relative = Boolean.parseBoolean(parts[5]);
            if (parts.length == 7) {
                int width = Integer.parseInt(parts[6]);
                imageInfo = new ImageInformation(imageName, samplerName, TextureType.TEXTURE_1D, pixelFormat, internalFormat, pixelType, width, 1, 1, clear, false, 1.0f, 1.0f);
            } else if (parts.length == 8) {
                if (relative) {
                    float relativeWidth = Float.parseFloat(parts[6]);
                    float relativeHeight = Float.parseFloat(parts[7]);
                    imageInfo = new ImageInformation(imageName, samplerName, TextureType.TEXTURE_2D, pixelFormat, internalFormat, pixelType, 0, 0, 1, clear, true, relativeWidth, relativeHeight);
                } else {
                    int width = Integer.parseInt(parts[6]);
                    int height = Integer.parseInt(parts[7]);
                    imageInfo = new ImageInformation(imageName, samplerName, TextureType.TEXTURE_2D, pixelFormat, internalFormat, pixelType, width, height, 1, clear, false, 1.0f, 1.0f);
                }
            } else if (parts.length >= 9) {
                int width = Integer.parseInt(parts[6]);
                int height = Integer.parseInt(parts[7]);
                int depth = Integer.parseInt(parts[8]);
                imageInfo = new ImageInformation(imageName, samplerName, TextureType.TEXTURE_3D, pixelFormat, internalFormat, pixelType, width, height, depth, clear, false, 1.0f, 1.0f);
            } else {
                Iris.logger.error("Invalid custom image directive for {}: expected dimensions", imageName);
                return;
            }
            this.customImages.put((Object)imageName, (Object)imageInfo);
            Iris.logger.debug("[CustomImages] Parsed custom image: {} -> {}", new Object[]{imageName, imageInfo});
        }
        catch (NumberFormatException e) {
            Iris.logger.error("Failed to parse dimensions for custom image {}: {}", imageName, e.getMessage());
        }
    }

    private void parseBufferObject(String indexStr, String value) {
        try {
            ShaderStorageInfo info;
            int index = Integer.parseInt(indexStr);
            if (index > 8) {
                Iris.logger.error(ShaderProperties.jvmdowngrader$concat$parseBufferObject$1(index));
                return;
            }
            String[] parts = value.split("\\s+");
            if (parts.length < 1) {
                Iris.logger.error(ShaderProperties.jvmdowngrader$concat$parseBufferObject$2(index));
                return;
            }
            int size = Integer.parseInt(parts[0]);
            if (size < 1) {
                return;
            }
            if (parts.length >= 4 && "true".equalsIgnoreCase(parts[1])) {
                float scaleX = Float.parseFloat(parts[2]);
                float scaleY = Float.parseFloat(parts[3]);
                info = new ShaderStorageInfo(size, true, scaleX, scaleY);
            } else {
                info = new ShaderStorageInfo(size, false, 1.0f, 1.0f);
            }
            this.bufferObjects.put(index, (Object)info);
            Iris.logger.debug(ShaderProperties.jvmdowngrader$concat$parseBufferObject$1(index, String.valueOf((Object)info)));
        }
        catch (NumberFormatException e) {
            Iris.logger.error(ShaderProperties.jvmdowngrader$concat$parseBufferObject$1(indexStr, e.getMessage()));
        }
    }

    private TextureDefinition parseTextureDefinition(String key, String value) {
        String[] parts = value.split(" ");
        if (parts.length == 1) {
            return new TextureDefinition.PNGDefinition(value);
        }
        try {
            if (parts.length == 6) {
                Optional<TextureType> targetOpt = TextureType.fromString(parts[1].toUpperCase(Locale.ROOT));
                if (!targetOpt.isPresent()) {
                    Iris.logger.error("Invalid texture type for {}: {}", key, parts[1]);
                    return null;
                }
                Optional<InternalTextureFormat> internalFormatOpt = InternalTextureFormat.fromString(parts[2].toUpperCase(Locale.ROOT));
                if (!internalFormatOpt.isPresent()) {
                    Iris.logger.error("Invalid internal format for {}: {}", key, parts[2]);
                    return null;
                }
                Optional<PixelFormat> formatOpt = PixelFormat.fromString(parts[4].toUpperCase(Locale.ROOT));
                if (!formatOpt.isPresent()) {
                    Iris.logger.error("Invalid pixel format for {}: {}", key, parts[4]);
                    return null;
                }
                Optional<PixelType> pixelTypeOpt = PixelType.fromString(parts[5].toUpperCase(Locale.ROOT));
                if (!pixelTypeOpt.isPresent()) {
                    Iris.logger.error("Invalid pixel type for {}: {}", key, parts[5]);
                    return null;
                }
                return new TextureDefinition.RawDefinition(parts[0], targetOpt.get(), internalFormatOpt.get(), Integer.parseInt(parts[3]), 0, 0, formatOpt.get(), pixelTypeOpt.get());
            }
            if (parts.length == 7) {
                Optional<TextureType> targetOpt = TextureType.fromString(parts[1].toUpperCase(Locale.ROOT));
                if (!targetOpt.isPresent()) {
                    Iris.logger.error("Invalid texture type for {}: {}", key, parts[1]);
                    return null;
                }
                Optional<InternalTextureFormat> internalFormatOpt = InternalTextureFormat.fromString(parts[2].toUpperCase(Locale.ROOT));
                if (!internalFormatOpt.isPresent()) {
                    Iris.logger.error("Invalid internal format for {}: {}", key, parts[2]);
                    return null;
                }
                Optional<PixelFormat> formatOpt = PixelFormat.fromString(parts[5].toUpperCase(Locale.ROOT));
                if (!formatOpt.isPresent()) {
                    Iris.logger.error("Invalid pixel format for {}: {}", key, parts[5]);
                    return null;
                }
                Optional<PixelType> pixelTypeOpt = PixelType.fromString(parts[6].toUpperCase(Locale.ROOT));
                if (!pixelTypeOpt.isPresent()) {
                    Iris.logger.error("Invalid pixel type for {}: {}", key, parts[6]);
                    return null;
                }
                return new TextureDefinition.RawDefinition(parts[0], targetOpt.get(), internalFormatOpt.get(), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), 0, formatOpt.get(), pixelTypeOpt.get());
            }
            if (parts.length == 8) {
                Optional<TextureType> targetOpt = TextureType.fromString(parts[1].toUpperCase(Locale.ROOT));
                if (!targetOpt.isPresent()) {
                    Iris.logger.error("Invalid texture type for {}: {}", key, parts[1]);
                    return null;
                }
                Optional<InternalTextureFormat> internalFormatOpt = InternalTextureFormat.fromString(parts[2].toUpperCase(Locale.ROOT));
                if (!internalFormatOpt.isPresent()) {
                    Iris.logger.error("Invalid internal format for {}: {}", key, parts[2]);
                    return null;
                }
                Optional<PixelFormat> formatOpt = PixelFormat.fromString(parts[6].toUpperCase(Locale.ROOT));
                if (!formatOpt.isPresent()) {
                    Iris.logger.error("Invalid pixel format for {}: {}", key, parts[6]);
                    return null;
                }
                Optional<PixelType> pixelTypeOpt = PixelType.fromString(parts[7].toUpperCase(Locale.ROOT));
                if (!pixelTypeOpt.isPresent()) {
                    Iris.logger.error("Invalid pixel type for {}: {}", key, parts[7]);
                    return null;
                }
                return new TextureDefinition.RawDefinition(parts[0], targetOpt.get(), internalFormatOpt.get(), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), Integer.parseInt(parts[5]), formatOpt.get(), pixelTypeOpt.get());
            }
            Iris.logger.warn("Unknown texture directive format for {}: {} (expected 1, 6, 7, or 8 parts, got {})", key, value, parts.length);
            return null;
        }
        catch (NumberFormatException e) {
            Iris.logger.error("Failed to parse texture dimensions for {}: {}", key, e.getMessage());
            return null;
        }
    }

    @Generated
    public CustomUniforms.Builder getCustomUniforms() {
        return this.customUniforms;
    }

    @Generated
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Generated
    public CloudSetting getDhCloudSetting() {
        return this.dhCloudSetting;
    }

    @Generated
    public OptionalBoolean getOldHandLight() {
        return this.oldHandLight;
    }

    @Generated
    public OptionalBoolean getDynamicHandLight() {
        return this.dynamicHandLight;
    }

    @Generated
    public OptionalBoolean getSupportsColorCorrection() {
        return this.supportsColorCorrection;
    }

    @Generated
    public OptionalBoolean getOldLighting() {
        return this.oldLighting;
    }

    @Generated
    public OptionalBoolean getShadowTerrain() {
        return this.shadowTerrain;
    }

    @Generated
    public OptionalBoolean getShadowTranslucent() {
        return this.shadowTranslucent;
    }

    @Generated
    public OptionalBoolean getShadowEntities() {
        return this.shadowEntities;
    }

    @Generated
    public OptionalBoolean getShadowPlayer() {
        return this.shadowPlayer;
    }

    @Generated
    public OptionalBoolean getShadowBlockEntities() {
        return this.shadowBlockEntities;
    }

    @Generated
    public OptionalBoolean getShadowLightBlockEntities() {
        return this.shadowLightBlockEntities;
    }

    @Generated
    public OptionalBoolean getUnderwaterOverlay() {
        return this.underwaterOverlay;
    }

    @Generated
    public OptionalBoolean getSun() {
        return this.sun;
    }

    @Generated
    public OptionalBoolean getMoon() {
        return this.moon;
    }

    @Generated
    public OptionalBoolean getStars() {
        return this.stars;
    }

    @Generated
    public OptionalBoolean getSky() {
        return this.sky;
    }

    @Generated
    public OptionalBoolean getWeather() {
        return this.weather;
    }

    @Generated
    public OptionalBoolean getWeatherParticles() {
        return this.weatherParticles;
    }

    @Generated
    public OptionalBoolean getVignette() {
        return this.vignette;
    }

    @Generated
    public OptionalBoolean getBackFaceSolid() {
        return this.backFaceSolid;
    }

    @Generated
    public OptionalBoolean getBackFaceCutout() {
        return this.backFaceCutout;
    }

    @Generated
    public OptionalBoolean getBackFaceCutoutMipped() {
        return this.backFaceCutoutMipped;
    }

    @Generated
    public OptionalBoolean getBackFaceTranslucent() {
        return this.backFaceTranslucent;
    }

    @Generated
    public OptionalBoolean getRainDepth() {
        return this.rainDepth;
    }

    @Generated
    public OptionalBoolean getConcurrentCompute() {
        return this.concurrentCompute;
    }

    @Generated
    public OptionalBoolean getBeaconBeamDepth() {
        return this.beaconBeamDepth;
    }

    @Generated
    public OptionalBoolean getSeparateAo() {
        return this.separateAo;
    }

    @Generated
    public OptionalBoolean getVoxelizeLightBlocks() {
        return this.voxelizeLightBlocks;
    }

    @Generated
    public OptionalBoolean getSeparateEntityDraws() {
        return this.separateEntityDraws;
    }

    @Generated
    public OptionalBoolean getFrustumCulling() {
        return this.frustumCulling;
    }

    @Generated
    public OptionalBoolean getOcclusionCulling() {
        return this.occlusionCulling;
    }

    @Generated
    public ShadowCullState getShadowCulling() {
        return this.shadowCulling;
    }

    @Generated
    public OptionalBoolean getShadowEnabled() {
        return this.shadowEnabled;
    }

    @Generated
    public OptionalBoolean getDhShadowEnabled() {
        return this.dhShadowEnabled;
    }

    @Generated
    public OptionalBoolean getPrepareBeforeShadow() {
        return this.prepareBeforeShadow;
    }

    @Generated
    public List<String> getSliderOptions() {
        return this.sliderOptions;
    }

    @Generated
    public Map<String, List<String>> getProfiles() {
        return this.profiles;
    }

    @Generated
    public Map<String, List<String>> getSubScreenOptions() {
        return this.subScreenOptions;
    }

    @Generated
    public Map<String, Integer> getSubScreenColumnCount() {
        return this.subScreenColumnCount;
    }

    @Generated
    public int getFallbackTex() {
        return this.fallbackTex;
    }

    @Generated
    public Object2ObjectMap<String, AlphaTestOverride> getAlphaTestOverrides() {
        return this.alphaTestOverrides;
    }

    @Generated
    public Object2ObjectMap<String, ViewportData> getViewportScaleOverrides() {
        return this.viewportScaleOverrides;
    }

    @Generated
    public Object2ObjectMap<String, TextureScaleOverride> getTextureScaleOverrides() {
        return this.textureScaleOverrides;
    }

    @Generated
    public Object2ObjectMap<String, BlendModeOverride> getBlendModeOverrides() {
        return this.blendModeOverrides;
    }

    @Generated
    public Object2ObjectMap<String, IndirectPointer> getIndirectPointers() {
        return this.indirectPointers;
    }

    @Generated
    public Object2ObjectMap<String, ArrayList<BufferBlendInformation>> getBufferBlendOverrides() {
        return this.bufferBlendOverrides;
    }

    @Generated
    public EnumMap<TextureStage, Object2ObjectMap<String, TextureDefinition>> getCustomTextures() {
        return this.customTextures;
    }

    @Generated
    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getCustomTexturePatching() {
        return this.customTexturePatching;
    }

    @Generated
    public Object2ObjectMap<String, Object2BooleanMap<String>> getExplicitFlips() {
        return this.explicitFlips;
    }

    @Generated
    public Object2ObjectMap<String, String> getConditionallyEnabledPrograms() {
        return this.conditionallyEnabledPrograms;
    }

    @Generated
    public List<String> getRequiredFeatureFlags() {
        return this.requiredFeatureFlags;
    }

    @Generated
    public List<String> getOptionalFeatureFlags() {
        return this.optionalFeatureFlags;
    }

    @Generated
    public Object2ObjectMap<String, ImageInformation> getCustomImages() {
        return this.customImages;
    }

    @Generated
    public Int2ObjectMap<ShaderStorageInfo> getBufferObjects() {
        return this.bufferObjects;
    }

    @Generated
    public Object2ObjectMap<String, TextureDefinition> getIrisCustomTextures() {
        return this.irisCustomTextures;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleBooleanValue$1(String string, String string2) {
        return "Unexpected value for boolean key " + string + " in shaders.properties: got " + string2 + ", but expected either true or false";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleIntDirective$1(String string, String string2) {
        return "Unexpected value for integer key " + string + " in shaders.properties: got " + string2 + ", but expected an integer";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseCustomImage$1(String string) {
        return "Maximum of 16 custom images exceeded, cannot add: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseCustomImage$1(String string, int n) {
        return "Invalid custom image directive for " + string + ": expected at least 6 parts, got " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBufferObject$1(int n) {
        return "SSBO index " + n + " exceeds maximum of 8, buffers 9+ are reserved";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBufferObject$2(int n) {
        return "Invalid buffer object directive for index " + n + ": expected size";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBufferObject$1(int n, String string) {
        return "Parsed buffer object: " + n + " -> " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBufferObject$1(String string, String string2) {
        return "Failed to parse buffer object " + string + ": " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$1(String string) {
        return "Unrecognized clouds setting: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$2(String string) {
        return "Unrecognized DH clouds setting (need off, on): " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$3(String string) {
        return "Unrecognized shadow culling setting: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$4(String string) {
        return "Failed to parse particle rendering order! " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$53$1(String string) {
        return "Custom uniforms sould take the form of `uniform.<type>.<name> = <expression>. Ignoring " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$52$1(String string) {
        return "Custom variables should take the form of `variable.<type>.<name> = <expression>. Ignoring " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$51$1(String string) {
        return "customTexture." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$42$1(String string, String string2) {
        return "Unknown texture stage \"" + string + "\", ignoring custom texture directive for " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$42$1(int n) {
        return "customtex" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$42$2(String string, String string2) {
        return "Unknown texture directive for " + string + ": " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$41$1(String string, String string2) {
        return "Failed to parse indirect command for " + string + "! " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$37$1(int n) {
        return "Failed to parse buffer blend! index = " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$36$1(String string, String string2) {
        return "Weird alpha test directive for " + string + " contains more parts than we expected: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$36$2(String string, String string2) {
        return "Invalid alpha test directive for " + string + ": " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$36$1(String string, String string2, String string3) {
        return "Unable to parse alpha test directive for " + string + ", unknown alpha test function " + string2 + ": " + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$36$3(String string, String string2) {
        return "Unable to parse alpha test directive for " + string + ": " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$35$1(String string, String string2) {
        return "Unable to parse size.buffer directive for " + string + ": " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$34$1(String string, String string2) {
        return "Unable to parse scale directive for " + string + ": " + string2;
    }
}

