/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.image.ImageInformation;
import net.coderbot.iris.gl.texture.TextureDefinition;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderPackWorkarounds;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.include.IncludeProcessor;
import net.coderbot.iris.shaderpack.include.ShaderPackSourceNames;
import net.coderbot.iris.shaderpack.option.ProfileSet;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.api.v0.IrisApi;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class})
public class ShaderPack {
    private static final Gson GSON = new Gson();
    private static final Set<String> PINNED_DIMENSIONS = J_U_Set.of((Object)"Overworld", (Object)"Nether", (Object)"The End");
    private static final int MAX_DIMENSION_CACHE;
    public final CustomUniforms.Builder customUniforms;
    private final ProgramSet base;
    private final Set<FeatureFlags> activeFeatures;
    private final Map<String, String> dimensionMap;
    private final Map<String, ProgramSet> dimensionProgramSets;
    private final Set<String> foldersWithShaderFiles;
    private final Function<AbsolutePackPath, String> sourceProvider;
    private final ShaderProperties shaderProperties;
    private boolean hasLoggedCacheLimitReached = false;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<String, CustomTextureData> irisCustomTextureDataMap = new Object2ObjectOpenHashMap();
    private final CustomTextureData customNoiseTexture;
    private final Object2ObjectMap<String, ImageInformation> customImages;
    private final Int2ObjectMap<ShaderStorageInfo> bufferObjects;
    private final ShaderPackOptions shaderPackOptions;
    private final OptionMenuContainer menuContainer;
    private final ProfileSet.ProfileResult profile;
    private final String profileInfo;

    public ShaderPack(Path root, Iterable<StringPair> environmentDefines) throws IOException, IllegalStateException {
        this(root, Collections.emptyMap(), environmentDefines);
    }

    public ShaderPack(Path root, Map<String, String> changedConfigs, Iterable<StringPair> environmentDefines) throws IOException, IllegalStateException {
        IncludeGraph graph;
        Objects.requireNonNull(root);
        ImmutableList.Builder starts = ImmutableList.builder();
        ImmutableList<String> potentialFileNames = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/"), potentialFileNames);
        this.dimensionMap = new HashMap<String, String>();
        this.foldersWithShaderFiles = new HashSet<String>();
        Iris.logger.info("Dimension shader cache size: {} (3 vanilla pinned + {} modded), configurable via -Diris.dimensionCacheSize", MAX_DIMENSION_CACHE, Math.max(0, MAX_DIMENSION_CACHE - PINNED_DIMENSIONS.size()));
        this.dimensionProgramSets = new LinkedHashMap<String, ProgramSet>(Math.max(12, MAX_DIMENSION_CACHE), 0.75f, true);
        Optional<Properties> dimensionProperties = ShaderPack.loadPropertiesFile(root, "dimension.properties");
        boolean hasDimensionProperties = dimensionProperties.isPresent();
        ArrayList<String> dimensionFolders = new ArrayList<String>();
        if (hasDimensionProperties) {
            dimensionFolders.addAll(this.parseDimensionMap(dimensionProperties.get(), "dimension."));
        }
        if (!dimensionFolders.isEmpty()) {
            for (String folderName2 : dimensionFolders) {
                boolean folderExists = this.checkAndAddDimensionFolder((ImmutableList.Builder<AbsolutePackPath>)starts, root, potentialFileNames, folderName2);
                if (folderExists) {
                    this.foldersWithShaderFiles.add(folderName2);
                    continue;
                }
                Iris.logger.warn("dimension.properties references folder '{}' but it doesn't exist or has no shader files", folderName2);
            }
            if (!(this.dimensionMap.containsKey("*") || this.dimensionMap.containsKey("Overworld") || this.dimensionMap.containsKey("Nether") || this.dimensionMap.containsKey("The End"))) {
                Iris.logger.warn("dimension.properties exists but doesn't define mappings for vanilla dimensions (Overworld/Nether/End) or a wildcard (*)");
            }
        } else {
            if (hasDimensionProperties) {
                Iris.logger.warn("dimension.properties exists but has no valid dimension mappings, falling back to legacy folder detection");
            }
            HashSet foundFolders = new HashSet();
            try {
                Files.list(root).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(name -> name.matches("world-?\\d+")).forEach(folderName -> {
                    try {
                        boolean exists = this.checkAndAddDimensionFolder((ImmutableList.Builder<AbsolutePackPath>)starts, root, potentialFileNames, (String)folderName);
                        if (exists) {
                            foundFolders.add(folderName);
                            this.foldersWithShaderFiles.add((String)folderName);
                        }
                    }
                    catch (IOException e) {
                        Iris.logger.warn("Failed to scan dimension folder: {}", folderName, e);
                    }
                });
            }
            catch (IOException e) {
                Iris.logger.warn("Failed to scan for dimension folders", e);
            }
            if (foundFolders.contains("world0")) {
                this.dimensionMap.put("Overworld", "world0");
            }
            if (foundFolders.contains("world-1")) {
                this.dimensionMap.put("Nether", "world-1");
            }
            if (foundFolders.contains("world1")) {
                this.dimensionMap.put("The End", "world1");
            }
        }
        if (!(graph = new IncludeGraph(root, (ImmutableList<AbsolutePackPath>)starts.build())).getFailures().isEmpty()) {
            graph.getFailures().forEach((path, error) -> Iris.logger.error("{}", error.toString()));
            throw new IOException("Failed to resolve some #include directives, see previous messages for details");
        }
        this.languageMap = new LanguageMap(root.resolve("lang"));
        this.shaderPackOptions = new ShaderPackOptions(graph, changedConfigs);
        graph = this.shaderPackOptions.getIncludes();
        ArrayList<StringPair> finalEnvironmentDefines = new ArrayList<StringPair>();
        environmentDefines.forEach(finalEnvironmentDefines::add);
        for (FeatureFlags flag : FeatureFlags.values()) {
            boolean usable = flag.isUsable();
            Iris.logger.info("FeatureFlag {} usable: {}", flag.name(), usable);
            if (!usable) continue;
            finalEnvironmentDefines.add(new StringPair(ShaderPack.jvmdowngrader$concat$$init$$1(flag.name()), ""));
            if (flag != FeatureFlags.TESSELLATION_SHADERS) continue;
            finalEnvironmentDefines.add(new StringPair("IRIS_FEATURE_TESSELATION_SHADERS", ""));
        }
        Iris.logger.info("Environment defines: {}", finalEnvironmentDefines.stream().map(p -> ShaderPack.jvmdowngrader$concat$lambda$new$4$1(p.getKey(), p.getValue())).collect(Collectors.joining(", ")));
        this.shaderProperties = Optional.ofNullable(ShaderPack.readProperties(root, "shaders.properties")).map(source -> new ShaderProperties((String)source, this.shaderPackOptions, (Iterable<StringPair>)finalEnvironmentDefines)).orElseGet(ShaderProperties::empty);
        this.activeFeatures = new HashSet<FeatureFlags>();
        for (String flag : this.shaderProperties.getRequiredFeatureFlags()) {
            this.activeFeatures.add(FeatureFlags.getValue(flag));
        }
        for (String flag : this.shaderProperties.getOptionalFeatureFlags()) {
            this.activeFeatures.add(FeatureFlags.getValue(flag));
        }
        List invalidFlagList = this.shaderProperties.getRequiredFeatureFlags().stream().filter(FeatureFlags::isInvalid).map(FeatureFlags::getValue).collect(Collectors.toList());
        List invalidFeatureFlags = invalidFlagList.stream().map(FeatureFlags::getHumanReadableName).collect(Collectors.toList());
        if (!invalidFeatureFlags.isEmpty()) {
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(false);
        }
        ProfileSet profiles = ProfileSet.fromTree(this.shaderProperties.getProfiles(), this.shaderPackOptions.getOptionSet());
        this.profile = profiles.scan(this.shaderPackOptions.getOptionSet(), this.shaderPackOptions.getOptionValues());
        ArrayList disabledPrograms = new ArrayList();
        this.profile.current.ifPresent(profile -> disabledPrograms.addAll(profile.disabledPrograms));
        this.shaderProperties.getConditionallyEnabledPrograms().forEach((program, shaderOption) -> {
            if ("true".equals(shaderOption)) {
                return;
            }
            if ("false".equals(shaderOption) || !this.shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)shaderOption)) {
                disabledPrograms.add(program);
            }
        });
        this.menuContainer = new OptionMenuContainer(this.shaderProperties, this.shaderPackOptions, profiles);
        String profileName = this.getCurrentProfileName();
        MutableOptionValues profileOptions = new MutableOptionValues(this.shaderPackOptions.getOptionSet(), this.profile.current.map(p -> p.optionValues).orElse(new HashMap()));
        int userOptionsChanged = this.shaderPackOptions.getOptionValues().getOptionsChanged() - profileOptions.getOptionsChanged();
        this.profileInfo = ShaderPack.jvmdowngrader$concat$$init$$1(profileName, userOptionsChanged, userOptionsChanged == 1 ? "" : "s");
        Iris.logger.info(this.profileInfo);
        IncludeProcessor includeProcessor = new IncludeProcessor(graph);
        ArrayList<StringPair> finalEnvironmentDefines1 = finalEnvironmentDefines;
        this.sourceProvider = path -> {
            String pathString;
            String programString = pathString.substring((pathString = path.getPathString()).indexOf("/") == 0 ? 1 : 0, pathString.lastIndexOf("."));
            if (disabledPrograms.contains(programString)) {
                return null;
            }
            ImmutableList<String> lines = includeProcessor.getIncludedFile((AbsolutePackPath)path);
            if (lines == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                builder.append(line);
                builder.append('\n');
            }
            String source = builder.toString();
            source = ShaderPackWorkarounds.apply(source);
            source = JcppProcessor.glslPreprocessSource(source, finalEnvironmentDefines1);
            return source;
        };
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/"), this.sourceProvider, this.shaderProperties, this);
        this.idMap = new IdMap(root, this.shaderPackOptions, environmentDefines);
        this.customNoiseTexture = this.shaderProperties.getNoiseTexturePath().map(path -> {
            try {
                return this.readTexture(root, (String)path);
            }
            catch (IOException e) {
                Iris.logger.error(ShaderPack.jvmdowngrader$concat$lambda$new$10$1(path), e);
                return null;
            }
        }).orElse(null);
        this.shaderProperties.getCustomTextures().forEach((textureStage, customTexturePropertiesMap) -> {
            Object2ObjectOpenHashMap innerCustomTextureDataMap = new Object2ObjectOpenHashMap();
            customTexturePropertiesMap.forEach((arg_0, arg_1) -> this.lambda$new$12((Object2ObjectMap)innerCustomTextureDataMap, root, arg_0, arg_1));
            this.customTextureDataMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, CustomTextureData>)innerCustomTextureDataMap);
        });
        this.shaderProperties.getIrisCustomTextures().forEach((samplerName, definition) -> {
            try {
                this.irisCustomTextureDataMap.put(samplerName, (Object)this.readTexture(root, (TextureDefinition)definition));
                Iris.logger.debug("[CustomTextures] Loaded customTexture.{} from {}", samplerName, definition.getName());
            }
            catch (IOException e) {
                Iris.logger.error(ShaderPack.jvmdowngrader$concat$lambda$new$13$1(samplerName, definition.getName()), e);
            }
        });
        this.customUniforms = this.shaderProperties.getCustomUniforms();
        this.customImages = this.shaderProperties.getCustomImages();
        this.bufferObjects = this.shaderProperties.getBufferObjects();
    }

    private String getCurrentProfileName() {
        return this.profile.current.map(p -> p.name).orElse("Custom");
    }

    public String getProfileInfo() {
        return this.profileInfo;
    }

    private static Optional<Properties> loadPropertiesFile(Path shaderPath, String name) {
        String fileContents = ShaderPack.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        StringReader propertiesReader = new StringReader(fileContents);
        OrderBackedProperties properties = new OrderBackedProperties();
        try {
            properties.load(propertiesReader);
        }
        catch (IOException e) {
            Iris.logger.error(ShaderPack.jvmdowngrader$concat$loadPropertiesFile$1(name, String.valueOf(shaderPath)), e);
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    private List<String> parseDimensionMap(Properties properties, String keyPrefix) {
        ArrayList<String> folderNames = new ArrayList<String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            if (!key.startsWith(keyPrefix)) {
                return;
            }
            String folderName = key.substring(keyPrefix.length());
            if (folderName.isEmpty()) {
                Iris.logger.warn("Ignoring dimension.properties entry with empty folder name: {}", key);
                return;
            }
            List<String> dimensionNames = IdMap.parseIdentifierList(value, "dimension.properties", key);
            if (dimensionNames.isEmpty()) {
                Iris.logger.warn("Ignoring dimension.properties entry '{}' with no dimension names", key);
                return;
            }
            folderNames.add(folderName);
            for (String dimensionName : dimensionNames) {
                this.dimensionMap.put(dimensionName, folderName);
            }
        }));
        return folderNames;
    }

    private boolean checkAndAddDimensionFolder(ImmutableList.Builder<AbsolutePackPath> starts, Path root, ImmutableList<String> potentialFileNames, String folderName) throws IOException {
        return ShaderPackSourceNames.findPresentSources(starts, root, AbsolutePackPath.fromAbsolutePath(ShaderPack.jvmdowngrader$concat$checkAndAddDimensionFolder$1(folderName)), potentialFileNames);
    }

    public CustomTextureData readTexture(Path root, TextureDefinition definition) throws IOException {
        if (definition instanceof TextureDefinition.RawDefinition) {
            TextureDefinition.RawDefinition rawDef = (TextureDefinition.RawDefinition)definition;
            return this.readRawTexture(root, rawDef);
        }
        return this.readTexture(root, definition.getName());
    }

    private CustomTextureData readRawTexture(Path root, TextureDefinition.RawDefinition rawDef) throws IOException {
        CustomTextureData.RawData rawData;
        String path = rawDef.getName();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        boolean blur = false;
        boolean clamp = false;
        String mcMetaPath = ShaderPack.jvmdowngrader$concat$readRawTexture$1(path);
        Path mcMetaResolvedPath = root.resolve(mcMetaPath);
        if (Files.exists(mcMetaResolvedPath, new LinkOption[0])) {
            try {
                JsonObject meta = this.loadMcMeta(mcMetaResolvedPath);
                if (meta.get("texture") != null) {
                    if (meta.get("texture").getAsJsonObject().get("blur") != null) {
                        blur = meta.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                    }
                    if (meta.get("texture").getAsJsonObject().get("clamp") != null) {
                        clamp = meta.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
                    }
                }
            }
            catch (IOException e) {
                Iris.logger.error(ShaderPack.jvmdowngrader$concat$readRawTexture$1(mcMetaPath, String.valueOf(e)));
            }
        }
        byte[] content = Files.readAllBytes(root.resolve(path));
        TextureFilteringData filteringData = new TextureFilteringData(blur, clamp);
        switch (rawDef.getTarget()) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case TEXTURE_1D: {
                rawData = new CustomTextureData.RawData1D(content, filteringData, rawDef.getInternalFormat(), rawDef.getFormat(), rawDef.getPixelType(), rawDef.getSizeX());
                break;
            }
            case TEXTURE_2D: {
                rawData = new CustomTextureData.RawData2D(content, filteringData, rawDef.getInternalFormat(), rawDef.getFormat(), rawDef.getPixelType(), rawDef.getSizeX(), rawDef.getSizeY());
                break;
            }
            case TEXTURE_3D: {
                rawData = new CustomTextureData.RawData3D(content, filteringData, rawDef.getInternalFormat(), rawDef.getFormat(), rawDef.getPixelType(), rawDef.getSizeX(), rawDef.getSizeY(), rawDef.getSizeZ());
                break;
            }
            case TEXTURE_RECTANGLE: {
                rawData = new CustomTextureData.RawDataRect(content, filteringData, rawDef.getInternalFormat(), rawDef.getFormat(), rawDef.getPixelType(), rawDef.getSizeX(), rawDef.getSizeY());
            }
        }
        return rawData;
    }

    public CustomTextureData readTexture(Path root, String path) throws IOException {
        CustomTextureData customTextureData;
        if (path.contains(":")) {
            String[] parts = path.split(":");
            if (parts.length > 2) {
                Iris.logger.warn(ShaderPack.jvmdowngrader$concat$readTexture$1(path));
            }
            customTextureData = parts[0].equals("minecraft") && (parts[1].equals("dynamic/lightmap_1") || parts[1].equals("dynamic/light_map_1")) ? new CustomTextureData.LightmapMarker() : new CustomTextureData.ResourceData(parts[0], parts[1]);
        } else {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            boolean blur = false;
            boolean clamp = false;
            String mcMetaPath = ShaderPack.jvmdowngrader$concat$readRawTexture$1(path);
            Path mcMetaResolvedPath = root.resolve(mcMetaPath);
            if (Files.exists(mcMetaResolvedPath, new LinkOption[0])) {
                try {
                    JsonObject meta = this.loadMcMeta(mcMetaResolvedPath);
                    if (meta.get("texture") != null) {
                        if (meta.get("texture").getAsJsonObject().get("blur") != null) {
                            blur = meta.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                        }
                        if (meta.get("texture").getAsJsonObject().get("clamp") != null) {
                            clamp = meta.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
                        }
                    }
                }
                catch (IOException e) {
                    Iris.logger.error(ShaderPack.jvmdowngrader$concat$readRawTexture$1(mcMetaPath, String.valueOf(e)));
                }
            }
            byte[] content = Files.readAllBytes(root.resolve(path));
            customTextureData = new CustomTextureData.PngData(new TextureFilteringData(blur, clamp), content);
        }
        return customTextureData;
    }

    private JsonObject loadMcMeta(Path mcMetaPath) throws IOException, JsonParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(mcMetaPath, new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonReader jsonReader = new JsonReader((Reader)reader);
            JsonObject jsonObject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
            return jsonObject;
        }
    }

    private static String readProperties(Path shaderPath, String name) {
        try {
            return new String(Files.readAllBytes(shaderPath.resolve(name)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException e) {
            Iris.logger.debug(ShaderPack.jvmdowngrader$concat$readProperties$1(name));
            return null;
        }
        catch (IOException e) {
            Iris.logger.error(ShaderPack.jvmdowngrader$concat$readProperties$2(name), e);
            return null;
        }
    }

    private void evictOldDimensions() {
        HashSet<String> pinnedFolders = new HashSet<String>();
        for (String pinnedDimName : PINNED_DIMENSIONS) {
            String folder = this.dimensionMap.get(pinnedDimName);
            if (folder == null) continue;
            pinnedFolders.add(folder);
        }
        if (MAX_DIMENSION_CACHE == 0) {
            this.dimensionProgramSets.entrySet().removeIf(e -> !pinnedFolders.contains(e.getKey()));
            return;
        }
        int maxNonPinned = Math.max(0, MAX_DIMENSION_CACHE - PINNED_DIMENSIONS.size());
        for (long nonPinnedCount = this.dimensionProgramSets.entrySet().stream().filter(e -> !pinnedFolders.contains(e.getKey())).count(); nonPinnedCount > (long)maxNonPinned; --nonPinnedCount) {
            if (!this.hasLoggedCacheLimitReached) {
                Iris.logger.info("Dimension shader cache limit reached (max {} total: {} vanilla + {} modded). Now evicting least recently used dimensions.", MAX_DIMENSION_CACHE, PINNED_DIMENSIONS.size(), maxNonPinned);
                this.hasLoggedCacheLimitReached = true;
            }
            String toEvict = null;
            for (Map.Entry<String, ProgramSet> entry : this.dimensionProgramSets.entrySet()) {
                if (pinnedFolders.contains(entry.getKey())) continue;
                toEvict = entry.getKey();
                break;
            }
            if (toEvict == null) break;
            this.dimensionProgramSets.remove(toEvict);
        }
    }

    public ProgramSet getProgramSet(String dimensionName) {
        String worldFolder;
        boolean foundExactMatch;
        int dimensionId = Iris.getCurrentDimensionId();
        String folderName = this.dimensionMap.get(dimensionName);
        boolean bl = foundExactMatch = folderName != null;
        if (folderName == null) {
            folderName = this.dimensionMap.get("*");
        }
        if (folderName == null && this.foldersWithShaderFiles.contains(worldFolder = ShaderPack.jvmdowngrader$concat$getProgramSet$1(dimensionId))) {
            folderName = worldFolder;
        }
        if (folderName != null && this.foldersWithShaderFiles.contains(folderName)) {
            ProgramSet programSet = this.dimensionProgramSets.get(folderName);
            if (programSet == null) {
                try {
                    programSet = new ProgramSet(AbsolutePackPath.fromAbsolutePath(ShaderPack.jvmdowngrader$concat$checkAndAddDimensionFolder$1(folderName)), this.sourceProvider, this.shaderProperties, this);
                    this.dimensionProgramSets.put(folderName, programSet);
                    this.evictOldDimensions();
                }
                catch (Exception e) {
                    Iris.logger.error("Failed to create ProgramSet for dimension folder '{}', falling back to base", folderName, e);
                    programSet = null;
                }
            }
            if (programSet != null) {
                return programSet;
            }
        }
        if (!(this.dimensionMap.isEmpty() || foundExactMatch || this.dimensionMap.containsKey("*"))) {
            Iris.logger.warn("Dimension '{}' has no shader mapping in dimension.properties and no wildcard (*) fallback is defined. Falling back to base shaders. Consider adding 'dimension.<folder>={}' or 'dimension.<folder>=*' to dimension.properties", dimensionName, dimensionName);
        }
        return this.base;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public Set<FeatureFlags> getActiveFeatures() {
        return this.activeFeatures;
    }

    public boolean hasFeature(FeatureFlags feature) {
        return this.activeFeatures.contains((Object)feature);
    }

    @Generated
    public IdMap getIdMap() {
        return this.idMap;
    }

    @Generated
    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    @Generated
    public EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    @Generated
    public Object2ObjectMap<String, CustomTextureData> getIrisCustomTextureDataMap() {
        return this.irisCustomTextureDataMap;
    }

    @Generated
    public Object2ObjectMap<String, ImageInformation> getCustomImages() {
        return this.customImages;
    }

    @Generated
    public Int2ObjectMap<ShaderStorageInfo> getBufferObjects() {
        return this.bufferObjects;
    }

    @Generated
    public ShaderPackOptions getShaderPackOptions() {
        return this.shaderPackOptions;
    }

    @Generated
    public OptionMenuContainer getMenuContainer() {
        return this.menuContainer;
    }

    private /* synthetic */ void lambda$new$12(Object2ObjectMap innerCustomTextureDataMap, Path root, String samplerName, TextureDefinition definition) {
        try {
            innerCustomTextureDataMap.put((Object)samplerName, (Object)this.readTexture(root, definition));
        }
        catch (IOException e) {
            Iris.logger.error(ShaderPack.jvmdowngrader$concat$lambda$new$12$1(definition.getName()), e);
        }
    }

    static {
        int configured = Math.max(0, Integer.getInteger("iris.dimensionCacheSize", 12));
        MAX_DIMENSION_CACHE = configured == 0 ? 0 : Math.max(PINNED_DIMENSIONS.size(), configured);
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
        return "IRIS_FEATURE_" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, int n, String string2) {
        return "Profile: " + string + " (+" + n + " option" + string2 + " changed by user)";
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadPropertiesFile$1(String string, String string2) {
        return "Error loading " + string + " at " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkAndAddDimensionFolder$1(String string) {
        return "/" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readRawTexture$1(String string) {
        return string + ".mcmeta";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readRawTexture$1(String string, String string2) {
        return "Unable to read the custom texture mcmeta at " + string + ", ignoring: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readTexture$1(String string) {
        return "Resource location " + string + " contained more than two parts?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProperties$1(String string) {
        return "An " + string + " file was not found in the current shaderpack";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProperties$2(String string) {
        return "An IOException occurred reading " + string + " from the current shaderpack";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getProgramSet$1(int n) {
        return "world" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$13$1(String string, String string2) {
        return "Unable to read custom texture for sampler " + string + " at " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$12$1(String string) {
        return "Unable to read the custom texture at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$10$1(String string) {
        return "Unable to read the custom noise texture at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$4$1(String string, String string2) {
        return string + "=" + string2;
    }
}

